/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.citation;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;

@ThreadSafe
@XmlType(name="CI_Date_Type", propOrder={"date", "dateType"})
@XmlRootElement(name="CI_Date")
public class DefaultCitationDate
extends MetadataEntity
implements CitationDate {
    private static final long serialVersionUID = -2884791484254008454L;
    private long date;
    private DateType dateType;

    public DefaultCitationDate() {
        this.date = Long.MIN_VALUE;
    }

    public DefaultCitationDate(CitationDate citationDate) {
        super(citationDate);
        if (citationDate != null && this.date == 0L && citationDate.getDate() == null) {
            this.date = Long.MIN_VALUE;
        }
    }

    public DefaultCitationDate(Date date, DateType dateType) {
        this();
        this.setDate(date);
        this.setDateType(dateType);
    }

    public static DefaultCitationDate castOrCopy(CitationDate citationDate) {
        return citationDate == null || citationDate instanceof DefaultCitationDate ? (DefaultCitationDate)citationDate : new DefaultCitationDate(citationDate);
    }

    @XmlElement(name="date", required=true)
    public synchronized Date getDate() {
        return this.date != Long.MIN_VALUE ? new Date(this.date) : null;
    }

    public synchronized void setDate(Date date) {
        this.checkWritePermission();
        this.date = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @XmlElement(name="dateType", required=true)
    public synchronized DateType getDateType() {
        return this.dateType;
    }

    public synchronized void setDateType(DateType dateType) {
        this.checkWritePermission();
        this.dateType = dateType;
    }
}

