/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.extent;

import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.referencing.ProxyForMetadata;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.SpatialTemporalExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.TemporalPrimitive;

@ThreadSafe
@XmlType(name="EX_TemporalExtent_Type")
@XmlRootElement(name="EX_TemporalExtent")
@XmlSeeAlso(value={DefaultSpatialTemporalExtent.class})
public class DefaultTemporalExtent
extends MetadataEntity
implements TemporalExtent {
    private static final long serialVersionUID = 3668140516657118045L;
    private long startTime = Long.MIN_VALUE;
    private long endTime = Long.MIN_VALUE;
    private TemporalPrimitive extent;

    public DefaultTemporalExtent() {
    }

    public DefaultTemporalExtent(TemporalExtent temporalExtent) {
        super(temporalExtent);
    }

    public DefaultTemporalExtent(Envelope envelope) throws TransformException {
        ProxyForMetadata.getInstance().copy(envelope, this);
    }

    public DefaultTemporalExtent(Date date, Date date2) {
        this.setStartTime(date);
        this.setEndTime(date2);
    }

    public static DefaultTemporalExtent castOrCopy(TemporalExtent temporalExtent) {
        if (temporalExtent instanceof SpatialTemporalExtent) {
            return DefaultSpatialTemporalExtent.castOrCopy((SpatialTemporalExtent)temporalExtent);
        }
        return temporalExtent == null || temporalExtent instanceof DefaultTemporalExtent ? (DefaultTemporalExtent)temporalExtent : new DefaultTemporalExtent(temporalExtent);
    }

    private static Date getTime(long l, boolean bl) {
        if (l != Long.MIN_VALUE) {
            return new Date(l);
        }
        return null;
    }

    public synchronized Date getStartTime() {
        return DefaultTemporalExtent.getTime(this.startTime, true);
    }

    public synchronized void setStartTime(Date date) {
        this.checkWritePermission();
        this.startTime = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    public synchronized Date getEndTime() {
        return DefaultTemporalExtent.getTime(this.endTime, false);
    }

    public synchronized void setEndTime(Date date) {
        this.checkWritePermission();
        this.endTime = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    public synchronized TemporalPrimitive getExtent() {
        TemporalPrimitive temporalPrimitive = this.extent;
        if (temporalPrimitive == null) {
            // empty if block
        }
        return temporalPrimitive;
    }

    public synchronized void setExtent(TemporalPrimitive temporalPrimitive) {
        this.checkWritePermission();
        this.extent = temporalPrimitive;
    }
}

