/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.extent;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.referencing.ProxyForMetadata;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.TransformException;

@ThreadSafe
@XmlType(name="EX_VerticalExtent_Type", propOrder={"minimumValue", "maximumValue", "verticalCRS"})
@XmlRootElement(name="EX_VerticalExtent")
public class DefaultVerticalExtent
extends MetadataEntity
implements VerticalExtent {
    private static final long serialVersionUID = -3214554246909844079L;
    private Double minimumValue;
    private Double maximumValue;
    private VerticalCRS verticalCRS;

    public DefaultVerticalExtent() {
    }

    public DefaultVerticalExtent(VerticalExtent verticalExtent) {
        super(verticalExtent);
    }

    public DefaultVerticalExtent(Envelope envelope) throws TransformException {
        ProxyForMetadata.getInstance().copy(envelope, this);
    }

    public DefaultVerticalExtent(Double d, Double d2, VerticalCRS verticalCRS) {
        this.setMinimumValue(d);
        this.setMaximumValue(d2);
        this.setVerticalCRS(verticalCRS);
    }

    public static DefaultVerticalExtent castOrCopy(VerticalExtent verticalExtent) {
        return verticalExtent == null || verticalExtent instanceof DefaultVerticalExtent ? (DefaultVerticalExtent)verticalExtent : new DefaultVerticalExtent(verticalExtent);
    }

    @XmlElement(name="minimumValue", required=true)
    public synchronized Double getMinimumValue() {
        return this.minimumValue;
    }

    public synchronized void setMinimumValue(Double d) {
        this.checkWritePermission();
        this.minimumValue = d;
    }

    @XmlElement(name="maximumValue", required=true)
    public synchronized Double getMaximumValue() {
        return this.maximumValue;
    }

    public synchronized void setMaximumValue(Double d) {
        this.checkWritePermission();
        this.maximumValue = d;
    }

    @XmlElement(name="verticalCRS", required=true)
    public synchronized VerticalCRS getVerticalCRS() {
        return this.verticalCRS;
    }

    public synchronized void setVerticalCRS(VerticalCRS verticalCRS) {
        this.checkWritePermission();
        this.verticalCRS = verticalCRS;
    }
}

