/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.naming;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.Immutable;
import org.geotoolkit.naming.DefaultNameSpace;
import org.geotoolkit.naming.DefaultScopedName;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.Utilities;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

@XmlType(name="GenericName")
public abstract class AbstractName
implements GenericName,
Serializable {
    private static final long serialVersionUID = 3362498790089164525L;
    transient GenericName fullyQualified;
    transient CharSequence asString;
    transient int hash;

    protected AbstractName() {
    }

    public abstract NameSpace scope();

    public int depth() {
        return this.getParsedNames().size();
    }

    int arraySize() {
        return this.depth();
    }

    public abstract List<? extends LocalName> getParsedNames();

    public LocalName head() {
        return this.getParsedNames().get(0);
    }

    public LocalName tip() {
        List<? extends LocalName> list = this.getParsedNames();
        return list.get(list.size() - 1);
    }

    public synchronized GenericName toFullyQualifiedName() {
        if (this.fullyQualified == null) {
            NameSpace nameSpace = this.scope();
            if (nameSpace.isGlobal()) {
                this.fullyQualified = this;
            } else {
                GenericName genericName = nameSpace.name();
                assert (genericName.scope().isGlobal()) : genericName;
                this.fullyQualified = new DefaultScopedName(genericName, this);
            }
        }
        return this.fullyQualified;
    }

    public ScopedName push(GenericName genericName) {
        return new DefaultScopedName(genericName, this);
    }

    static String separator(GenericName genericName) {
        NameSpace nameSpace;
        if (genericName != null && (nameSpace = genericName.scope()) instanceof DefaultNameSpace) {
            return ((DefaultNameSpace)nameSpace).headSeparator;
        }
        return ":";
    }

    public synchronized String toString() {
        if (this.asString == null) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (LocalName localName : this.getParsedNames()) {
                if (bl) {
                    stringBuilder.append(AbstractName.separator((GenericName)localName));
                }
                bl = true;
                stringBuilder.append(localName);
            }
            this.asString = stringBuilder.toString();
        }
        return ((Object)this.asString).toString();
    }

    public synchronized InternationalString toInternationalString() {
        if (!(this.asString instanceof InternationalString)) {
            this.asString = new International(this.toString(), this.getParsedNames());
        }
        return (InternationalString)this.asString;
    }

    public int compareTo(GenericName genericName) {
        Iterator<? extends LocalName> iterator = this.getParsedNames().iterator();
        Iterator iterator2 = genericName.getParsedNames().iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return 1;
            }
            LocalName localName = iterator.next();
            LocalName localName2 = (LocalName)iterator2.next();
            if (localName == this && localName2 == genericName) {
                throw new IllegalStateException();
            }
            int n = localName.compareTo((Object)localName2);
            if (n == 0) continue;
            return n;
        }
        return iterator2.hasNext() ? -1 : 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            AbstractName abstractName = (AbstractName)object;
            return Utilities.equals((Object)this.scope(), (Object)abstractName.scope()) && Utilities.equals(this.getParsedNames(), abstractName.getParsedNames());
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            List<? extends LocalName> list;
            int n = -1796077843;
            NameSpace nameSpace = this.scope();
            if (nameSpace != null) {
                n ^= nameSpace.hashCode();
            }
            if ((list = this.getParsedNames()) != null) {
                n += ((Object)list).hashCode();
            }
            this.hash = n;
        }
        return this.hash;
    }

    @Immutable
    private static final class International
    extends SimpleInternationalString {
        private static final long serialVersionUID = -6422809765366372062L;
        private final List<? extends LocalName> parsedNames;

        public International(String string, List<? extends LocalName> list) {
            super(string);
            this.parsedNames = list;
        }

        public String toString(Locale locale) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (LocalName localName : this.parsedNames) {
                if (bl) {
                    stringBuilder.append(AbstractName.separator((GenericName)localName));
                }
                bl = true;
                stringBuilder.append(localName.toInternationalString().toString(locale));
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (super.equals(object)) {
                International international = (International)((Object)object);
                return Utilities.equals(this.parsedNames, international.parsedNames);
            }
            return false;
        }
    }
}

