/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.geometry.AbstractEnvelope;
import org.geotoolkit.geometry.ArrayEnvelope;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.math.XMath;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Cloneable;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

public class GeneralEnvelope
extends ArrayEnvelope
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1752330560227688940L;
    private static volatile Field ordinatesField;

    public GeneralEnvelope(int n) {
        super(n);
    }

    public GeneralEnvelope(double d, double d2) {
        super(d, d2);
    }

    public GeneralEnvelope(double[] dArray, double[] dArray2) {
        super(dArray, dArray2);
    }

    public GeneralEnvelope(GeneralDirectPosition generalDirectPosition, GeneralDirectPosition generalDirectPosition2) throws IllegalArgumentException {
        super(generalDirectPosition.ordinates, generalDirectPosition2.ordinates);
        this.crs = GeneralEnvelope.getCoordinateReferenceSystem(generalDirectPosition, generalDirectPosition2);
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(this.crs, this.ordinates.length >>> 1);
    }

    public GeneralEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) {
        super(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        this.crs = coordinateReferenceSystem;
    }

    public GeneralEnvelope(Envelope envelope) {
        super(envelope);
    }

    public GeneralEnvelope(GeographicBoundingBox geographicBoundingBox) {
        super(geographicBoundingBox);
    }

    public GeneralEnvelope(Rectangle2D rectangle2D) {
        super(rectangle2D);
    }

    public GeneralEnvelope(String string) throws NumberFormatException, IllegalArgumentException {
        super(string);
    }

    public static GeneralEnvelope castOrCopy(Envelope envelope) {
        if (envelope == null || envelope instanceof GeneralEnvelope) {
            return (GeneralEnvelope)envelope;
        }
        return new GeneralEnvelope(envelope);
    }

    @Override
    public final int getDimension() {
        return super.getDimension();
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return super.getCoordinateReferenceSystem();
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, this.getDimension());
        this.crs = coordinateReferenceSystem;
    }

    public boolean reduceToDomain(boolean bl) {
        boolean bl2 = false;
        if (this.crs != null) {
            Envelope envelope;
            CoordinateSystemAxis coordinateSystemAxis;
            int n = this.ordinates.length >>> 1;
            CoordinateSystem coordinateSystem = this.crs.getCoordinateSystem();
            for (int i = 0; i < n; ++i) {
                double d;
                int n2 = i + n;
                coordinateSystemAxis = coordinateSystem.getAxis(i);
                double d2 = coordinateSystemAxis.getMinimumValue();
                double d3 = coordinateSystemAxis.getMaximumValue();
                RangeMeaning rangeMeaning = coordinateSystemAxis.getRangeMeaning();
                if (RangeMeaning.EXACT.equals((Object)rangeMeaning)) {
                    if (this.ordinates[i] < d2) {
                        this.ordinates[i] = d2;
                        bl2 = true;
                    }
                    if (!(this.ordinates[n2] > d3)) continue;
                    this.ordinates[n2] = d3;
                    bl2 = true;
                    continue;
                }
                if (!RangeMeaning.WRAPAROUND.equals((Object)rangeMeaning) || !((d = d3 - d2) > 0.0) || !(d < Double.POSITIVE_INFINITY)) continue;
                double d4 = this.ordinates[i];
                double d5 = this.ordinates[n2];
                if (d4 <= d2 && d5 >= d3) {
                    bl2 |= d4 != d2 || d5 != d3;
                    this.ordinates[i] = d2;
                    this.ordinates[n2] = d3;
                    continue;
                }
                d4 = Math.floor((d4 - d2) / d) * d;
                d5 = Math.floor((d5 - d2) / d) * d;
                if (d4 != 0.0) {
                    int n3 = i;
                    this.ordinates[n3] = this.ordinates[n3] - d4;
                    bl2 = true;
                }
                if (d5 != 0.0) {
                    int n4 = n2;
                    this.ordinates[n4] = this.ordinates[n4] - d5;
                    bl2 = true;
                }
                if (this.ordinates[i] != this.ordinates[n2] || d4 == d5) continue;
                this.ordinates[i] = 0.0;
                this.ordinates[n2] = -0.0;
            }
            if (bl && (envelope = Envelopes.getDomainOfValidity(this.crs)) != null) {
                GeneralEnvelope generalEnvelope = new GeneralEnvelope(this);
                coordinateSystemAxis = envelope.getCoordinateReferenceSystem();
                if (!GeneralEnvelope.equalsIgnoreMetadata(this.crs, (CoordinateReferenceSystem)coordinateSystemAxis, false)) {
                    CoordinateSystem coordinateSystem2 = coordinateSystemAxis.getCoordinateSystem();
                    int n5 = coordinateSystem2.getDimension();
                    for (int i = 0; i < n5; ++i) {
                        AxisDirection axisDirection = coordinateSystem2.getAxis(i).getDirection();
                        for (int j = 0; j < n; ++j) {
                            if (!axisDirection.equals((Object)coordinateSystem.getAxis(j).getDirection())) continue;
                            this.ordinates[j] = envelope.getMinimum(i);
                            this.ordinates[j + n] = envelope.getMaximum(i);
                        }
                    }
                    envelope = generalEnvelope;
                }
                this.intersect(envelope);
                if (!bl2) {
                    bl2 = !this.equals(generalEnvelope, 0.0, false);
                }
            }
        }
        return bl2;
    }

    public boolean reorderCorners() throws IllegalStateException {
        boolean bl = false;
        int n = this.ordinates.length >>> 1;
        for (int i = 0; i < n; ++i) {
            int n2 = i + n;
            if (!XMath.isNegative((double)(this.ordinates[n2] - this.ordinates[i]))) continue;
            CoordinateSystemAxis coordinateSystemAxis = GeneralEnvelope.getAxis(this.crs, i);
            if (coordinateSystemAxis != null && RangeMeaning.WRAPAROUND.equals((Object)coordinateSystemAxis.getRangeMeaning())) {
                this.ordinates[i] = coordinateSystemAxis.getMinimumValue();
                this.ordinates[n2] = coordinateSystemAxis.getMaximumValue();
                bl = true;
                continue;
            }
            throw new IllegalStateException(Errors.format((int)107));
        }
        return bl;
    }

    public void roundIfAlmostInteger(double d, int n) {
        ArgumentChecks.ensureStrictlyPositive((String)"factor", (double)d);
        for (int i = 0; i < this.ordinates.length; ++i) {
            this.ordinates[i] = InternalUtilities.adjustForRoundingError((double)this.ordinates[i], (double)d, (int)n);
        }
    }

    public void setRange(int n, double d, double d2) throws IndexOutOfBoundsException {
        int n2 = this.ordinates.length >>> 1;
        ArgumentChecks.ensureValidIndex((int)n2, (int)n);
        this.ordinates[n + n2] = d2;
        this.ordinates[n] = d;
    }

    public void setEnvelope(double ... dArray) {
        if ((dArray.length & 1) != 0) {
            throw new IllegalArgumentException(Errors.format((int)178, (Object)dArray.length));
        }
        int n = dArray.length >>> 1;
        int n2 = this.ordinates.length >>> 1;
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format((int)113, (Object)"ordinates", (Object)n, (Object)n2));
        }
        System.arraycopy(dArray, 0, this.ordinates, 0, dArray.length);
    }

    public void setEnvelope(Envelope envelope) throws MismatchedDimensionException {
        DirectPosition directPosition;
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        if (envelope instanceof ArrayEnvelope) {
            System.arraycopy(((ArrayEnvelope)envelope).ordinates, 0, this.ordinates, 0, this.ordinates.length);
        } else {
            directPosition = envelope.getLowerCorner();
            DirectPosition directPosition2 = envelope.getUpperCorner();
            for (int i = 0; i < n; ++i) {
                this.ordinates[i] = directPosition.getOrdinate(i);
                this.ordinates[i + n] = directPosition2.getOrdinate(i);
            }
        }
        directPosition = envelope.getCoordinateReferenceSystem();
        if (directPosition != null) {
            this.crs = directPosition;
            assert (this.crs.getCoordinateSystem().getDimension() == this.getDimension()) : this.crs;
            assert (envelope.getClass() != this.getClass() || this.equals(envelope)) : envelope;
        }
    }

    public void setSubEnvelope(Envelope envelope, int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n2 = envelope.getDimension();
        int n3 = this.ordinates.length >>> 1;
        if (n < 0 || n + n2 > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"lower", (Object)n));
        }
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        for (int i = 0; i < n2; ++i) {
            this.ordinates[n] = directPosition.getOrdinate(i);
            this.ordinates[n + n3] = directPosition2.getOrdinate(i);
            ++n;
        }
    }

    public GeneralEnvelope getSubEnvelope(int n, int n2) throws IndexOutOfBoundsException {
        int n3 = this.ordinates.length >>> 1;
        int n4 = n2 - n;
        if (n < 0 || n > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"lower", (Object)n));
        }
        if (n4 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"upper", (Object)n2));
        }
        if (n4 == n3) {
            return this;
        }
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(n4);
        System.arraycopy(this.ordinates, n, generalEnvelope.ordinates, 0, n4);
        System.arraycopy(this.ordinates, n + n3, generalEnvelope.ordinates, n4, n4);
        return generalEnvelope;
    }

    @Deprecated
    public GeneralEnvelope getReducedEnvelope(int n, int n2) throws IndexOutOfBoundsException {
        int n3 = this.ordinates.length >>> 1;
        int n4 = n2 - n;
        if (n < 0 || n > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"lower", (Object)n));
        }
        if (n4 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"upper", (Object)n2));
        }
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(n3 - n4);
        System.arraycopy(this.ordinates, 0, generalEnvelope.ordinates, 0, n);
        System.arraycopy(this.ordinates, n, generalEnvelope.ordinates, n2, n3 - n2);
        return generalEnvelope;
    }

    public void setToInfinite() {
        int n = this.ordinates.length >>> 1;
        Arrays.fill(this.ordinates, 0, n, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.ordinates, n, this.ordinates.length, Double.POSITIVE_INFINITY);
        assert (this.isInfinite()) : this;
    }

    public boolean isInfinite() {
        for (int i = 0; i < this.ordinates.length; ++i) {
            if (!Double.isInfinite(this.ordinates[i])) continue;
            return true;
        }
        return false;
    }

    public void setToNull() {
        Arrays.fill(this.ordinates, Double.NaN);
        assert (this.isNull()) : this;
    }

    final void add(double[] dArray, int n) {
        int n2 = this.ordinates.length >>> 1;
        for (int i = 0; i < n2; ++i) {
            double d = dArray[n + i];
            if (d < this.ordinates[i]) {
                this.ordinates[i] = d;
            }
            if (!(d > this.ordinates[i + n2])) continue;
            this.ordinates[i + n2] = d;
        }
    }

    public void add(DirectPosition directPosition) throws MismatchedDimensionException, AssertionError {
        ArgumentChecks.ensureNonNull((String)"position", (Object)directPosition);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("position", directPosition.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, directPosition.getCoordinateReferenceSystem(), true)) : directPosition;
        for (int i = 0; i < n; ++i) {
            double d = directPosition.getOrdinate(i);
            double d2 = this.ordinates[i + n];
            double d3 = this.ordinates[i];
            if (!XMath.isNegative((double)(d2 - d3))) {
                if (d < d3) {
                    this.ordinates[i] = d;
                }
                if (!(d > d2)) continue;
                this.ordinates[i + n] = d;
                continue;
            }
            this.addToClosest(i, d, d2, d3);
        }
        assert (this.contains(directPosition) || this.isEmpty() || GeneralEnvelope.hasNaN(directPosition)) : directPosition;
    }

    private void addToClosest(int n, double d, double d2, double d3) {
        if ((d2 = d - d2) > 0.0 && (d3 -= d) > 0.0) {
            if (d3 > d2) {
                n += this.ordinates.length >>> 1;
            }
            this.ordinates[n] = d;
        }
    }

    public void add(Envelope envelope) throws MismatchedDimensionException, AssertionError {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem(), true)) : envelope;
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        for (int i = 0; i < n; ++i) {
            double d;
            double d2;
            boolean bl;
            double d3 = this.ordinates[i];
            double d4 = this.ordinates[i + n];
            double d5 = directPosition.getOrdinate(i);
            double d6 = directPosition2.getOrdinate(i);
            boolean bl2 = XMath.isNegative((double)(d4 - d3));
            if (bl2 == (bl = XMath.isNegative((double)(d6 - d5)))) {
                if (d5 < d3) {
                    this.ordinates[i] = d5;
                }
                if (d6 > d4) {
                    this.ordinates[i + n] = d6;
                }
                if (!bl2 || GeneralEnvelope.isNegativeUnsafe(this.ordinates[i + n] - this.ordinates[i])) {
                    continue;
                }
            } else if (bl2) {
                if (d6 <= d4 || d5 >= d3) continue;
                d2 = d5 - d4;
                d = d3 - d6;
                if (d2 > 0.0 || d > 0.0) {
                    if (d2 > d) {
                        this.ordinates[i] = d5;
                    }
                    if (!(d > d2)) continue;
                    this.ordinates[i + n] = d6;
                    continue;
                }
            } else {
                if (d4 <= d6 || d3 >= d5) {
                    this.ordinates[i] = d5;
                    this.ordinates[i + n] = d6;
                    continue;
                }
                d2 = d3 - d6;
                d = d5 - d4;
                if (d2 > 0.0 || d > 0.0) {
                    if (d2 > d) {
                        this.ordinates[i + n] = d6;
                    }
                    if (!(d > d2)) continue;
                    this.ordinates[i] = d5;
                    continue;
                }
            }
            if (bl2) {
                this.ordinates[i] = 0.0;
                this.ordinates[i + n] = -0.0;
                continue;
            }
            this.ordinates[i] = Double.NEGATIVE_INFINITY;
            this.ordinates[i + n] = Double.POSITIVE_INFINITY;
        }
        assert (this.contains(envelope, true) || this.isEmpty() || GeneralEnvelope.hasNaN(envelope)) : this;
    }

    public void intersect(Envelope envelope) throws MismatchedDimensionException, AssertionError {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem(), true)) : envelope;
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        block5: for (int i = 0; i < n; ++i) {
            double d = this.ordinates[i];
            double d2 = this.ordinates[i + n];
            double d3 = directPosition.getOrdinate(i);
            double d4 = d2 - d;
            double d5 = directPosition2.getOrdinate(i);
            double d6 = d5 - d3;
            if (XMath.isSameSign((double)d4, (double)d6)) {
                if ((d3 > d2 || d5 < d) && !GeneralEnvelope.isNegativeUnsafe(d4)) {
                    this.ordinates[i + n] = Double.NaN;
                    this.ordinates[i] = Double.NaN;
                    continue;
                }
            } else {
                int n2 = 0;
                if (!Double.isNaN(d4) && !Double.isNaN(d6)) {
                    if (GeneralEnvelope.isNegativeUnsafe(d4)) {
                        if (d3 <= d2) {
                            n2 = 1;
                            this.ordinates[i] = d3;
                        }
                        if (d5 >= d) {
                            n2 |= 2;
                            this.ordinates[i + n] = d5;
                        }
                    } else {
                        if (d <= d5) {
                            n2 = 1;
                        }
                        if (d2 >= d3) {
                            n2 |= 2;
                        }
                    }
                }
                switch (n2) {
                    default: {
                        throw new AssertionError(n2);
                    }
                    case 1: {
                        if (!(d5 < d2)) continue block5;
                        this.ordinates[i + n] = d5;
                        break;
                    }
                    case 2: {
                        if (!(d3 > d)) continue block5;
                        this.ordinates[i] = d3;
                        break;
                    }
                    case 0: 
                    case 3: {
                        double d7;
                        double d8;
                        double d9 = GeneralEnvelope.getSpan(GeneralEnvelope.getAxis(this.crs, i));
                        if (d6 >= d9) {
                            d8 = d;
                            d7 = d2;
                        } else if (d4 >= d9) {
                            d8 = d3;
                            d7 = d5;
                        } else {
                            d8 = Double.NaN;
                            d7 = Double.NaN;
                        }
                        this.ordinates[i] = d8;
                        this.ordinates[i + n] = d7;
                        break;
                    }
                }
                continue;
            }
            if (d3 > d) {
                this.ordinates[i] = d3;
            }
            if (!(d5 < d2)) continue;
            this.ordinates[i + n] = d5;
        }
        assert (this.isEmpty() || AbstractEnvelope.castOrCopy(envelope).contains(this, true)) : this;
    }

    public GeneralEnvelope clone() {
        try {
            Field field = ordinatesField;
            if (field == null) {
                field = ArrayEnvelope.class.getDeclaredField("ordinates");
                field.setAccessible(true);
                ordinatesField = field;
            }
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)super.clone();
            field.set(generalEnvelope, this.ordinates.clone());
            return generalEnvelope;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError((Object)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }
}

