/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.geometry.ArrayEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Immutable
public final class ImmutableEnvelope
extends ArrayEnvelope
implements Serializable {
    private static final long serialVersionUID = 5593936512712449234L;

    public ImmutableEnvelope(Envelope envelope) {
        super(envelope);
    }

    public ImmutableEnvelope(GeographicBoundingBox geographicBoundingBox) {
        super(geographicBoundingBox);
    }

    public ImmutableEnvelope(CoordinateReferenceSystem coordinateReferenceSystem, Envelope envelope) throws MismatchedDimensionException {
        super(envelope);
        this.crs = coordinateReferenceSystem;
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, this.getDimension());
    }

    public ImmutableEnvelope(CoordinateReferenceSystem coordinateReferenceSystem, double d, double d2, double d3, double d4) throws MismatchedDimensionException {
        super(d, d2, d3, d4);
        this.crs = coordinateReferenceSystem;
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, 2);
    }

    public ImmutableEnvelope(CoordinateReferenceSystem coordinateReferenceSystem, String string) throws NumberFormatException, IllegalArgumentException, MismatchedDimensionException {
        super(string);
        this.crs = coordinateReferenceSystem;
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, this.getDimension());
    }

    public static ImmutableEnvelope castOrCopy(Envelope envelope) {
        if (envelope == null || envelope instanceof ImmutableEnvelope) {
            return (ImmutableEnvelope)envelope;
        }
        return new ImmutableEnvelope(envelope);
    }
}

