/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.io.Console;
import java.io.PrintWriter;
import org.geotoolkit.io.X364;
import org.geotoolkit.io.wkt.Colors;
import org.geotoolkit.io.wkt.Convention;
import org.geotoolkit.io.wkt.Formattable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.io.wkt.UnformattableObjectException;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultResponsibleParty;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.converter.Classes;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;

public class FormattableObject
implements Formattable {
    private static final ThreadLocal<Formatter> FORMATTER = new ThreadLocal();
    @Deprecated
    public static final int SINGLE_LINE = 0;
    @Deprecated
    public static final Citation OGC = Citations.OGC;
    @Deprecated
    public static final Citation EPSG = Citations.EPSG;
    @Deprecated
    public static final Citation GEOTIFF = Citations.GEOTIFF;
    @Deprecated
    public static final Citation INTERNAL;
    static volatile int defaultIndentation;

    protected FormattableObject() {
    }

    public void print() {
        PrintWriter printWriter = null;
        Console console = System.console();
        if (console != null) {
            printWriter = console.writer();
        }
        boolean bl = printWriter != null && X364.isSupported();
        String string = this.formatWKT(Convention.OGC, defaultIndentation, bl, false);
        if (printWriter != null) {
            printWriter.println(string);
        } else {
            System.out.println(string);
        }
    }

    public String toString() {
        return this.formatWKT(Convention.OGC, defaultIndentation, false, false);
    }

    public String toWKT() throws UnformattableObjectException {
        return this.formatWKT(Convention.OGC, defaultIndentation, false, true);
    }

    @Deprecated
    public String toWKT(int n) throws UnformattableObjectException {
        return this.formatWKT(Convention.OGC, n, false, true);
    }

    @Deprecated
    public String toWKT(Citation citation, int n) throws UnformattableObjectException {
        return this.toWKT(Convention.forCitation(citation, Convention.OGC), n);
    }

    public String toWKT(Convention convention, int n) throws UnformattableObjectException {
        ArgumentChecks.ensureNonNull((String)"convention", (Object)((Object)convention));
        return this.formatWKT(convention, n, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatWKT(Convention convention, int n, boolean bl, boolean bl2) throws UnformattableObjectException {
        Formatter formatter = FORMATTER.get();
        if (formatter == null) {
            formatter = new Formatter();
            FORMATTER.set(formatter);
        }
        formatter.indentation = n;
        formatter.colors = bl ? Colors.DEFAULT : null;
        formatter.setConvention(convention, null);
        try {
            if (this instanceof GeneralParameterValue) {
                formatter.append((GeneralParameterValue)this);
            } else {
                formatter.append(this);
            }
            if (bl2 && formatter.isInvalidWKT() && formatter.getConvention() != Convention.INTERNAL) {
                Class<?> clazz = formatter.getUnformattableClass();
                throw new UnformattableObjectException(formatter.warning, clazz);
            }
            String string = formatter.toString();
            return string;
        }
        finally {
            formatter.clear();
        }
    }

    @Override
    public String formatWKT(Formatter formatter) {
        Class<?>[] classArray;
        Class<?> clazz = this.getClass();
        formatter.setInvalidWKT(clazz);
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            String string = clazz2.getName();
            if (!string.startsWith("org.opengis.") || string.startsWith("org.opengis.util.")) continue;
            clazz = clazz2;
            break;
        }
        return Classes.getShortName(clazz);
    }

    @Deprecated
    public static int getDefaultIndentation() {
        return defaultIndentation;
    }

    @Deprecated
    public static void setDefaultIndentation(int n) {
        defaultIndentation = n;
    }

    static {
        DefaultCitation defaultCitation = new DefaultCitation((CharSequence)"Internal WKT");
        defaultCitation.getCitedResponsibleParties().add(DefaultResponsibleParty.GEOTOOLKIT);
        defaultCitation.freeze();
        INTERNAL = defaultCitation;
        defaultIndentation = 2;
    }
}

