/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.measure.Units;
import org.geotoolkit.parameter.AbstractParameterValue;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.CodeList;

public class Parameter<T>
extends AbstractParameterValue<T> {
    private static final long serialVersionUID = -5837826787089486776L;
    private T value;
    private Unit<?> unit;

    public Parameter(ParameterDescriptor<T> parameterDescriptor) {
        super(parameterDescriptor);
        this.value = parameterDescriptor.getDefaultValue();
        this.unit = parameterDescriptor.getUnit();
    }

    public Parameter(ParameterDescriptor<T> parameterDescriptor, T t) throws InvalidParameterValueException {
        super(parameterDescriptor);
        this.unit = parameterDescriptor.getUnit();
        this.setValue(t);
    }

    public static Parameter<Integer> create(String string, int n) {
        DefaultParameterDescriptor<Object> defaultParameterDescriptor = new DefaultParameterDescriptor<Object>(string, Integer.class, null, null);
        Parameter<Object> parameter = new Parameter<Object>((ParameterDescriptor<Object>)defaultParameterDescriptor);
        parameter.value = n;
        return parameter;
    }

    public static Parameter<Double> create(String string, double d, Unit<?> baseUnit) {
        if (baseUnit != null) {
            if (Units.isLinear(baseUnit)) {
                baseUnit = SI.METRE;
            } else if (Units.isTemporal((Unit)baseUnit)) {
                baseUnit = NonSI.DAY;
            } else if (Units.isAngular((Unit)baseUnit)) {
                baseUnit = NonSI.DEGREE_ANGLE;
            }
        }
        DefaultParameterDescriptor<Double> defaultParameterDescriptor = DefaultParameterDescriptor.create(string, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, baseUnit);
        Parameter<Double> parameter = new Parameter<Double>((ParameterDescriptor<Double>)defaultParameterDescriptor);
        parameter.value = d;
        parameter.unit = baseUnit;
        return parameter;
    }

    public static <T extends CodeList<T>> Parameter<T> create(String string, Class<T> clazz, T t) {
        DefaultParameterDescriptor<Object> defaultParameterDescriptor = new DefaultParameterDescriptor<Object>(string, null, clazz, null, true);
        Parameter<Object> parameter = new Parameter<Object>((ParameterDescriptor<Object>)defaultParameterDescriptor);
        parameter.value = t;
        return parameter;
    }

    private String getClassTypeError() {
        return Errors.format((int)87, (Object)((ParameterDescriptor)this.descriptor).getValueClass());
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    public double doubleValue(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        Unit<?> unit2 = this.getUnit();
        if (unit2 == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        int n = Parameter.getUnitMessageID(unit2);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format((int)n, unit));
        }
        try {
            return unit2.getConverterToAny(unit).convert(this.doubleValue());
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(Errors.format((int)92, unit), conversionException);
        }
    }

    public double doubleValue() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof Number) {
            return ((Number)t).doubleValue();
        }
        String string = Parameter.getName(this.descriptor);
        if (t == null) {
            throw new IllegalStateException(Errors.format((int)119, (Object)string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    public int intValue() throws IllegalStateException {
        int n;
        T t = this.getValue();
        if (t instanceof Number && (double)(n = ((Number)t).intValue()) == ((Number)t).doubleValue()) {
            return n;
        }
        String string = Parameter.getName(this.descriptor);
        if (t == null) {
            throw new IllegalStateException(Errors.format((int)119, (Object)string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    public boolean booleanValue() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof Boolean) {
            return (Boolean)t;
        }
        String string = Parameter.getName(this.descriptor);
        if (t == null) {
            throw new IllegalStateException(Errors.format((int)119, (Object)string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    public String stringValue() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof CharSequence) {
            return t.toString();
        }
        String string = Parameter.getName(this.descriptor);
        if (t == null) {
            throw new IllegalStateException(Errors.format((int)119, (Object)string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        UnitConverter unitConverter;
        Unit<?> unit2 = this.getUnit();
        if (unit2 == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        int n = Parameter.getUnitMessageID(unit2);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format((int)n, unit));
        }
        try {
            unitConverter = unit2.getConverterToAny(unit);
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(Errors.format((int)92, unit), conversionException);
        }
        double[] dArray = (double[])this.doubleValueList().clone();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = unitConverter.convert(dArray[i]);
        }
        return dArray;
    }

    public double[] doubleValueList() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof double[]) {
            return (double[])t;
        }
        String string = Parameter.getName(this.descriptor);
        if (t == null) {
            throw new IllegalStateException(Errors.format((int)119, (Object)string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    public int[] intValueList() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof int[]) {
            return (int[])t;
        }
        String string = Parameter.getName(this.descriptor);
        if (t == null) {
            throw new IllegalStateException(Errors.format((int)119, (Object)string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    public URI valueFile() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof URI) {
            return (URI)t;
        }
        if (t instanceof File) {
            return ((File)t).toURI();
        }
        URISyntaxException uRISyntaxException = null;
        try {
            if (t instanceof URL) {
                return ((URL)t).toURI();
            }
            if (t instanceof String) {
                return new URI(IOUtilities.encodeURI((String)((String)t)));
            }
        }
        catch (URISyntaxException uRISyntaxException2) {
            uRISyntaxException = uRISyntaxException2;
        }
        String string = Parameter.getName(this.descriptor);
        if (t == null) {
            throw new IllegalStateException(Errors.format((int)119, (Object)string));
        }
        InvalidParameterTypeException invalidParameterTypeException = new InvalidParameterTypeException(this.getClassTypeError(), string);
        if (uRISyntaxException != null) {
            invalidParameterTypeException.initCause((Throwable)uRISyntaxException);
        }
        throw invalidParameterTypeException;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(double d, Unit<?> unit) throws InvalidParameterValueException {
        Double d2;
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Unit unit2 = parameterDescriptor.getUnit();
        if (unit2 == null) {
            throw Parameter.unitlessParameter((GeneralParameterDescriptor)parameterDescriptor);
        }
        int n = Parameter.getUnitMessageID(unit2);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new InvalidParameterValueException(Errors.format((int)n, unit), parameterDescriptor.getName().getCode(), d);
        }
        try {
            d2 = unit.getConverterToAny(unit2).convert(d);
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(Errors.format((int)92, unit), conversionException);
        }
        Parameter.ensureValidValue(parameterDescriptor, d2);
        this.setSafeValue(parameterDescriptor.getValueClass().cast(d), unit);
    }

    public void setValue(double d) throws InvalidParameterValueException {
        this.setSafeValue(Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, d), this.unit);
    }

    public void setValue(int n) throws InvalidParameterValueException {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Class clazz = parameterDescriptor.getValueClass();
        if (clazz == Double.class || clazz == Float.class) {
            this.setValue((double)n);
        } else {
            this.setSafeValue(Parameter.ensureValidValue(parameterDescriptor, n), this.unit);
        }
    }

    public void setValue(boolean bl) throws InvalidParameterValueException {
        this.setSafeValue(Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, bl), this.unit);
    }

    public void setValue(Object object) throws InvalidParameterValueException {
        this.setSafeValue(Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, object), this.unit);
    }

    public void setValue(double[] dArray, Unit<?> unit) throws InvalidParameterValueException {
        UnitConverter unitConverter;
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Unit unit2 = parameterDescriptor.getUnit();
        if (unit2 == null) {
            throw Parameter.unitlessParameter((GeneralParameterDescriptor)parameterDescriptor);
        }
        int n = Parameter.getUnitMessageID(unit2);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format((int)n, unit));
        }
        double[] dArray2 = (double[])dArray.clone();
        try {
            unitConverter = unit.getConverterToAny(unit2);
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(Errors.format((int)92, unit), conversionException);
        }
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = unitConverter.convert(dArray2[i]);
        }
        this.setSafeValue(Parameter.ensureValidValue(parameterDescriptor, dArray2), unit);
    }

    protected void setSafeValue(T t, Unit<?> unit) {
        this.value = t;
        this.unit = unit;
        this.fireValueChanged();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Parameter parameter = (Parameter)object;
            return Utilities.equals(this.value, parameter.value) && Utilities.equals(this.unit, parameter.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 31 * super.hashCode();
        if (this.value != null) {
            n += this.value.hashCode();
        }
        if (this.unit != null) {
            n += 31 * this.unit.hashCode();
        }
        return n ^ 0x9F456C48;
    }

    @Override
    public Parameter<T> clone() {
        return (Parameter)super.clone();
    }
}

