/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.jaxb.gco.StringConverter;
import org.geotoolkit.internal.jaxb.referencing.RS_Identifier;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.DefaultInternationalString;
import org.geotoolkit.util.Deprecable;
import org.geotoolkit.util.LenientComparable;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@Immutable
@ThreadSafe
@XmlType(name="IdentifiedObjectType", propOrder={"identifier", "name"})
public class AbstractIdentifiedObject
extends FormattableObject
implements IdentifiedObject,
LenientComparable,
Deprecable,
Serializable {
    private static final long serialVersionUID = -5173281694258483264L;
    @XmlElement
    @XmlJavaTypeAdapter(value=RS_Identifier.ToString.class)
    private final ReferenceIdentifier name;
    private final Collection<GenericName> alias;
    private final Set<ReferenceIdentifier> identifiers;
    private final InternationalString remarks;
    private transient int hashCode;

    private AbstractIdentifiedObject() {
        this((IdentifiedObject)NilReferencingObject.INSTANCE);
    }

    public AbstractIdentifiedObject(IdentifiedObject identifiedObject) {
        ArgumentChecks.ensureNonNull((String)"object", (Object)identifiedObject);
        this.name = identifiedObject.getName();
        Collection collection = identifiedObject.getAlias();
        Set set = identifiedObject.getIdentifiers();
        this.remarks = identifiedObject.getRemarks();
        if (collection != null && collection.isEmpty()) {
            collection = null;
        }
        if (set != null && set.isEmpty()) {
            set = null;
        }
        this.alias = collection;
        this.identifiers = set;
    }

    public AbstractIdentifiedObject(Map<String, ?> map) throws IllegalArgumentException {
        this(map, null, null);
    }

    protected AbstractIdentifiedObject(Map<String, ?> map, Map<String, Object> map2, String[] stringArray) throws IllegalArgumentException {
        Object object;
        Object object2;
        ArgumentChecks.ensureNonNull((String)"properties", map);
        NamedIdentifier namedIdentifier = null;
        Object[] objectArray = null;
        ReferenceIdentifier[] referenceIdentifierArray = null;
        DefaultInternationalString defaultInternationalString = null;
        DefaultInternationalString defaultInternationalString2 = null;
        DefaultInternationalString[] defaultInternationalStringArray = null;
        block16: for (Map.Entry<String, ?> object32 : map.entrySet()) {
            object2 = object32.getKey().trim().toLowerCase();
            object = object32.getValue();
            switch (((String)object2).hashCode()) {
                case -1528693765: {
                    if (!((String)object2).equalsIgnoreCase("anchorPoint")) break;
                    object2 = "anchorPoint";
                    break;
                }
                case -1805658881: {
                    if (!((String)object2).equalsIgnoreCase("bursaWolf")) break;
                    object2 = "bursaWolf";
                    break;
                }
                case 109688209: {
                    if (!((String)object2).equalsIgnoreCase("operationVersion")) break;
                    object2 = "operationVersion";
                    break;
                }
                case 1479434472: {
                    if (!((String)object2).equalsIgnoreCase("coordinateOperationAccuracy")) break;
                    object2 = "coordinateOperationAccuracy";
                    break;
                }
                case 1126917133: {
                    if (!((String)object2).equalsIgnoreCase("positionalAccuracy")) break;
                    object2 = "positionalAccuracy";
                    break;
                }
                case 1127093059: {
                    if (!((String)object2).equalsIgnoreCase("realizationEpoch")) break;
                    object2 = "realizationEpoch";
                    break;
                }
                case 1790520781: {
                    if (!((String)object2).equalsIgnoreCase("domainOfValidity")) break;
                    object2 = "domainOfValidity";
                    break;
                }
                case -1109785975: {
                    if (!((String)object2).equalsIgnoreCase("validArea")) break;
                    object2 = "validArea";
                    break;
                }
                case 3373707: {
                    if (!((String)object2).equals("name")) break;
                    if (object instanceof String) {
                        namedIdentifier = new NamedIdentifier(map, false);
                        assert (object.equals(((Identifier)namedIdentifier).getCode())) : namedIdentifier;
                        continue block16;
                    }
                    namedIdentifier = (NamedIdentifier)((Object)object);
                    continue block16;
                }
                case 92902992: {
                    if (!((String)object2).equals("alias")) break;
                    objectArray = NamedIdentifier.getNameFactory().toArray(object);
                    continue block16;
                }
                case 1368189162: {
                    if (!((String)object2).equals("identifiers")) break;
                    if (object == null) continue block16;
                    if (object instanceof ReferenceIdentifier) {
                        referenceIdentifierArray = new ReferenceIdentifier[]{(ReferenceIdentifier)object};
                        continue block16;
                    }
                    referenceIdentifierArray = object;
                    continue block16;
                }
                case 1091415283: {
                    if (!((String)object2).equals("remarks") || !(object instanceof InternationalString)) break;
                    defaultInternationalString = (DefaultInternationalString)object;
                    continue block16;
                }
            }
            if (object instanceof String) {
                if (defaultInternationalString2 == null) {
                    defaultInternationalString2 = defaultInternationalString instanceof DefaultInternationalString ? (DefaultInternationalString)defaultInternationalString : new DefaultInternationalString();
                }
                if (defaultInternationalString2.add("remarks", (String)object2, object.toString())) continue;
            }
            if (map2 == null) continue;
            if (stringArray != null) {
                String string;
                for (int i = 0; !(i >= stringArray.length || ((String)object2).equals(string = stringArray[i]) && object instanceof InternationalString); ++i) {
                    if (!(object instanceof String)) continue;
                    if (defaultInternationalStringArray == null) {
                        defaultInternationalStringArray = new DefaultInternationalString[stringArray.length];
                    }
                    if (defaultInternationalStringArray[i] == null) {
                        Object object3 = map2.get(string);
                        defaultInternationalStringArray[i] = object3 instanceof DefaultInternationalString ? (DefaultInternationalString)object3 : new DefaultInternationalString();
                    }
                    if (defaultInternationalStringArray[i].add(string, (String)object2, object.toString())) continue block16;
                }
            }
            map2.put((String)object2, object);
        }
        if (defaultInternationalString2 != null && !defaultInternationalString2.getLocales().isEmpty()) {
            if (defaultInternationalString == null) {
                defaultInternationalString = defaultInternationalString2;
            } else if (!defaultInternationalString2.isSubsetOf(defaultInternationalString)) {
                Logging.log(AbstractIdentifiedObject.class, (String)"<init>", (LogRecord)Loggings.format((Level)Level.WARNING, (int)33));
            }
        }
        if (map2 != null && defaultInternationalStringArray != null) {
            for (int i = 0; i < defaultInternationalStringArray.length; ++i) {
                defaultInternationalString2 = defaultInternationalStringArray[i];
                if (defaultInternationalString2 == null || defaultInternationalString2.getLocales().isEmpty()) continue;
                String string = stringArray[i];
                object2 = map2.get(string);
                if (object2 == null) {
                    map2.put(string, defaultInternationalString2);
                    continue;
                }
                if (defaultInternationalString2.isSubsetOf(object2)) continue;
                Logging.log(AbstractIdentifiedObject.class, (String)"<init>", (LogRecord)Loggings.format((Level)Level.WARNING, (int)33));
            }
        }
        Object object5 = null;
        Object var11_15 = null;
        try {
            object5 = "name";
            NamedIdentifier namedIdentifier2 = namedIdentifier;
            this.name = (ReferenceIdentifier)namedIdentifier2;
            object5 = "alias";
            Object[] objectArray2 = objectArray;
            this.alias = InternalUtilities.nonEmptySet((Object[])objectArray);
            object5 = "identifiers";
            ReferenceIdentifier[] referenceIdentifierArray2 = referenceIdentifierArray;
            this.identifiers = InternalUtilities.nonEmptySet((Object[])referenceIdentifierArray2);
            object5 = "remarks";
            DefaultInternationalString defaultInternationalString3 = defaultInternationalString;
            this.remarks = (InternationalString)defaultInternationalString3;
        }
        catch (ClassCastException classCastException) {
            object = new InvalidParameterValueException(Errors.format((int)73, (Object)object5, var11_15), (String)object5, var11_15);
            object.initCause((Throwable)classCastException);
            throw object;
        }
        ArgumentChecks.ensureNonNull((String)"name", (Object)((Object)namedIdentifier));
        ArgumentChecks.ensureNonNull((String)"name", (Object)((Object)((Object)namedIdentifier)).toString());
    }

    @XmlID
    @XmlAttribute(name="id", namespace="http://www.opengis.net/gml", required=true)
    @XmlJavaTypeAdapter(value=StringConverter.class)
    final String getID() {
        ReferenceIdentifier referenceIdentifier = this.getIdentifier(null);
        if (referenceIdentifier == null && (referenceIdentifier = this.getName()) == null) {
            return null;
        }
        String string = referenceIdentifier.getCodeSpace();
        string = string != null ? string + referenceIdentifier.getCode() : referenceIdentifier.getCode();
        string = string.replace(":", "");
        return string;
    }

    public ReferenceIdentifier getName() {
        return this.name;
    }

    public String getName(Citation citation) {
        return IdentifiedObjects.name(this, citation, null);
    }

    public Collection<GenericName> getAlias() {
        if (this.alias == null) {
            return Collections.emptySet();
        }
        return this.alias;
    }

    public Set<ReferenceIdentifier> getIdentifiers() {
        if (this.identifiers == null) {
            return Collections.emptySet();
        }
        return this.identifiers;
    }

    @XmlElement
    final ReferenceIdentifier getIdentifier() {
        Iterator<ReferenceIdentifier> iterator;
        Set<ReferenceIdentifier> set = this.identifiers;
        if (set != null && (iterator = set.iterator()).hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public ReferenceIdentifier getIdentifier(Citation citation) {
        return IdentifiedObjects.identifier(this, citation);
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    public boolean nameMatches(String string) {
        return IdentifiedObjects.nameMatches(this, this.alias, string);
    }

    public boolean isDeprecated() {
        if (this.name instanceof DefaultReferenceIdentifier && ((DefaultReferenceIdentifier)this.name).isDeprecated()) {
            return true;
        }
        boolean bl = false;
        for (ReferenceIdentifier referenceIdentifier : this.identifiers) {
            if (referenceIdentifier instanceof DefaultReferenceIdentifier && !(bl = ((DefaultReferenceIdentifier)referenceIdentifier).isDeprecated())) break;
        }
        return bl;
    }

    public final boolean equals(Object object) {
        boolean bl = this.equals(object, ComparisonMode.STRICT);
        assert (!bl || this.hashCode() == object.hashCode()) : this;
        return bl;
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        int n;
        int n2;
        Class<?> clazz;
        if (object == null) {
            return false;
        }
        Class<?> clazz2 = this.getClass();
        if (clazz2 == (clazz = object.getClass()) ? comparisonMode.ordinal() < ComparisonMode.APPROXIMATIVE.ordinal() && (n2 = this.hashCode) != 0 && (n = ((AbstractIdentifiedObject)object).hashCode) != 0 && n2 != n : comparisonMode == ComparisonMode.STRICT || !Classes.implementSameInterfaces(clazz2, clazz, IdentifiedObject.class)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                AbstractIdentifiedObject abstractIdentifiedObject = (AbstractIdentifiedObject)object;
                return Utilities.equals((Object)this.name, (Object)abstractIdentifiedObject.name) && Utilities.equals(this.alias, abstractIdentifiedObject.alias) && Utilities.equals(this.identifiers, abstractIdentifiedObject.identifiers) && Utilities.equals((Object)this.remarks, (Object)abstractIdentifiedObject.remarks);
            }
            case BY_CONTRACT: {
                IdentifiedObject identifiedObject = (IdentifiedObject)object;
                return Utilities.deepEquals((Object)this.getName(), (Object)identifiedObject.getName(), (ComparisonMode)comparisonMode) && Utilities.deepEquals(this.getAlias(), (Object)identifiedObject.getAlias(), (ComparisonMode)comparisonMode) && Utilities.deepEquals(this.getIdentifiers(), (Object)identifiedObject.getIdentifiers(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getRemarks(), (Object)identifiedObject.getRemarks(), (ComparisonMode)comparisonMode);
            }
            case IGNORE_METADATA: 
            case APPROXIMATIVE: 
            case DEBUG: {
                return true;
            }
        }
        throw new IllegalArgumentException(Errors.format((int)260, (Object)comparisonMode));
    }

    public final int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = this.computeHashCode();
            if (n == 0) {
                n = -1;
            }
            this.hashCode = n;
        }
        assert (n == -1 || n == this.computeHashCode()) : this;
        return n;
    }

    protected int computeHashCode() {
        int n = 1387343808;
        Class[] classArray = Classes.getLeafInterfaces(this.getClass(), IdentifiedObject.class);
        if (classArray != null) {
            for (Class clazz : classArray) {
                n += clazz.hashCode();
            }
        }
        return n;
    }
}

