/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.crs.AbstractDerivedCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Projection;

@Immutable
@XmlRootElement(name="ProjectedCRS")
public class DefaultProjectedCRS
extends AbstractDerivedCRS
implements ProjectedCRS {
    private static final long serialVersionUID = -4502680112031773028L;
    private static final String SEMI_MAJOR = "semi_major";
    private static final String SEMI_MINOR = "semi_minor";

    private DefaultProjectedCRS() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultProjectedCRS(ProjectedCRS projectedCRS) {
        super((GeneralDerivedCRS)projectedCRS);
    }

    public DefaultProjectedCRS(String string, GeographicCRS geographicCRS, MathTransform mathTransform, CartesianCS cartesianCS) throws MismatchedDimensionException {
        this(Collections.singletonMap("name", string), geographicCRS, mathTransform, cartesianCS);
    }

    public DefaultProjectedCRS(Map<String, ?> map, GeographicCRS geographicCRS, MathTransform mathTransform, CartesianCS cartesianCS) throws MismatchedDimensionException {
        super(map, (CoordinateReferenceSystem)geographicCRS, mathTransform, (CoordinateSystem)cartesianCS);
    }

    public DefaultProjectedCRS(Map<String, ?> map, Conversion conversion, GeographicCRS geographicCRS, MathTransform mathTransform, CartesianCS cartesianCS) throws MismatchedDimensionException {
        super(map, conversion, (CoordinateReferenceSystem)geographicCRS, mathTransform, (CoordinateSystem)cartesianCS);
    }

    public static DefaultProjectedCRS castOrCopy(ProjectedCRS projectedCRS) {
        return projectedCRS == null || projectedCRS instanceof DefaultProjectedCRS ? (DefaultProjectedCRS)projectedCRS : new DefaultProjectedCRS(projectedCRS);
    }

    @XmlElement(name="cartesianCS")
    public CartesianCS getCoordinateSystem() {
        return (CartesianCS)super.getCoordinateSystem();
    }

    final void setCoordinateSystem(CartesianCS cartesianCS) {
        super.setCoordinateSystem((CoordinateSystem)cartesianCS);
    }

    @XmlElement(name="geodeticDatum")
    public GeodeticDatum getDatum() {
        return (GeodeticDatum)super.getDatum();
    }

    final void setDatum(GeodeticDatum geodeticDatum) {
        super.setDatum((Datum)geodeticDatum);
    }

    public GeographicCRS getBaseCRS() {
        return (GeographicCRS)super.getBaseCRS();
    }

    public Projection getConversionFromBase() {
        return (Projection)super.getConversionFromBase();
    }

    Class<? extends Projection> getConversionType() {
        return Projection.class;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        Ellipsoid ellipsoid = this.getDatum().getEllipsoid();
        Unit<?> unit = this.getUnit();
        Unit<Length> unit2 = formatter.getLinearUnit();
        Unit<Angle> unit3 = formatter.getAngularUnit();
        Unit unit4 = ellipsoid.getAxisUnit();
        formatter.setLinearUnit(unit);
        formatter.setAngularUnit(DefaultGeographicCRS.getAngularUnit(this.baseCRS.getCoordinateSystem()));
        formatter.append((IdentifiedObject)this.baseCRS);
        formatter.append((IdentifiedObject)this.conversionFromBase.getMethod());
        for (GeneralParameterValue generalParameterValue : this.conversionFromBase.getParameterValues().values()) {
            block8: {
                String string;
                block7: {
                    GeneralParameterDescriptor generalParameterDescriptor = generalParameterValue.getDescriptor();
                    string = SEMI_MAJOR;
                    if (IdentifiedObjects.nameMatches((IdentifiedObject)generalParameterDescriptor, SEMI_MAJOR)) break block7;
                    string = SEMI_MINOR;
                    if (!IdentifiedObjects.nameMatches((IdentifiedObject)generalParameterDescriptor, SEMI_MINOR)) break block8;
                }
                if (generalParameterValue instanceof ParameterValue) {
                    double d;
                    double d2 = ((ParameterValue)generalParameterValue).doubleValue(unit4);
                    double d3 = d = string == SEMI_MINOR ? ellipsoid.getSemiMinorAxis() : ellipsoid.getSemiMajorAxis();
                    if (d2 == d) continue;
                }
            }
            formatter.append(generalParameterValue);
        }
        formatter.append(unit);
        CartesianCS cartesianCS = this.getCoordinateSystem();
        int n = cartesianCS.getDimension();
        for (int i = 0; i < n; ++i) {
            formatter.append((IdentifiedObject)cartesianCS.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT(ProjectedCRS.class);
        }
        formatter.setAngularUnit(unit3);
        formatter.setLinearUnit(unit2);
        return "PROJCS";
    }
}

