/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Map;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@Immutable
public class DefaultTimeCS
extends AbstractCS
implements TimeCS {
    private static final long serialVersionUID = 5222911412381303989L;
    public static final DefaultTimeCS DAYS;
    public static final DefaultTimeCS SECONDS;
    public static final DefaultTimeCS MILLISECONDS;

    private DefaultTimeCS() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultTimeCS(TimeCS timeCS) {
        super((CoordinateSystem)timeCS);
    }

    public DefaultTimeCS(String string, CoordinateSystemAxis coordinateSystemAxis) {
        super(string, coordinateSystemAxis);
    }

    public DefaultTimeCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) {
        super(map, coordinateSystemAxis);
    }

    public static DefaultTimeCS castOrCopy(TimeCS timeCS) {
        return timeCS == null || timeCS instanceof DefaultTimeCS ? (DefaultTimeCS)timeCS : new DefaultTimeCS(timeCS);
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return AxisDirection.FUTURE.equals((Object)AxisDirections.absolute(axisDirection));
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection axisDirection, Unit<?> unit) {
        return SI.SECOND.isCompatible(unit);
    }

    static {
        Map<String, Object> map = DefaultTimeCS.name(292);
        DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.TIME;
        DAYS = new DefaultTimeCS((Map<String, ?>)map, (CoordinateSystemAxis)defaultCoordinateSystemAxis);
        InternationalString internationalString = ((GenericName)defaultCoordinateSystemAxis.getAlias().iterator().next()).toInternationalString();
        defaultCoordinateSystemAxis = new DefaultCoordinateSystemAxis((CharSequence)internationalString, "t", AxisDirection.FUTURE, (Unit<?>)SI.SECOND);
        SECONDS = new DefaultTimeCS((Map<String, ?>)map, (CoordinateSystemAxis)defaultCoordinateSystemAxis);
        defaultCoordinateSystemAxis = new DefaultCoordinateSystemAxis((CharSequence)internationalString, "t", AxisDirection.FUTURE, Units.MILLISECOND);
        MILLISECONDS = new DefaultTimeCS((Map<String, ?>)map, (CoordinateSystemAxis)defaultCoordinateSystemAxis);
    }
}

