/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

@Immutable
abstract class AuthorityFactoryProxy<T> {
    public final Class<T> type;
    public static final AuthorityFactoryProxy<IdentifiedObject> OBJECT = new AuthorityFactoryProxy<IdentifiedObject>(IdentifiedObject.class){

        @Override
        public IdentifiedObject create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createObject(string);
        }

        @Override
        public IdentifiedObject createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return authorityFactory.createObject(string);
        }
    };
    public static final AuthorityFactoryProxy<Datum> DATUM = new AuthorityFactoryProxy<Datum>(Datum.class){

        @Override
        public Datum create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createDatum(string);
        }

        @Override
        public Datum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createDatum(string);
        }
    };
    public static final AuthorityFactoryProxy<EngineeringDatum> ENGINEERING_DATUM = new AuthorityFactoryProxy<EngineeringDatum>(EngineeringDatum.class){

        @Override
        public EngineeringDatum create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createEngineeringDatum(string);
        }

        @Override
        public EngineeringDatum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createEngineeringDatum(string);
        }
    };
    public static final AuthorityFactoryProxy<ImageDatum> IMAGE_DATUM = new AuthorityFactoryProxy<ImageDatum>(ImageDatum.class){

        @Override
        public ImageDatum create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createImageDatum(string);
        }

        @Override
        public ImageDatum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createImageDatum(string);
        }
    };
    public static final AuthorityFactoryProxy<VerticalDatum> VERTICAL_DATUM = new AuthorityFactoryProxy<VerticalDatum>(VerticalDatum.class){

        @Override
        public VerticalDatum create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createVerticalDatum(string);
        }

        @Override
        public VerticalDatum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createVerticalDatum(string);
        }
    };
    public static final AuthorityFactoryProxy<TemporalDatum> TEMPORAL_DATUM = new AuthorityFactoryProxy<TemporalDatum>(TemporalDatum.class){

        @Override
        public TemporalDatum create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createTemporalDatum(string);
        }

        @Override
        public TemporalDatum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createTemporalDatum(string);
        }
    };
    public static final AuthorityFactoryProxy<GeodeticDatum> GEODETIC_DATUM = new AuthorityFactoryProxy<GeodeticDatum>(GeodeticDatum.class){

        @Override
        public GeodeticDatum create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createGeodeticDatum(string);
        }

        @Override
        public GeodeticDatum createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createGeodeticDatum(string);
        }
    };
    public static final AuthorityFactoryProxy<Ellipsoid> ELLIPSOID = new AuthorityFactoryProxy<Ellipsoid>(Ellipsoid.class){

        @Override
        public Ellipsoid create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createEllipsoid(string);
        }

        @Override
        public Ellipsoid createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createEllipsoid(string);
        }
    };
    public static final AuthorityFactoryProxy<PrimeMeridian> PRIME_MERIDIAN = new AuthorityFactoryProxy<PrimeMeridian>(PrimeMeridian.class){

        @Override
        public PrimeMeridian create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createPrimeMeridian(string);
        }

        @Override
        public PrimeMeridian createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.datumFactory(authorityFactory).createPrimeMeridian(string);
        }
    };
    public static final AuthorityFactoryProxy<Extent> EXTENT = new AuthorityFactoryProxy<Extent>(Extent.class){

        @Override
        public Extent create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createExtent(string);
        }

        @Override
        public Extent createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.geotkFactory(authorityFactory).createExtent(string);
        }
    };
    public static final AuthorityFactoryProxy<CoordinateSystem> COORDINATE_SYSTEM = new AuthorityFactoryProxy<CoordinateSystem>(CoordinateSystem.class){

        @Override
        public CoordinateSystem create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createCoordinateSystem(string);
        }

        @Override
        public CoordinateSystem createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createCoordinateSystem(string);
        }
    };
    public static final AuthorityFactoryProxy<CartesianCS> CARTESIAN_CS = new AuthorityFactoryProxy<CartesianCS>(CartesianCS.class){

        @Override
        public CartesianCS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createCartesianCS(string);
        }

        @Override
        public CartesianCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createCartesianCS(string);
        }
    };
    public static final AuthorityFactoryProxy<PolarCS> POLAR_CS = new AuthorityFactoryProxy<PolarCS>(PolarCS.class){

        @Override
        public PolarCS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createPolarCS(string);
        }

        @Override
        public PolarCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createPolarCS(string);
        }
    };
    public static final AuthorityFactoryProxy<CylindricalCS> CYLINDRICAL_CS = new AuthorityFactoryProxy<CylindricalCS>(CylindricalCS.class){

        @Override
        public CylindricalCS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createCylindricalCS(string);
        }

        @Override
        public CylindricalCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createCylindricalCS(string);
        }
    };
    public static final AuthorityFactoryProxy<SphericalCS> SPHERICAL_CS = new AuthorityFactoryProxy<SphericalCS>(SphericalCS.class){

        @Override
        public SphericalCS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createSphericalCS(string);
        }

        @Override
        public SphericalCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createSphericalCS(string);
        }
    };
    public static final AuthorityFactoryProxy<EllipsoidalCS> ELLIPSOIDAL_CS = new AuthorityFactoryProxy<EllipsoidalCS>(EllipsoidalCS.class){

        @Override
        public EllipsoidalCS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createEllipsoidalCS(string);
        }

        @Override
        public EllipsoidalCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createEllipsoidalCS(string);
        }
    };
    public static final AuthorityFactoryProxy<VerticalCS> VERTICAL_CS = new AuthorityFactoryProxy<VerticalCS>(VerticalCS.class){

        @Override
        public VerticalCS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createVerticalCS(string);
        }

        @Override
        public VerticalCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createVerticalCS(string);
        }
    };
    public static final AuthorityFactoryProxy<TimeCS> TIME_CS = new AuthorityFactoryProxy<TimeCS>(TimeCS.class){

        @Override
        public TimeCS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createTimeCS(string);
        }

        @Override
        public TimeCS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createTimeCS(string);
        }
    };
    public static final AuthorityFactoryProxy<CoordinateSystemAxis> AXIS = new AuthorityFactoryProxy<CoordinateSystemAxis>(CoordinateSystemAxis.class){

        @Override
        public CoordinateSystemAxis create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createCoordinateSystemAxis(string);
        }

        @Override
        public CoordinateSystemAxis createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createCoordinateSystemAxis(string);
        }
    };
    public static final AuthorityFactoryProxy<Unit> UNIT = new AuthorityFactoryProxy<Unit>(Unit.class){

        @Override
        public Unit<?> create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createUnit(string);
        }

        @Override
        public Unit createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.csFactory(authorityFactory).createUnit(string);
        }
    };
    public static final AuthorityFactoryProxy<CoordinateReferenceSystem> CRS = new AuthorityFactoryProxy<CoordinateReferenceSystem>(CoordinateReferenceSystem.class){

        @Override
        public CoordinateReferenceSystem create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createCoordinateReferenceSystem(string);
        }

        @Override
        public CoordinateReferenceSystem createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createCoordinateReferenceSystem(string);
        }
    };
    public static final AuthorityFactoryProxy<CompoundCRS> COMPOUND_CRS = new AuthorityFactoryProxy<CompoundCRS>(CompoundCRS.class){

        @Override
        public CompoundCRS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createCompoundCRS(string);
        }

        @Override
        public CompoundCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createCompoundCRS(string);
        }
    };
    public static final AuthorityFactoryProxy<DerivedCRS> DERIVED_CRS = new AuthorityFactoryProxy<DerivedCRS>(DerivedCRS.class){

        @Override
        public DerivedCRS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createDerivedCRS(string);
        }

        @Override
        public DerivedCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createDerivedCRS(string);
        }
    };
    public static final AuthorityFactoryProxy<EngineeringCRS> ENGINEERING_CRS = new AuthorityFactoryProxy<EngineeringCRS>(EngineeringCRS.class){

        @Override
        public EngineeringCRS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createEngineeringCRS(string);
        }

        @Override
        public EngineeringCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createEngineeringCRS(string);
        }
    };
    public static final AuthorityFactoryProxy<GeographicCRS> GEOGRAPHIC_CRS = new AuthorityFactoryProxy<GeographicCRS>(GeographicCRS.class){

        @Override
        public GeographicCRS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createGeographicCRS(string);
        }

        @Override
        public GeographicCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createGeographicCRS(string);
        }
    };
    public static final AuthorityFactoryProxy<GeocentricCRS> GEOCENTRIC_CRS = new AuthorityFactoryProxy<GeocentricCRS>(GeocentricCRS.class){

        @Override
        public GeocentricCRS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createGeocentricCRS(string);
        }

        @Override
        public GeocentricCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createGeocentricCRS(string);
        }
    };
    public static final AuthorityFactoryProxy<ImageCRS> IMAGE_CRS = new AuthorityFactoryProxy<ImageCRS>(ImageCRS.class){

        @Override
        public ImageCRS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createImageCRS(string);
        }

        @Override
        public ImageCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createImageCRS(string);
        }
    };
    public static final AuthorityFactoryProxy<ProjectedCRS> PROJECTED_CRS = new AuthorityFactoryProxy<ProjectedCRS>(ProjectedCRS.class){

        @Override
        public ProjectedCRS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createProjectedCRS(string);
        }

        @Override
        public ProjectedCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createProjectedCRS(string);
        }
    };
    public static final AuthorityFactoryProxy<TemporalCRS> TEMPORAL_CRS = new AuthorityFactoryProxy<TemporalCRS>(TemporalCRS.class){

        @Override
        public TemporalCRS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createTemporalCRS(string);
        }

        @Override
        public TemporalCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createTemporalCRS(string);
        }
    };
    public static final AuthorityFactoryProxy<VerticalCRS> VERTICAL_CRS = new AuthorityFactoryProxy<VerticalCRS>(VerticalCRS.class){

        @Override
        public VerticalCRS create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createVerticalCRS(string);
        }

        @Override
        public VerticalCRS createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.crsFactory(authorityFactory).createVerticalCRS(string);
        }
    };
    public static final AuthorityFactoryProxy<ParameterDescriptor> PARAMETER = new AuthorityFactoryProxy<ParameterDescriptor>(ParameterDescriptor.class){

        @Override
        public ParameterDescriptor<?> create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createParameterDescriptor(string);
        }

        @Override
        public ParameterDescriptor createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.geotkFactory(authorityFactory).createParameterDescriptor(string);
        }
    };
    public static final AuthorityFactoryProxy<OperationMethod> METHOD = new AuthorityFactoryProxy<OperationMethod>(OperationMethod.class){

        @Override
        public OperationMethod create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createOperationMethod(string);
        }

        @Override
        public OperationMethod createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.opFactory(authorityFactory).createOperationMethod(string);
        }
    };
    public static final AuthorityFactoryProxy<CoordinateOperation> OPERATION = new AuthorityFactoryProxy<CoordinateOperation>(CoordinateOperation.class){

        @Override
        public CoordinateOperation create(AbstractAuthorityFactory abstractAuthorityFactory, String string) throws FactoryException {
            return abstractAuthorityFactory.createCoordinateOperation(string);
        }

        @Override
        public CoordinateOperation createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            return this.opFactory(authorityFactory).createCoordinateOperation(string);
        }
    };
    static final AuthorityFactoryProxy<?>[] PROXIES = new AuthorityFactoryProxy[]{OPERATION, METHOD, PARAMETER, PROJECTED_CRS, GEOGRAPHIC_CRS, GEOCENTRIC_CRS, IMAGE_CRS, DERIVED_CRS, VERTICAL_CRS, TEMPORAL_CRS, ENGINEERING_CRS, COMPOUND_CRS, CRS, AXIS, CARTESIAN_CS, ELLIPSOIDAL_CS, SPHERICAL_CS, CYLINDRICAL_CS, POLAR_CS, VERTICAL_CS, TIME_CS, COORDINATE_SYSTEM, PRIME_MERIDIAN, ELLIPSOID, GEODETIC_DATUM, IMAGE_DATUM, VERTICAL_DATUM, TEMPORAL_DATUM, ENGINEERING_DATUM, DATUM, EXTENT, UNIT, OBJECT};

    AuthorityFactoryProxy(Class<T> clazz) {
        this.type = clazz;
    }

    public String toString() {
        return "AuthorityFactoryProxy[" + this.type.getSimpleName() + ']';
    }

    final DatumAuthorityFactory datumFactory(AuthorityFactory authorityFactory) throws FactoryException {
        if (authorityFactory instanceof DatumAuthorityFactory) {
            return (DatumAuthorityFactory)authorityFactory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(DatumAuthorityFactory.class);
    }

    final CSAuthorityFactory csFactory(AuthorityFactory authorityFactory) throws FactoryException {
        if (authorityFactory instanceof CSAuthorityFactory) {
            return (CSAuthorityFactory)authorityFactory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(CSAuthorityFactory.class);
    }

    final CRSAuthorityFactory crsFactory(AuthorityFactory authorityFactory) throws FactoryException {
        if (authorityFactory instanceof CRSAuthorityFactory) {
            return (CRSAuthorityFactory)authorityFactory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(CRSAuthorityFactory.class);
    }

    final CoordinateOperationAuthorityFactory opFactory(AuthorityFactory authorityFactory) throws FactoryException {
        if (authorityFactory instanceof CoordinateOperationAuthorityFactory) {
            return (CoordinateOperationAuthorityFactory)authorityFactory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(CoordinateOperationAuthorityFactory.class);
    }

    final AbstractAuthorityFactory geotkFactory(AuthorityFactory authorityFactory) throws FactoryException {
        if (authorityFactory instanceof CRSAuthorityFactory) {
            return (AbstractAuthorityFactory)authorityFactory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(AbstractAuthorityFactory.class);
    }

    private static FactoryException factoryNotFound(Class<? extends AuthorityFactory> clazz) {
        return new FactoryException(Errors.format((int)63, clazz));
    }

    public abstract T create(AbstractAuthorityFactory var1, String var2) throws FactoryException;

    public abstract T createFromAPI(AuthorityFactory var1, String var2) throws FactoryException;

    public static <T> AuthorityFactoryProxy<? super T> getInstance(Class<T> clazz) throws IllegalArgumentException {
        for (AuthorityFactoryProxy<?> authorityFactoryProxy : PROXIES) {
            if (!authorityFactoryProxy.type.isAssignableFrom(clazz)) continue;
            return authorityFactoryProxy;
        }
        throw new IllegalArgumentException(Errors.format((int)76, clazz, IdentifiedObject.class));
    }
}

