/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.NotThreadSafe;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.factory.AuthorityFactoryProxy;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.FactoryException;

@NotThreadSafe
public class IdentifiedObjectFinder {
    final AuthorityFactory factory;
    private AuthorityFactoryProxy<?> proxy;
    private IdentifiedObjectFinder parent;
    private ComparisonMode comparisonMode = ComparisonMode.IGNORE_METADATA;
    private boolean fullScan = true;

    protected IdentifiedObjectFinder(AuthorityFactory authorityFactory, Class<? extends IdentifiedObject> clazz) {
        this.factory = authorityFactory;
        this.proxy = AuthorityFactoryProxy.getInstance(clazz);
    }

    Class<? extends IdentifiedObject> getObjectType() {
        return this.proxy.type.asSubclass(IdentifiedObject.class);
    }

    public Citation getAuthority() throws FactoryException {
        return this.factory.getAuthority();
    }

    final void setParent(IdentifiedObjectFinder identifiedObjectFinder) {
        this.parent = identifiedObjectFinder;
    }

    final void copyConfiguration(IdentifiedObjectFinder identifiedObjectFinder) {
        this.setComparisonMode(identifiedObjectFinder.getComparisonMode());
        this.setFullScanAllowed(identifiedObjectFinder.isFullScanAllowed());
    }

    public ComparisonMode getComparisonMode() {
        return this.comparisonMode;
    }

    public void setComparisonMode(ComparisonMode comparisonMode) {
        ArgumentChecks.ensureNonNull((String)"mode", (Object)comparisonMode);
        this.comparisonMode = comparisonMode;
    }

    public boolean isFullScanAllowed() {
        return this.fullScan;
    }

    public void setFullScanAllowed(boolean bl) {
        this.fullScan = bl;
    }

    public IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"object", (Object)identifiedObject);
        IdentifiedObject identifiedObject2 = this.createFromIdentifiers(identifiedObject);
        if (identifiedObject2 != null) {
            return identifiedObject2;
        }
        identifiedObject2 = this.createFromNames(identifiedObject);
        if (identifiedObject2 != null) {
            return identifiedObject2;
        }
        return this.fullScan ? this.createFromCodes(identifiedObject) : null;
    }

    public String findIdentifier(IdentifiedObject identifiedObject) throws FactoryException {
        ReferenceIdentifier referenceIdentifier;
        IdentifiedObject identifiedObject2 = this.find(identifiedObject);
        if (identifiedObject2 == null) {
            return null;
        }
        Citation citation = this.getAuthority();
        if (ReferencingFactory.ALL.equals(citation)) {
            citation = null;
        }
        if ((referenceIdentifier = IdentifiedObjects.getIdentifier(identifiedObject2, citation)) == null) {
            referenceIdentifier = identifiedObject2.getName();
        }
        return IdentifiedObjects.toString((Identifier)referenceIdentifier);
    }

    protected final IdentifiedObject findFromParent(IdentifiedObject identifiedObject, Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return this.findFromParent(identifiedObject, AuthorityFactoryProxy.getInstance(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdentifiedObject findFromParent(IdentifiedObject identifiedObject, AuthorityFactoryProxy<?> authorityFactoryProxy) throws FactoryException {
        IdentifiedObjectFinder identifiedObjectFinder = this.parent;
        AuthorityFactoryProxy<?> authorityFactoryProxy2 = this.proxy;
        this.proxy = authorityFactoryProxy;
        try {
            IdentifiedObject identifiedObject2 = identifiedObjectFinder != null ? identifiedObjectFinder.findFromParent(identifiedObject, authorityFactoryProxy) : this.find(identifiedObject);
            return identifiedObject2;
        }
        finally {
            this.proxy = authorityFactoryProxy2;
        }
    }

    final IdentifiedObject createFromIdentifiers(IdentifiedObject identifiedObject) throws FactoryException {
        Citation citation = this.getAuthority();
        boolean bl = ReferencingFactory.ALL.equals(citation);
        block2: for (ReferenceIdentifier referenceIdentifier : identifiedObject.getIdentifiers()) {
            if (!bl && !Citations.identifierMatches((Citation)citation, (Citation)referenceIdentifier.getAuthority())) continue;
            String string = IdentifiedObjects.toString((Identifier)referenceIdentifier);
            int n = 0;
            while (true) {
                IdentifiedObject identifiedObject2;
                try {
                    identifiedObject2 = this.create(string, n);
                }
                catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                    continue block2;
                }
                if (identifiedObject2 == null) continue block2;
                if (Utilities.deepEquals((Object)identifiedObject2, (Object)identifiedObject, (ComparisonMode)this.comparisonMode)) {
                    return identifiedObject2;
                }
                ++n;
            }
        }
        return null;
    }

    final IdentifiedObject createFromNames(IdentifiedObject identifiedObject) throws FactoryException {
        String string = identifiedObject.getName().getCode();
        int n = 0;
        while (true) {
            IdentifiedObject identifiedObject2;
            try {
                identifiedObject2 = this.create(string, n);
            }
            catch (FactoryException factoryException) {
                break;
            }
            if (identifiedObject2 == null) break;
            if (Utilities.deepEquals((Object)identifiedObject2, (Object)identifiedObject, (ComparisonMode)this.comparisonMode)) {
                return identifiedObject2;
            }
            ++n;
        }
        block5: for (IdentifiedObject identifiedObject2 : identifiedObject.getAlias()) {
            string = identifiedObject2.toString();
            int n2 = 0;
            while (true) {
                IdentifiedObject identifiedObject3;
                try {
                    identifiedObject3 = this.create(string, n2);
                }
                catch (FactoryException factoryException) {
                    continue block5;
                }
                if (identifiedObject3 == null) continue block5;
                if (Utilities.deepEquals((Object)identifiedObject3, (Object)identifiedObject, (ComparisonMode)this.comparisonMode)) {
                    return identifiedObject3;
                }
                ++n2;
            }
        }
        return null;
    }

    final IdentifiedObject createFromCodes(IdentifiedObject identifiedObject) throws FactoryException {
        Set<String> set = this.getCodeCandidates(identifiedObject);
        if (!set.isEmpty()) {
            block2: for (String string : set) {
                int n = 0;
                while (true) {
                    IdentifiedObject identifiedObject2;
                    try {
                        identifiedObject2 = this.create(string, n);
                    }
                    catch (FactoryException factoryException) {
                        continue block2;
                    }
                    if (identifiedObject2 == null) continue block2;
                    if (Utilities.deepEquals((Object)identifiedObject2, (Object)identifiedObject, (ComparisonMode)this.comparisonMode)) {
                        return identifiedObject2;
                    }
                    ++n;
                }
            }
            Logger logger = Logging.getLogger(IdentifiedObjectFinder.class);
            logger.log(Level.FINEST, "No match found for \"{0}\" among {1}", new Object[]{identifiedObject.getName(), set});
        }
        return null;
    }

    protected IdentifiedObject create(String string, int n) throws FactoryException {
        return n == 0 ? (IdentifiedObject)this.proxy.createFromAPI(this.factory, string) : null;
    }

    protected Set<String> getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
        return this.factory.getAuthorityCodes(this.getObjectType());
    }
}

