/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.awt.RenderingHints;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.converter.ConversionException;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.DeprecatedCode;
import org.geotoolkit.internal.referencing.factory.ImplementationHints;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.measure.Units;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.metadata.iso.quality.DefaultAbsoluteExternalPositionalAccuracy;
import org.geotoolkit.metadata.iso.quality.DefaultQuantitativeResult;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.datum.BursaWolfParameters;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.DirectAuthorityFactory;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.referencing.factory.epsg.AuthorityCodes;
import org.geotoolkit.referencing.factory.epsg.AxisName;
import org.geotoolkit.referencing.factory.epsg.BursaWolfInfo;
import org.geotoolkit.referencing.factory.epsg.CoordinateOperationSet;
import org.geotoolkit.referencing.factory.epsg.TableInfo;
import org.geotoolkit.referencing.operation.DefaultConcatenatedOperation;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.referencing.operation.DefaultSingleOperation;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.Result;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.NoSuchIdentifierException;

@ThreadSafe
@ImplementationHints(forceLongitudeFirst=false)
public class DirectEpsgFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private static final int BURSA_WOLF_MIN_CODE = 9603;
    private static final int BURSA_WOLF_MAX_CODE = 9607;
    private static final int ROTATION_FRAME_CODE = 9607;
    private static final TableInfo[] TABLES_INFO = new TableInfo[]{new TableInfo(CoordinateReferenceSystem.class, "[Coordinate Reference System]", "COORD_REF_SYS_CODE", "COORD_REF_SYS_NAME", "COORD_REF_SYS_KIND", new Class[]{ProjectedCRS.class, GeographicCRS.class, GeocentricCRS.class, VerticalCRS.class, CompoundCRS.class, EngineeringCRS.class}, new String[]{"projected", "geographic", "geocentric", "vertical", "compound", "engineering"}), new TableInfo(CoordinateSystem.class, "[Coordinate System]", "COORD_SYS_CODE", "COORD_SYS_NAME", "COORD_SYS_TYPE", new Class[]{CartesianCS.class, EllipsoidalCS.class, SphericalCS.class, VerticalCS.class}, new String[]{"Cartesian", "ellipsoidal", "spherical", "vertical"}), new TableInfo(CoordinateSystemAxis.class, "[Coordinate Axis] AS CA INNER JOIN [Coordinate Axis Name] AS CAN ON CA.COORD_AXIS_NAME_CODE=CAN.COORD_AXIS_NAME_CODE", "COORD_AXIS_CODE", "COORD_AXIS_NAME"), new TableInfo(Datum.class, "[Datum]", "DATUM_CODE", "DATUM_NAME", "DATUM_TYPE", new Class[]{GeodeticDatum.class, VerticalDatum.class, EngineeringDatum.class}, new String[]{"geodetic", "vertical", "engineering"}), new TableInfo(Ellipsoid.class, "[Ellipsoid]", "ELLIPSOID_CODE", "ELLIPSOID_NAME"), new TableInfo(PrimeMeridian.class, "[Prime Meridian]", "PRIME_MERIDIAN_CODE", "PRIME_MERIDIAN_NAME"), new TableInfo(CoordinateOperation.class, "[Coordinate_Operation]", "COORD_OP_CODE", "COORD_OP_NAME", "COORD_OP_TYPE", new Class[]{Projection.class, Conversion.class, Transformation.class}, new String[]{"conversion", "conversion", "transformation"}), new TableInfo(OperationMethod.class, "[Coordinate_Operation Method]", "COORD_OP_METHOD_CODE", "COORD_OP_METHOD_NAME"), new TableInfo(ParameterDescriptor.class, "[Coordinate_Operation Parameter]", "PARAMETER_CODE", "PARAMETER_NAME"), new TableInfo(Unit.class, "[Unit of Measure]", "UOM_CODE", "UNIT_OF_MEAS_NAME")};
    private static final InternationalString TRANSFORMATION_ACCURACY = Vocabulary.formatInternational((int)301);
    private Citation authority;
    private int lastObjectType = -1;
    private String lastTableForName;
    private Calendar calendar;
    private final Map<String, PreparedStatement> statements = new IdentityHashMap<String, PreparedStatement>();
    private Map<Class<?>, Reference<AuthorityCodes>> authorityCodes;
    private Map<String, AxisName> axisNames;
    private Map<String, Integer> axisCounts;
    private Map<String, Boolean> codeProjection;
    private Map<Double, PositionalAccuracy> accuracies;
    private final Map<String, NameSpace> scopes = new HashMap<String, NameSpace>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<String> safetyGuard = new HashSet<String>();
    AbstractAuthorityFactory buffered = this;
    protected final Connection connection;

    private static void setBursaWolfParameter(BursaWolfParameters bursaWolfParameters, int n, double d, Unit<?> baseUnit) throws FactoryException {
        BaseUnit baseUnit2 = baseUnit;
        if (n >= 8605) {
            if (n <= 8607) {
                baseUnit2 = SI.METRE;
            } else if (n <= 8710) {
                baseUnit2 = NonSI.SECOND_ANGLE;
            } else if (n == 8611) {
                baseUnit2 = Units.PPM;
            }
        }
        if (baseUnit2 != baseUnit) {
            try {
                d = baseUnit.getConverterToAny((Unit)baseUnit2).convert(d);
            }
            catch (ConversionException conversionException) {
                throw new FactoryException(Errors.format((int)92, (Object)baseUnit), (Throwable)conversionException);
            }
        }
        switch (n) {
            case 8605: {
                bursaWolfParameters.dx = d;
                break;
            }
            case 8606: {
                bursaWolfParameters.dy = d;
                break;
            }
            case 8607: {
                bursaWolfParameters.dz = d;
                break;
            }
            case 8608: {
                bursaWolfParameters.ex = d;
                break;
            }
            case 8609: {
                bursaWolfParameters.ey = d;
                break;
            }
            case 8610: {
                bursaWolfParameters.ez = d;
                break;
            }
            case 8611: {
                bursaWolfParameters.ppm = d;
                break;
            }
            default: {
                throw new FactoryException(Errors.format((int)210, (Object)n));
            }
        }
    }

    public DirectEpsgFactory(Hints hints, Connection connection) {
        super(hints);
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
        this.connection = connection;
        DirectEpsgFactory.ensureNonNull("connection", connection);
    }

    @Override
    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            this.createAuthority();
        }
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAuthority() {
        assert (Thread.holdsLock((Object)this));
        try {
            String string = this.adaptSQL("SELECT VERSION_NUMBER, VERSION_DATE FROM [Version History] ORDER BY VERSION_DATE DESC, VERSION_HISTORY_CODE DESC");
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            try {
                if (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    java.sql.Date date = resultSet.getDate(2);
                    String string3 = databaseMetaData.getDatabaseProductName();
                    DefaultCitation defaultCitation = new DefaultCitation((Citation)Citations.EPSG);
                    defaultCitation.getAlternateTitles().add(Vocabulary.formatInternational((int)60, (Object[])new Object[]{"EPSG", string2, string3}));
                    defaultCitation.setEdition((InternationalString)new SimpleInternationalString(string2));
                    defaultCitation.setEditionDate((Date)date);
                    defaultCitation.freeze();
                    this.authority = defaultCitation;
                    this.hints.put(Hints.VERSION, new Version(string2));
                } else {
                    this.authority = Citations.EPSG;
                }
            }
            finally {
                resultSet.close();
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            Logging.unexpectedException((Logger)LOGGER, DirectEpsgFactory.class, (String)"getAuthority", (Throwable)sQLException);
            this.authority = Citations.EPSG;
        }
    }

    @Override
    public synchronized String getBackingStoreDescription() throws FactoryException {
        Citation citation = this.getAuthority();
        TableWriter tableWriter = new TableWriter(null, " ");
        Vocabulary vocabulary = Vocabulary.getResources(null);
        InternationalString internationalString = citation.getEdition();
        if (internationalString != null) {
            tableWriter.write(vocabulary.getString(323, (Object)"EPSG"));
            tableWriter.write(58);
            tableWriter.nextColumn();
            tableWriter.write(internationalString.toString());
            tableWriter.nextLine();
        }
        try {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            if (string != null) {
                tableWriter.write(vocabulary.getLabel(55));
                tableWriter.nextColumn();
                tableWriter.write(string);
                string = databaseMetaData.getDatabaseProductVersion();
                if (string != null) {
                    tableWriter.write(32);
                    tableWriter.write(vocabulary.getString(322, (Object)string));
                }
                tableWriter.nextLine();
            }
            if ((string = databaseMetaData.getURL()) != null) {
                tableWriter.write(vocabulary.getLabel(56));
                tableWriter.nextColumn();
                tableWriter.write(string);
                tableWriter.nextLine();
            }
        }
        catch (SQLException sQLException) {
            throw new FactoryException((Throwable)sQLException);
        }
        return tableWriter.toString();
    }

    @Override
    public synchronized Map<RenderingHints.Key, ?> getImplementationHints() {
        if (this.authority == null) {
            this.createAuthority();
        }
        return super.getImplementationHints();
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return this.getAuthorityCodes0(clazz);
    }

    private synchronized Set<String> getAuthorityCodes0(Class<?> clazz) throws FactoryException {
        Reference<AuthorityCodes> reference;
        AuthorityCodes authorityCodes;
        if (this.authorityCodes == null) {
            this.authorityCodes = new HashMap();
        }
        AuthorityCodes authorityCodes2 = authorityCodes = (reference = this.authorityCodes.get(clazz)) != null ? reference.get() : null;
        if (authorityCodes != null) {
            return authorityCodes;
        }
        AbstractSet abstractSet = Collections.emptySet();
        for (TableInfo tableInfo : TABLES_INFO) {
            if (!tableInfo.type.isAssignableFrom(clazz) && !clazz.isAssignableFrom(tableInfo.type)) continue;
            AuthorityCodes authorityCodes3 = new AuthorityCodes(this.connection, tableInfo, clazz, this);
            reference = this.authorityCodes.get(authorityCodes3.type);
            AuthorityCodes authorityCodes4 = authorityCodes = reference != null ? reference.get() : null;
            if (authorityCodes == null) {
                authorityCodes = authorityCodes3;
                reference = new WeakReference<AuthorityCodes>(authorityCodes);
                this.authorityCodes.put(authorityCodes3.type, reference);
            } else assert (authorityCodes.sqlAll.equals(authorityCodes3.sqlAll)) : authorityCodes3.type;
            if (abstractSet.isEmpty()) {
                abstractSet = authorityCodes;
                continue;
            }
            if (abstractSet instanceof AuthorityCodes) {
                abstractSet = new LinkedHashSet<String>(abstractSet);
            }
            abstractSet.addAll(authorityCodes);
        }
        return abstractSet;
    }

    public InternationalString getDescriptionText(String string) throws NoSuchAuthorityCodeException, FactoryException {
        String string2 = this.trimAuthority(string);
        for (int i = 0; i < TABLES_INFO.length; ++i) {
            String string3;
            Set<String> set = this.getAuthorityCodes0(DirectEpsgFactory.TABLES_INFO[i].type);
            if (!(set instanceof AuthorityCodes) || (string3 = ((AuthorityCodes)set).asMap().get(string2)) == null) continue;
            return new SimpleInternationalString(string3);
        }
        ReferenceIdentifier referenceIdentifier = this.createObject(string).getName();
        if (referenceIdentifier instanceof GenericName) {
            return ((GenericName)referenceIdentifier).toInternationalString();
        }
        return new SimpleInternationalString(referenceIdentifier.getCode());
    }

    private PreparedStatement prepareStatement(String string, String string2) throws SQLException {
        assert (Thread.holdsLock((Object)this));
        PreparedStatement preparedStatement = this.statements.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.connection.prepareStatement(this.adaptSQL(string2));
            this.statements.put(string, preparedStatement);
        }
        assert (preparedStatement.getParameterMetaData().getParameterCount() == Strings.count((String)string2, (char)'?'));
        return preparedStatement;
    }

    private static String getString(ResultSet resultSet, int n, Object object) throws SQLException, FactoryException {
        String string = resultSet.getString(n);
        DirectEpsgFactory.ensureNonNull(resultSet, n, object);
        return string.trim();
    }

    private static String getString(ResultSet resultSet, int n, String string, int n2) throws SQLException, FactoryException {
        String string2 = resultSet.getString(n);
        if (resultSet.wasNull()) {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String string3 = resultSetMetaData.getColumnName(n2);
            String string4 = resultSetMetaData.getTableName(n2);
            resultSet.close();
            throw new FactoryException(Errors.format((int)176, (Object)string, (Object)string3, (Object)string4));
        }
        return string2.trim();
    }

    private static double getDouble(ResultSet resultSet, int n, Object object) throws SQLException, FactoryException {
        double d = resultSet.getDouble(n);
        DirectEpsgFactory.ensureNonNull(resultSet, n, object);
        return d;
    }

    private static int getInt(ResultSet resultSet, int n, Object object) throws SQLException, FactoryException {
        int n2 = resultSet.getInt(n);
        DirectEpsgFactory.ensureNonNull(resultSet, n, object);
        return n2;
    }

    private static void ensureNonNull(ResultSet resultSet, int n, Object object) throws SQLException, FactoryException {
        if (resultSet.wasNull()) {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String string = resultSetMetaData.getColumnName(n);
            String string2 = resultSetMetaData.getTableName(n);
            resultSet.close();
            throw new FactoryException(Errors.format((int)176, (Object)object, (Object)string, (Object)string2));
        }
    }

    static ResultSet executeQuery(PreparedStatement preparedStatement, String string) throws NoSuchIdentifierException, SQLException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            NoSuchIdentifierException noSuchIdentifierException = new NoSuchIdentifierException(Errors.format((int)82, (Object)string), string);
            noSuchIdentifierException.initCause((Throwable)numberFormatException);
            throw noSuchIdentifierException;
        }
        preparedStatement.setInt(1, n);
        return preparedStatement.executeQuery();
    }

    private static ResultSet executeQuery(PreparedStatement preparedStatement, String string, String string2) throws NoSuchIdentifierException, SQLException {
        int n;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            NoSuchIdentifierException noSuchIdentifierException = new NoSuchIdentifierException(Errors.format((int)82, (Object)string2), string2);
            noSuchIdentifierException.initCause((Throwable)numberFormatException);
            throw noSuchIdentifierException;
        }
        preparedStatement.setInt(2, n);
        return DirectEpsgFactory.executeQuery(preparedStatement, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toPrimaryKey(Class<?> clazz, String string, String string2, String string3, String string4) throws SQLException, FactoryException {
        assert (Thread.holdsLock((Object)this));
        String string5 = this.trimAuthority(string);
        if (!this.isPrimaryKey(string5)) {
            Object object;
            PreparedStatement preparedStatement = this.statements.get("NumericalIdentifier");
            if (preparedStatement != null && !string2.equals(this.lastTableForName)) {
                this.statements.remove("NumericalIdentifier");
                preparedStatement.close();
                preparedStatement = null;
                this.lastTableForName = null;
            }
            if (preparedStatement == null) {
                object = "SELECT " + string3 + " FROM " + string2 + " WHERE " + string4 + " = ?";
                preparedStatement = this.connection.prepareStatement(this.adaptSQL((String)object));
                this.statements.put("NumericalIdentifier", preparedStatement);
            }
            preparedStatement.setString(1, string5);
            string5 = null;
            object = preparedStatement.executeQuery();
            try {
                while (object.next()) {
                    string5 = DirectEpsgFactory.ensureSingleton(object.getString(1), string5, string);
                }
            }
            finally {
                object.close();
            }
            if (string5 == null) {
                throw this.noSuchAuthorityCode(clazz, string);
            }
        }
        return string5;
    }

    private static <T> T ensureSingleton(T t, T t2, String string) throws FactoryException {
        if (t2 == null) {
            return t;
        }
        if (t2.equals(t)) {
            return t2;
        }
        throw new FactoryException(Errors.format((int)55, (Object)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> createProperties(String string, String string2, String string3, String string4, boolean bl) throws SQLException, FactoryException {
        Object object;
        Object object2;
        Object object3;
        this.properties.clear();
        Citation citation = this.getAuthority();
        if (string2 != null) {
            this.properties.put("name", (Object)new NamedIdentifier(citation, string2.trim()));
        }
        if (string3 != null) {
            string3 = string3.trim();
            object3 = citation.getEdition();
            object2 = object3 != null ? object3.toString() : null;
            object = bl ? new DeprecatedCode(citation, "EPSG", string3, (String)object2, null) : new DefaultReferenceIdentifier(citation, "EPSG", string3, (String)object2, null);
            this.properties.put("identifiers", object);
        }
        if (string4 != null && !(string4 = string4.trim()).isEmpty()) {
            this.properties.put("remarks", string4);
        }
        object3 = null;
        object2 = this.prepareStatement("[Alias]", "SELECT NAMING_SYSTEM_NAME, ALIAS, OBJECT_TABLE_NAME FROM [Alias] INNER JOIN [Naming System] ON [Alias].NAMING_SYSTEM_CODE = [Naming System].NAMING_SYSTEM_CODE WHERE OBJECT_CODE = ?");
        object = DirectEpsgFactory.executeQuery((PreparedStatement)object2, string3);
        try {
            while (object.next()) {
                LocalName localName;
                String string5 = object.getString(3);
                if (string5 != null) {
                    if (string5.startsWith("epsg_")) {
                        string5 = string5.substring("epsg_".length());
                    }
                    if (!Strings.isAcronymForWords((CharSequence)string5, (CharSequence)string)) continue;
                }
                String string6 = object.getString(1);
                String string7 = DirectEpsgFactory.getString(object, 2, string3);
                if (string6 == null) {
                    localName = this.nameFactory.createLocalName(null, (CharSequence)string7);
                } else {
                    NameSpace nameSpace = this.scopes.get(string6);
                    if (nameSpace == null) {
                        nameSpace = this.nameFactory.createNameSpace((GenericName)this.nameFactory.createLocalName(null, (CharSequence)string6), Collections.singletonMap("separator", ":"));
                        this.scopes.put(string6, nameSpace);
                    }
                    localName = this.nameFactory.createLocalName(nameSpace, (CharSequence)string7);
                }
                if (object3 == null) {
                    object3 = new ArrayList();
                }
                object3.add(localName);
            }
        }
        finally {
            object.close();
        }
        if (object3 != null) {
            this.properties.put("alias", object3.toArray(new GenericName[object3.size()]));
        }
        return this.properties;
    }

    private Map<String, Object> createProperties(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws SQLException, FactoryException {
        Map<String, Object> map = this.createProperties(string, string2, string3, string6, bl);
        if (string4 != null && !(string4 = string4.trim()).isEmpty()) {
            Extent extent = this.buffered.createExtent(string4);
            map.put("domainOfValidity", extent);
        }
        if (string5 != null && !(string5 = string5.trim()).isEmpty()) {
            map.put("scope", string5);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IdentifiedObject createObject(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        PreparedStatement preparedStatement = this.statements.get("IdentifiedObject");
        StringBuilder stringBuilder = null;
        String string2 = this.trimAuthority(string);
        boolean bl = this.isPrimaryKey(string2);
        int n = bl ? this.lastObjectType : -1;
        int n2 = -1;
        for (int i = -1; i < TABLES_INFO.length; ++i) {
            if (i == n) continue;
            try {
                boolean bl2;
                Object object;
                if (i >= 0) {
                    String string3;
                    object = TABLES_INFO[i];
                    String string4 = string3 = bl ? ((TableInfo)object).codeColumn : ((TableInfo)object).nameColumn;
                    if (string3 == null) continue;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder("SELECT ");
                    }
                    stringBuilder.setLength(7);
                    stringBuilder.append(((TableInfo)object).codeColumn).append(" FROM ").append(((TableInfo)object).table).append(" WHERE ").append(string3).append(" = ?");
                    if (bl) {
                        assert (!this.statements.containsKey("IdentifiedObject")) : object;
                        preparedStatement = this.prepareStatement("IdentifiedObject", stringBuilder.toString());
                    } else {
                        preparedStatement = this.connection.prepareStatement(this.adaptSQL(stringBuilder.toString()));
                    }
                }
                if (bl) {
                    object = DirectEpsgFactory.executeQuery(preparedStatement, string2);
                } else {
                    preparedStatement.setString(1, string2);
                    object = preparedStatement.executeQuery();
                }
                try {
                    bl2 = object.next();
                }
                finally {
                    object.close();
                }
                if (bl2) {
                    if (n2 >= 0) {
                        throw new FactoryException(Errors.format((int)55, (Object)string));
                    }
                    int n3 = n2 = i < 0 ? this.lastObjectType : i;
                    if (bl) break;
                }
                if (bl && this.statements.remove("IdentifiedObject") == null) {
                    throw new AssertionError((Object)string);
                }
                preparedStatement.close();
                continue;
            }
            catch (SQLException sQLException) {
                throw DirectEpsgFactory.databaseFailure(IdentifiedObject.class, string, sQLException);
            }
        }
        if (bl) {
            this.lastObjectType = n2;
        }
        if (n2 >= 0) {
            switch (n2) {
                case 0: {
                    return this.createCoordinateReferenceSystem(string);
                }
                case 1: {
                    return this.createCoordinateSystem(string);
                }
                case 2: {
                    return this.createCoordinateSystemAxis(string);
                }
                case 3: {
                    return this.createDatum(string);
                }
                case 4: {
                    return this.createEllipsoid(string);
                }
                case 5: {
                    return this.createPrimeMeridian(string);
                }
                case 6: {
                    return this.createCoordinateOperation(string);
                }
                case 7: {
                    return this.createOperationMethod(string);
                }
                case 8: {
                    return this.createParameterDescriptor(string);
                }
                case 9: {
                    break;
                }
                default: {
                    throw new AssertionError(n2);
                }
            }
        }
        return super.createObject(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Unit<?> createUnit(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        Unit unit = null;
        try {
            String string2 = this.toPrimaryKey(Unit.class, string, "[Unit of Measure]", "UOM_CODE", "UNIT_OF_MEAS_NAME");
            PreparedStatement preparedStatement = this.prepareStatement("[Unit of Measure]", "SELECT UOM_CODE, FACTOR_B, FACTOR_C, TARGET_UOM_CODE FROM [Unit of Measure] WHERE UOM_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    int n = DirectEpsgFactory.getInt(resultSet, 1, string);
                    double d = resultSet.getDouble(2);
                    double d2 = resultSet.getDouble(3);
                    int n2 = DirectEpsgFactory.getInt(resultSet, 4, string);
                    Unit unit2 = Units.valueOfEPSG((int)n2);
                    if (unit2 == null) {
                        throw this.noSuchAuthorityCode(Unit.class, String.valueOf(n2));
                    }
                    Unit unit3 = Units.valueOfEPSG((int)n);
                    if (unit3 == null) {
                        if (d != 0.0 && d2 != 0.0) {
                            unit3 = Units.multiply((Unit)unit2, (double)(d / d2));
                        } else {
                            throw new FactoryException("Unsupported unit: " + string);
                        }
                    }
                    unit = DirectEpsgFactory.ensureSingleton(unit3, unit, string);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(Unit.class, string, sQLException);
        }
        if (unit == null) {
            throw this.noSuchAuthorityCode(Unit.class, string);
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Ellipsoid createEllipsoid(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        Ellipsoid ellipsoid = null;
        try {
            String string2 = this.toPrimaryKey(Ellipsoid.class, string, "[Ellipsoid]", "ELLIPSOID_CODE", "ELLIPSOID_NAME");
            PreparedStatement preparedStatement = this.prepareStatement("[Ellipsoid]", "SELECT ELLIPSOID_CODE, ELLIPSOID_NAME, SEMI_MAJOR_AXIS, INV_FLATTENING, SEMI_MINOR_AXIS, UOM_CODE, REMARKS, DEPRECATED FROM [Ellipsoid] WHERE ELLIPSOID_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    Ellipsoid ellipsoid2;
                    Object object;
                    String string3 = DirectEpsgFactory.getString(resultSet, 1, string);
                    String string4 = DirectEpsgFactory.getString(resultSet, 2, string);
                    double d = DirectEpsgFactory.getDouble(resultSet, 3, string);
                    double d2 = resultSet.getDouble(4);
                    double d3 = resultSet.getDouble(5);
                    String string5 = DirectEpsgFactory.getString(resultSet, 6, string);
                    String string6 = resultSet.getString(7);
                    boolean bl = resultSet.getInt(8) != 0;
                    Unit unit = this.buffered.createUnit(string5).asType(Length.class);
                    Map<String, Object> map = this.createProperties("[Ellipsoid]", string4, string3, string6, bl);
                    if (d2 == 0.0) {
                        if (d3 == 0.0) {
                            object = resultSet.getMetaData().getColumnName(3);
                            throw new FactoryException(Errors.format((int)176, (Object)string, (Object)object));
                        }
                        ellipsoid2 = this.factories.getDatumFactory().createEllipsoid(map, d, d3, unit);
                    } else {
                        if (d3 != 0.0) {
                            object = Loggings.format((Level)Level.WARNING, (int)1, (Object)string);
                            ((LogRecord)object).setLoggerName(LOGGER.getName());
                            LOGGER.log((LogRecord)object);
                        }
                        ellipsoid2 = this.factories.getDatumFactory().createFlattenedSphere(map, d, d2, unit);
                    }
                    ellipsoid = DirectEpsgFactory.ensureSingleton(ellipsoid2, ellipsoid, string);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(Ellipsoid.class, string, sQLException);
        }
        if (ellipsoid == null) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, string);
        }
        return ellipsoid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PrimeMeridian createPrimeMeridian(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        PrimeMeridian primeMeridian = null;
        try {
            String string2 = this.toPrimaryKey(PrimeMeridian.class, string, "[Prime Meridian]", "PRIME_MERIDIAN_CODE", "PRIME_MERIDIAN_NAME");
            PreparedStatement preparedStatement = this.prepareStatement("[Prime Meridian]", "SELECT PRIME_MERIDIAN_CODE, PRIME_MERIDIAN_NAME, GREENWICH_LONGITUDE, UOM_CODE, REMARKS, DEPRECATED FROM [Prime Meridian] WHERE PRIME_MERIDIAN_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    String string3 = DirectEpsgFactory.getString(resultSet, 1, string);
                    String string4 = DirectEpsgFactory.getString(resultSet, 2, string);
                    double d = DirectEpsgFactory.getDouble(resultSet, 3, string);
                    String string5 = DirectEpsgFactory.getString(resultSet, 4, string);
                    String string6 = resultSet.getString(5);
                    boolean bl = resultSet.getInt(6) != 0;
                    Unit unit = this.buffered.createUnit(string5).asType(Angle.class);
                    Map<String, Object> map = this.createProperties("[Prime Meridian]", string4, string3, string6, bl);
                    PrimeMeridian primeMeridian2 = this.factories.getDatumFactory().createPrimeMeridian(map, d, unit);
                    primeMeridian = DirectEpsgFactory.ensureSingleton(primeMeridian2, primeMeridian, string);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(PrimeMeridian.class, string, sQLException);
        }
        if (primeMeridian == null) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, string);
        }
        return primeMeridian;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Extent createExtent(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        Extent extent = null;
        try {
            String string2 = this.toPrimaryKey(Extent.class, string, "[Area]", "AREA_CODE", "AREA_NAME");
            PreparedStatement preparedStatement = this.prepareStatement("[Area]", "SELECT AREA_OF_USE, AREA_SOUTH_BOUND_LAT, AREA_NORTH_BOUND_LAT, AREA_WEST_BOUND_LON, AREA_EAST_BOUND_LON FROM [Area] WHERE AREA_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    DefaultExtent defaultExtent = null;
                    String string3 = resultSet.getString(1);
                    if (string3 != null) {
                        defaultExtent = new DefaultExtent();
                        defaultExtent.setDescription((InternationalString)new SimpleInternationalString(string3));
                    }
                    double d = resultSet.getDouble(2);
                    if (resultSet.wasNull()) {
                        d = Double.NaN;
                    }
                    double d2 = resultSet.getDouble(3);
                    if (resultSet.wasNull()) {
                        d2 = Double.NaN;
                    }
                    double d3 = resultSet.getDouble(4);
                    if (resultSet.wasNull()) {
                        d3 = Double.NaN;
                    }
                    double d4 = resultSet.getDouble(5);
                    if (resultSet.wasNull()) {
                        d4 = Double.NaN;
                    }
                    if (!(Double.isNaN(d) && Double.isNaN(d2) && Double.isNaN(d3) && Double.isNaN(d4))) {
                        if (d3 > d4) {
                            d3 = -d3;
                            d4 = -d4;
                        }
                        if (d > d2) {
                            d = -d;
                            d2 = -d2;
                        }
                        if (defaultExtent == null) {
                            defaultExtent = new DefaultExtent();
                        }
                        defaultExtent.setGeographicElements(Collections.singleton(new DefaultGeographicBoundingBox(d3, d4, d, d2)));
                    }
                    if (defaultExtent == null) continue;
                    defaultExtent.freeze();
                    extent = DirectEpsgFactory.ensureSingleton(defaultExtent, extent, string);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(Extent.class, string, sQLException);
        }
        if (extent == null) {
            throw this.noSuchAuthorityCode(Extent.class, string);
        }
        return extent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BursaWolfParameters[] createBursaWolfParameters(String string, ResultSet resultSet) throws SQLException, FactoryException {
        Object object;
        Object object2;
        int n;
        if (this.safetyGuard.contains(string)) {
            return null;
        }
        PreparedStatement preparedStatement = this.prepareStatement("BursaWolfParametersSet", "SELECT CO.COORD_OP_CODE, CO.COORD_OP_METHOD_CODE, CRS2.DATUM_CODE FROM [Coordinate_Operation] AS CO INNER JOIN [Coordinate Reference System] AS CRS2 ON CO.TARGET_CRS_CODE = CRS2.COORD_REF_SYS_CODE WHERE CO.COORD_OP_METHOD_CODE >= 9603 AND CO.COORD_OP_METHOD_CODE <= 9607 AND CO.SOURCE_CRS_CODE IN ( SELECT CRS1.COORD_REF_SYS_CODE  FROM [Coordinate Reference System] AS CRS1  WHERE CRS1.DATUM_CODE = ?) ORDER BY CRS2.DATUM_CODE, ABS(CO.DEPRECATED), CO.COORD_OP_ACCURACY, CO.COORD_OP_CODE DESC");
        ArrayList<BursaWolfInfo> arrayList = null;
        ResultSet resultSet2 = DirectEpsgFactory.executeQuery(preparedStatement, string);
        try {
            while (resultSet2.next()) {
                n = DirectEpsgFactory.getInt(resultSet2, 1, string);
                int n2 = DirectEpsgFactory.getInt(resultSet2, 2, string);
                object2 = DirectEpsgFactory.getString(resultSet2, 3, string);
                if (arrayList == null) {
                    arrayList = new ArrayList<BursaWolfInfo>();
                }
                arrayList.add(new BursaWolfInfo(n, n2, (String)object2));
            }
        }
        finally {
            resultSet2.close();
        }
        if (arrayList == null) {
            return null;
        }
        resultSet.close();
        n = arrayList.size();
        if (n > 1) {
            Object[] objectArray = arrayList.toArray(new BursaWolfInfo[n]);
            this.sort(objectArray);
            arrayList.clear();
            object2 = new HashSet();
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (!object2.add(((BursaWolfInfo)object).target)) continue;
                arrayList.add((BursaWolfInfo)object);
            }
            n = arrayList.size();
        }
        preparedStatement = this.prepareStatement("BursaWolfParameters", "SELECT PARAMETER_CODE, PARAMETER_VALUE, UOM_CODE FROM [Coordinate_Operation Parameter Value] WHERE COORD_OP_CODE = ? AND COORD_OP_METHOD_CODE = ?");
        for (int i = 0; i < n; ++i) {
            GeodeticDatum geodeticDatum;
            object2 = (BursaWolfInfo)arrayList.get(i);
            try {
                this.safetyGuard.add(string);
                geodeticDatum = this.buffered.createGeodeticDatum(((BursaWolfInfo)object2).target);
            }
            finally {
                this.safetyGuard.remove(string);
            }
            object = new BursaWolfParameters(geodeticDatum);
            preparedStatement.setInt(1, ((BursaWolfInfo)object2).operation);
            preparedStatement.setInt(2, ((BursaWolfInfo)object2).method);
            resultSet2 = preparedStatement.executeQuery();
            try {
                while (resultSet2.next()) {
                    DirectEpsgFactory.setBursaWolfParameter((BursaWolfParameters)object, DirectEpsgFactory.getInt(resultSet2, 1, ((BursaWolfInfo)object2).operation), DirectEpsgFactory.getDouble(resultSet2, 2, ((BursaWolfInfo)object2).operation), this.buffered.createUnit(DirectEpsgFactory.getString(resultSet2, 3, ((BursaWolfInfo)object2).operation)));
                }
            }
            finally {
                resultSet2.close();
            }
            if (((BursaWolfInfo)object2).method == 9607) {
                ((BursaWolfParameters)object).ex = -((BursaWolfParameters)object).ex;
                ((BursaWolfParameters)object).ey = -((BursaWolfParameters)object).ey;
                ((BursaWolfParameters)object).ey = -((BursaWolfParameters)object).ey;
            }
            arrayList.set(i, (BursaWolfInfo)object);
        }
        return arrayList.toArray(new BursaWolfParameters[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Datum createDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        Datum datum = null;
        try {
            String string2 = this.toPrimaryKey(Datum.class, string, "[Datum]", "DATUM_CODE", "DATUM_NAME");
            PreparedStatement preparedStatement = this.prepareStatement("[Datum]", "SELECT DATUM_CODE, DATUM_NAME, DATUM_TYPE, ORIGIN_DESCRIPTION, REALIZATION_EPOCH, AREA_OF_USE_CODE, DATUM_SCOPE, REMARKS, DEPRECATED, ELLIPSOID_CODE, PRIME_MERIDIAN_CODE FROM [Datum] WHERE DATUM_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    VerticalDatum verticalDatum;
                    Ellipsoid ellipsoid;
                    String string3 = DirectEpsgFactory.getString(resultSet, 1, string);
                    String string4 = DirectEpsgFactory.getString(resultSet, 2, string);
                    String string5 = DirectEpsgFactory.getString(resultSet, 3, string).trim();
                    String string6 = resultSet.getString(4);
                    String string7 = resultSet.getString(5);
                    String string8 = resultSet.getString(6);
                    String string9 = resultSet.getString(7);
                    String string10 = resultSet.getString(8);
                    boolean bl = resultSet.getInt(9) != 0;
                    Map<String, Object> map = this.createProperties("[Datum]", string4, string3, string8, string9, string10, bl);
                    if (string6 != null) {
                        map.put("anchorPoint", string6);
                    }
                    if (string7 != null && !string7.isEmpty()) {
                        try {
                            int n = Integer.parseInt(string7);
                            if (this.calendar == null) {
                                this.calendar = Calendar.getInstance();
                            }
                            this.calendar.clear();
                            this.calendar.set(n, 0, 1);
                            map.put("realizationEpoch", this.calendar.getTime());
                        }
                        catch (NumberFormatException numberFormatException) {
                            Logging.unexpectedException((Logger)LOGGER, DirectEpsgFactory.class, (String)"createDatum", (Throwable)numberFormatException);
                        }
                    }
                    DatumFactory datumFactory = this.factories.getDatumFactory();
                    if (string5.equalsIgnoreCase("geodetic")) {
                        map = new HashMap<String, Object>(map);
                        ellipsoid = this.buffered.createEllipsoid(DirectEpsgFactory.getString(resultSet, 10, string));
                        PrimeMeridian primeMeridian = this.buffered.createPrimeMeridian(DirectEpsgFactory.getString(resultSet, 11, string));
                        BursaWolfParameters[] bursaWolfParametersArray = this.createBursaWolfParameters(string2, resultSet);
                        if (bursaWolfParametersArray != null) {
                            map.put("bursaWolf", bursaWolfParametersArray);
                        }
                        verticalDatum = datumFactory.createGeodeticDatum(map, ellipsoid, primeMeridian);
                    } else if (string5.equalsIgnoreCase("vertical")) {
                        verticalDatum = datumFactory.createVerticalDatum(map, VerticalDatumType.GEOIDAL);
                    } else {
                        if (!string5.equalsIgnoreCase("engineering")) throw new FactoryException(Errors.format((int)226, (Object)string5));
                        verticalDatum = datumFactory.createEngineeringDatum(map);
                    }
                    datum = DirectEpsgFactory.ensureSingleton(verticalDatum, datum, string);
                    if (!resultSet.isClosed()) continue;
                    ellipsoid = datum;
                    return ellipsoid;
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(Datum.class, string, sQLException);
        }
        if (datum != null) return datum;
        throw this.noSuchAuthorityCode(Datum.class, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AxisName getAxisName(String string) throws FactoryException {
        AxisName axisName;
        assert (Thread.holdsLock((Object)this));
        if (this.axisNames == null) {
            this.axisNames = new HashMap<String, AxisName>();
        }
        if ((axisName = this.axisNames.get(string)) == null) {
            try {
                PreparedStatement preparedStatement = this.prepareStatement("[Coordinate Axis Name]", "SELECT COORD_AXIS_NAME, DESCRIPTION, REMARKS FROM [Coordinate Axis Name] WHERE COORD_AXIS_NAME_CODE = ?");
                ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string);
                try {
                    while (resultSet.next()) {
                        String string2 = DirectEpsgFactory.getString(resultSet, 1, string);
                        String string3 = resultSet.getString(2);
                        String string4 = resultSet.getString(3);
                        if (string3 == null) {
                            string3 = string4;
                        } else if (string4 != null) {
                            string3 = string3 + System.getProperty("line.separator", "\n") + string4;
                        }
                        AxisName axisName2 = new AxisName(string2, string3);
                        axisName = DirectEpsgFactory.ensureSingleton(axisName2, axisName, string);
                    }
                }
                finally {
                    resultSet.close();
                }
                if (axisName == null) {
                    throw this.noSuchAuthorityCode(AxisName.class, string);
                }
                this.axisNames.put(string, axisName);
            }
            catch (SQLException sQLException) {
                throw DirectEpsgFactory.databaseFailure(AxisName.class, string, sQLException);
            }
        }
        return axisName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CoordinateSystemAxis createCoordinateSystemAxis(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        CoordinateSystemAxis coordinateSystemAxis = null;
        try {
            String string2 = this.trimAuthority(string);
            PreparedStatement preparedStatement = this.prepareStatement("[Coordinate Axis]", "SELECT COORD_AXIS_CODE, COORD_AXIS_NAME_CODE, COORD_AXIS_ORIENTATION, COORD_AXIS_ABBREVIATION, UOM_CODE FROM [Coordinate Axis] WHERE COORD_AXIS_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    AxisDirection axisDirection;
                    String string3 = DirectEpsgFactory.getString(resultSet, 1, string);
                    String string4 = DirectEpsgFactory.getString(resultSet, 2, string);
                    String string5 = DirectEpsgFactory.getString(resultSet, 3, string);
                    String string6 = DirectEpsgFactory.getString(resultSet, 4, string);
                    String string7 = DirectEpsgFactory.getString(resultSet, 5, string);
                    try {
                        axisDirection = DefaultCoordinateSystemAxis.getDirection(string5);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new FactoryException(noSuchElementException.getLocalizedMessage(), (Throwable)noSuchElementException);
                    }
                    AxisName axisName = this.getAxisName(string4);
                    Map<String, Object> map = this.createProperties("[Coordinate Axis]", axisName.name, string3, axisName.description, false);
                    CSFactory cSFactory = this.factories.getCSFactory();
                    CoordinateSystemAxis coordinateSystemAxis2 = cSFactory.createCoordinateSystemAxis(map, string6, axisDirection, this.buffered.createUnit(string7));
                    coordinateSystemAxis = DirectEpsgFactory.ensureSingleton(coordinateSystemAxis2, coordinateSystemAxis, string);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(CoordinateSystemAxis.class, string, sQLException);
        }
        if (coordinateSystemAxis == null) {
            throw this.noSuchAuthorityCode(CoordinateSystemAxis.class, string);
        }
        return coordinateSystemAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinateSystemAxis[] createAxesForCoordinateSystem(String string, int n) throws SQLException, FactoryException {
        assert (Thread.holdsLock((Object)this));
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n];
        PreparedStatement preparedStatement = this.prepareStatement("AxisOrder", "SELECT COORD_AXIS_CODE FROM [Coordinate Axis] WHERE COORD_SYS_CODE = ? ORDER BY [ORDER]");
        int n2 = 0;
        ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string);
        try {
            while (resultSet.next()) {
                String string2 = DirectEpsgFactory.getString(resultSet, 1, string);
                if (n2 < coordinateSystemAxisArray.length) {
                    coordinateSystemAxisArray[n2] = this.buffered.createCoordinateSystemAxis(string2);
                }
                ++n2;
            }
        }
        finally {
            resultSet.close();
        }
        if (n2 != coordinateSystemAxisArray.length) {
            throw new FactoryException(Errors.format((int)112, (Object)coordinateSystemAxisArray.length, (Object)n2));
        }
        return coordinateSystemAxisArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CoordinateSystem createCoordinateSystem(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        CoordinateSystem coordinateSystem = null;
        try {
            String string2 = this.toPrimaryKey(CoordinateSystem.class, string, "[Coordinate System]", "COORD_SYS_CODE", "COORD_SYS_NAME");
            PreparedStatement preparedStatement = this.prepareStatement("[Coordinate System]", "SELECT COORD_SYS_CODE, COORD_SYS_NAME, COORD_SYS_TYPE, DIMENSION, REMARKS, DEPRECATED FROM [Coordinate System] WHERE COORD_SYS_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    String string3 = DirectEpsgFactory.getString(resultSet, 1, string);
                    String string4 = DirectEpsgFactory.getString(resultSet, 2, string);
                    String string5 = DirectEpsgFactory.getString(resultSet, 3, string).trim();
                    int n = DirectEpsgFactory.getInt(resultSet, 4, string);
                    String string6 = resultSet.getString(5);
                    boolean bl = resultSet.getInt(6) != 0;
                    CoordinateSystemAxis[] coordinateSystemAxisArray = this.createAxesForCoordinateSystem(string2, n);
                    Map<String, Object> map = this.createProperties("[Coordinate System]", string4, string3, string6, bl);
                    CSFactory cSFactory = this.factories.getCSFactory();
                    EllipsoidalCS ellipsoidalCS = null;
                    if (string5.equalsIgnoreCase("ellipsoidal")) {
                        switch (n) {
                            case 2: {
                                ellipsoidalCS = cSFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                                break;
                            }
                            case 3: {
                                ellipsoidalCS = cSFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                            }
                        }
                    } else if (string5.equalsIgnoreCase("cartesian")) {
                        switch (n) {
                            case 2: {
                                ellipsoidalCS = cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                                break;
                            }
                            case 3: {
                                ellipsoidalCS = cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                            }
                        }
                    } else if (string5.equalsIgnoreCase("spherical")) {
                        switch (n) {
                            case 3: {
                                ellipsoidalCS = cSFactory.createSphericalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                            }
                        }
                    } else if (string5.equalsIgnoreCase("vertical") || string5.equalsIgnoreCase("gravity-related")) {
                        switch (n) {
                            case 1: {
                                ellipsoidalCS = cSFactory.createVerticalCS(map, coordinateSystemAxisArray[0]);
                            }
                        }
                    } else if (string5.equalsIgnoreCase("linear")) {
                        switch (n) {
                            case 1: {
                                ellipsoidalCS = cSFactory.createLinearCS(map, coordinateSystemAxisArray[0]);
                            }
                        }
                    } else if (string5.equalsIgnoreCase("polar")) {
                        switch (n) {
                            case 2: {
                                ellipsoidalCS = cSFactory.createPolarCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                            }
                        }
                    } else if (string5.equalsIgnoreCase("cylindrical")) {
                        switch (n) {
                            case 3: {
                                ellipsoidalCS = cSFactory.createCylindricalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                            }
                        }
                    } else if (string5.equalsIgnoreCase("affine")) {
                        switch (n) {
                            case 2: {
                                ellipsoidalCS = cSFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                                break;
                            }
                            case 3: {
                                ellipsoidalCS = cSFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                            }
                        }
                    } else {
                        throw new FactoryException(Errors.format((int)226, (Object)string5));
                    }
                    if (ellipsoidalCS == null) {
                        throw new FactoryException(Errors.format((int)207, (Object)string5));
                    }
                    coordinateSystem = DirectEpsgFactory.ensureSingleton(ellipsoidalCS, coordinateSystem, string);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(CoordinateSystem.class, string, sQLException);
        }
        if (coordinateSystem == null) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, string);
        }
        return coordinateSystem;
    }

    private String toPrimaryKeyCRS(String string) throws SQLException, FactoryException {
        return this.toPrimaryKey(CoordinateReferenceSystem.class, string, "[Coordinate Reference System]", "COORD_REF_SYS_CODE", "COORD_REF_SYS_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        try {
            String string2 = this.toPrimaryKeyCRS(string);
            PreparedStatement preparedStatement = this.prepareStatement("[Coordinate Reference System]", "SELECT COORD_REF_SYS_CODE, COORD_REF_SYS_NAME, AREA_OF_USE_CODE, CRS_SCOPE, REMARKS, DEPRECATED, COORD_REF_SYS_KIND, COORD_SYS_CODE, DATUM_CODE, SOURCE_GEOGCRS_CODE, PROJECTION_CONV_CODE, CMPD_HORIZCRS_CODE, CMPD_VERTCRS_CODE FROM [Coordinate Reference System] WHERE COORD_REF_SYS_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    GeographicCRS geographicCRS;
                    GeographicCRS geographicCRS2;
                    Map<String, Object> map;
                    GeodeticDatum geodeticDatum;
                    Object object;
                    String string3;
                    String string4;
                    String string5 = DirectEpsgFactory.getString(resultSet, 1, string);
                    String string6 = DirectEpsgFactory.getString(resultSet, 2, string);
                    String string7 = resultSet.getString(3);
                    String string8 = resultSet.getString(4);
                    String string9 = resultSet.getString(5);
                    boolean bl = resultSet.getInt(6) != 0;
                    String string10 = DirectEpsgFactory.getString(resultSet, 7, string);
                    CRSFactory cRSFactory = this.factories.getCRSFactory();
                    if (string10.equalsIgnoreCase("geographic 2D") || string10.equalsIgnoreCase("geographic 3D")) {
                        string4 = DirectEpsgFactory.getString(resultSet, 8, string);
                        string3 = resultSet.getString(9);
                        object = this.buffered.createEllipsoidalCS(string4);
                        if (string3 != null) {
                            geodeticDatum = this.buffered.createGeodeticDatum(string3);
                        } else {
                            map = DirectEpsgFactory.getString(resultSet, 10, string, 9);
                            resultSet.close();
                            geographicCRS2 = this.buffered.createGeographicCRS((String)((Object)map));
                            geodeticDatum = geographicCRS2.getDatum();
                        }
                        map = this.createProperties("[Coordinate Reference System]", string6, string5, string7, string8, string9, bl);
                        geographicCRS = cRSFactory.createGeographicCRS((Map)map, geodeticDatum, (EllipsoidalCS)object);
                    } else if (string10.equalsIgnoreCase("projected")) {
                        string4 = DirectEpsgFactory.getString(resultSet, 8, string);
                        string3 = DirectEpsgFactory.getString(resultSet, 10, string);
                        object = DirectEpsgFactory.getString(resultSet, 11, string);
                        resultSet.close();
                        geodeticDatum = this.buffered.createCartesianCS(string4);
                        map = this.buffered.createGeographicCRS(string3);
                        geographicCRS2 = this.buffered.createCoordinateOperation((String)object);
                        if (!(geographicCRS2 instanceof Conversion)) throw this.noSuchAuthorityCode(Projection.class, (String)object);
                        Map<String, Object> map2 = this.createProperties("[Coordinate Reference System]", string6, string5, string7, string8, string9, bl);
                        geographicCRS = cRSFactory.createProjectedCRS(map2, map, (Conversion)geographicCRS2, (CartesianCS)geodeticDatum);
                    } else if (string10.equalsIgnoreCase("vertical")) {
                        string4 = DirectEpsgFactory.getString(resultSet, 8, string);
                        string3 = DirectEpsgFactory.getString(resultSet, 9, string);
                        object = this.buffered.createVerticalCS(string4);
                        geodeticDatum = this.buffered.createVerticalDatum(string3);
                        map = this.createProperties("[Coordinate Reference System]", string6, string5, string7, string8, string9, bl);
                        geographicCRS = cRSFactory.createVerticalCRS(map, (VerticalDatum)geodeticDatum, (VerticalCS)object);
                    } else if (string10.equalsIgnoreCase("compound")) {
                        string4 = DirectEpsgFactory.getString(resultSet, 12, string);
                        string3 = DirectEpsgFactory.getString(resultSet, 13, string);
                        resultSet.close();
                        if (!this.safetyGuard.add(string5)) {
                            throw DirectEpsgFactory.recursiveCall(CompoundCRS.class, string5);
                        }
                        try {
                            object = this.buffered.createCoordinateReferenceSystem(string4);
                            geodeticDatum = this.buffered.createCoordinateReferenceSystem(string3);
                        }
                        finally {
                            this.safetyGuard.remove(string5);
                        }
                        map = this.createProperties("[Coordinate Reference System]", string6, string5, string7, string8, string9, bl);
                        geographicCRS = cRSFactory.createCompoundCRS(map, new CoordinateReferenceSystem[]{object, geodeticDatum});
                    } else if (string10.equalsIgnoreCase("geocentric")) {
                        string4 = DirectEpsgFactory.getString(resultSet, 8, string);
                        string3 = DirectEpsgFactory.getString(resultSet, 9, string);
                        object = this.buffered.createCoordinateSystem(string4);
                        geodeticDatum = this.buffered.createGeodeticDatum(string3);
                        map = this.createProperties("[Coordinate Reference System]", string6, string5, string7, string8, string9, bl);
                        if (object instanceof CartesianCS) {
                            geographicCRS = cRSFactory.createGeocentricCRS(map, geodeticDatum, (CartesianCS)object);
                        } else {
                            if (!(object instanceof SphericalCS)) throw new FactoryException(Errors.format((int)78, object.getClass(), GeocentricCRS.class));
                            geographicCRS = cRSFactory.createGeocentricCRS(map, geodeticDatum, (SphericalCS)object);
                        }
                    } else {
                        if (!string10.equalsIgnoreCase("engineering")) throw new FactoryException(Errors.format((int)226, (Object)string10));
                        string4 = DirectEpsgFactory.getString(resultSet, 8, string);
                        string3 = DirectEpsgFactory.getString(resultSet, 9, string);
                        object = this.buffered.createCoordinateSystem(string4);
                        geodeticDatum = this.buffered.createEngineeringDatum(string3);
                        map = this.createProperties("[Coordinate Reference System]", string6, string5, string7, string8, string9, bl);
                        geographicCRS = cRSFactory.createEngineeringCRS(map, (EngineeringDatum)geodeticDatum, (CoordinateSystem)object);
                    }
                    coordinateReferenceSystem = DirectEpsgFactory.ensureSingleton(geographicCRS, coordinateReferenceSystem, string);
                    if (!resultSet.isClosed()) continue;
                    string4 = coordinateReferenceSystem;
                    return string4;
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(CoordinateReferenceSystem.class, string, sQLException);
        }
        if (coordinateReferenceSystem != null) return coordinateReferenceSystem;
        throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ParameterDescriptor<?> createParameterDescriptor(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        ParameterDescriptor parameterDescriptor = null;
        try {
            String string2 = this.toPrimaryKey(ParameterDescriptor.class, string, "[Coordinate_Operation Parameter]", "PARAMETER_CODE", "PARAMETER_NAME");
            PreparedStatement preparedStatement = this.prepareStatement("[Coordinate_Operation Parameter]", "SELECT PARAMETER_CODE, PARAMETER_NAME, DESCRIPTION, DEPRECATED FROM [Coordinate_Operation Parameter] WHERE PARAMETER_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    Class<Double> clazz;
                    Unit<?> unit;
                    Object object;
                    String string3 = DirectEpsgFactory.getString(resultSet, 1, string);
                    String string4 = DirectEpsgFactory.getString(resultSet, 2, string);
                    String string5 = resultSet.getString(3);
                    boolean bl = resultSet.getInt(4) != 0;
                    PreparedStatement preparedStatement2 = this.prepareStatement("ParameterUnit", "SELECT MIN(UOM_CODE) AS UOM, MIN(PARAM_VALUE_FILE_REF) AS FILEREF FROM [Coordinate_Operation Parameter Value] WHERE (PARAMETER_CODE = ?) GROUP BY UOM_CODE ORDER BY COUNT(UOM_CODE) DESC");
                    ResultSet resultSet2 = DirectEpsgFactory.executeQuery(preparedStatement2, string3);
                    try {
                        if (resultSet2.next()) {
                            object = resultSet2.getString(1);
                            unit = object != null ? this.buffered.createUnit((String)object) : null;
                            object = resultSet2.getString(2);
                            clazz = object != null && !((String)object).trim().isEmpty() ? String.class : Double.class;
                        } else {
                            unit = null;
                            clazz = Double.TYPE;
                        }
                    }
                    finally {
                        resultSet2.close();
                    }
                    Map<String, Object> map = this.createProperties("[Coordinate_Operation Parameter]", string4, string3, string5, bl);
                    DefaultParameterDescriptor<Object> defaultParameterDescriptor = new DefaultParameterDescriptor<Object>(map, clazz, null, null, null, null, unit, true);
                    object = defaultParameterDescriptor;
                    parameterDescriptor = DirectEpsgFactory.ensureSingleton(object, parameterDescriptor, string);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(OperationMethod.class, string, sQLException);
        }
        if (parameterDescriptor == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, string);
        }
        return parameterDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParameterDescriptor<?>[] createParameterDescriptors(String string) throws FactoryException, SQLException {
        ArrayList arrayList;
        PreparedStatement preparedStatement = this.prepareStatement("[Coordinate_Operation Parameter Usage]", "SELECT PARAMETER_CODE FROM [Coordinate_Operation Parameter Usage] WHERE COORD_OP_METHOD_CODE = ? ORDER BY SORT_ORDER");
        ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string);
        try {
            arrayList = new ArrayList();
            while (resultSet.next()) {
                String string2 = DirectEpsgFactory.getString(resultSet, 1, string);
                arrayList.add(this.buffered.createParameterDescriptor(string2));
            }
        }
        finally {
            resultSet.close();
        }
        return arrayList.toArray(new ParameterDescriptor[arrayList.size()]);
    }

    /*
     * Exception decompiling
     */
    private void fillParameterValues(String var1_1, String var2_2, ParameterValueGroup var3_3) throws FactoryException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP], 2[TRYBLOCK]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OperationMethod createOperationMethod(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        OperationMethod operationMethod = null;
        try {
            String string2 = this.toPrimaryKey(OperationMethod.class, string, "[Coordinate_Operation Method]", "COORD_OP_METHOD_CODE", "COORD_OP_METHOD_NAME");
            PreparedStatement preparedStatement = this.prepareStatement("[Coordinate_Operation Method]", "SELECT COORD_OP_METHOD_CODE, COORD_OP_METHOD_NAME, FORMULA, REMARKS, DEPRECATED FROM [Coordinate_Operation Method] WHERE COORD_OP_METHOD_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    String string3 = DirectEpsgFactory.getString(resultSet, 1, string);
                    String string4 = DirectEpsgFactory.getString(resultSet, 2, string);
                    String string5 = resultSet.getString(3);
                    String string6 = resultSet.getString(4);
                    boolean bl = resultSet.getInt(5) != 0;
                    Integer[] integerArray = this.getDimensionsForMethod(string3);
                    ParameterDescriptor<?>[] parameterDescriptorArray = this.createParameterDescriptors(string3);
                    Map<String, Object> map = this.createProperties("[Coordinate_Operation Method]", string4, string3, string6, bl);
                    if (string5 != null) {
                        map.put("formula", string5);
                    }
                    DefaultOperationMethod defaultOperationMethod = new DefaultOperationMethod(map, integerArray[0], integerArray[1], new DefaultParameterDescriptorGroup((Map<String, ?>)map, (GeneralParameterDescriptor[])parameterDescriptorArray));
                    operationMethod = DirectEpsgFactory.ensureSingleton(defaultOperationMethod, operationMethod, string);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(OperationMethod.class, string, sQLException);
        }
        if (operationMethod == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, string);
        }
        return operationMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer[] getDimensionsForMethod(String string) throws NoSuchIdentifierException, SQLException {
        Integer[] integerArray = new Integer[2];
        boolean[] blArray = new boolean[2];
        int n = 0;
        boolean bl = false;
        block4: do {
            String string2;
            String string3;
            if (!bl) {
                string3 = "MethodDimensions";
                string2 = "SELECT DISTINCT SRC.COORD_SYS_CODE, TGT.COORD_SYS_CODE FROM [Coordinate_Operation] AS CO INNER JOIN [Coordinate Reference System] AS SRC ON SRC.COORD_REF_SYS_CODE = CO.SOURCE_CRS_CODE INNER JOIN [Coordinate Reference System] AS TGT ON TGT.COORD_REF_SYS_CODE = CO.TARGET_CRS_CODE WHERE CO.DEPRECATED = 0 AND COORD_OP_METHOD_CODE = ?";
            } else {
                string3 = "DerivedDimensions";
                string2 = "SELECT DISTINCT SRC.COORD_SYS_CODE, TGT.COORD_SYS_CODE FROM [Coordinate Reference System] AS TGT INNER JOIN [Coordinate Reference System] AS SRC ON TGT.SOURCE_GEOGCRS_CODE = SRC.COORD_REF_SYS_CODE INNER JOIN [Coordinate_Operation] AS CO ON TGT.PROJECTION_CONV_CODE = CO.COORD_OP_CODE WHERE CO.DEPRECATED = 0 AND COORD_OP_METHOD_CODE = ?";
            }
            PreparedStatement preparedStatement = this.prepareStatement(string3, string2);
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string);
            block5: while (true) {
                if (!resultSet.next()) continue block4;
                int n2 = 0;
                while (true) {
                    Integer n3;
                    if (n2 >= integerArray.length) continue block5;
                    if (!blArray[n2] && (n3 = this.getDimensionForCS(resultSet.getString(n2 + 1))) != null) {
                        if (integerArray[n2] == null) {
                            integerArray[n2] = n3;
                        } else if (!n3.equals(integerArray[n2])) {
                            integerArray[n2] = null;
                            blArray[n2] = true;
                            if (++n == blArray.length) {
                                Integer[] integerArray2 = integerArray;
                                return integerArray2;
                            }
                        }
                    }
                    ++n2;
                }
                break;
            }
            finally {
                resultSet.close();
            }
        } while (bl = !bl);
        return integerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getDimensionForCS(String string) throws NoSuchIdentifierException, SQLException {
        Integer n;
        if (this.axisCounts == null) {
            this.axisCounts = new HashMap<String, Integer>();
        }
        if ((n = this.axisCounts.get(string)) == null) {
            PreparedStatement preparedStatement = this.prepareStatement("Dimension", " SELECT COUNT(COORD_AXIS_CODE) FROM [Coordinate Axis] WHERE COORD_SYS_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string);
            try {
                n = resultSet.next() ? resultSet.getInt(1) : 0;
                this.axisCounts.put(string, n);
            }
            finally {
                resultSet.close();
            }
        }
        return n != 0 ? n : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isProjection(String string) throws NoSuchIdentifierException, SQLException {
        Boolean bl;
        if (this.codeProjection == null) {
            this.codeProjection = new HashMap<String, Boolean>();
        }
        if ((bl = this.codeProjection.get(string)) == null) {
            boolean bl2;
            PreparedStatement preparedStatement = this.prepareStatement("isProjection", "SELECT COORD_REF_SYS_CODE FROM [Coordinate Reference System] WHERE PROJECTION_CONV_CODE = ? AND COORD_REF_SYS_KIND LIKE 'projected%'");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string);
            try {
                bl2 = resultSet.next();
            }
            finally {
                resultSet.close();
            }
            bl = bl2;
            this.codeProjection.put(string, bl);
        }
        return bl;
    }

    private PositionalAccuracy getAccuracy(double d) {
        Double d2;
        PositionalAccuracy positionalAccuracy;
        if (this.accuracies == null) {
            this.accuracies = new HashMap<Double, PositionalAccuracy>();
        }
        if ((positionalAccuracy = this.accuracies.get(d2 = Double.valueOf(d))) == null) {
            DefaultQuantitativeResult defaultQuantitativeResult = new DefaultQuantitativeResult(new double[]{d});
            defaultQuantitativeResult.setValueUnit((Unit)SI.METRE);
            DefaultAbsoluteExternalPositionalAccuracy defaultAbsoluteExternalPositionalAccuracy = new DefaultAbsoluteExternalPositionalAccuracy((Result)defaultQuantitativeResult);
            defaultAbsoluteExternalPositionalAccuracy.setMeasureDescription(TRANSFORMATION_ACCURACY);
            defaultAbsoluteExternalPositionalAccuracy.setEvaluationMethodType(EvaluationMethodType.DIRECT_EXTERNAL);
            defaultAbsoluteExternalPositionalAccuracy.freeze();
            positionalAccuracy = defaultAbsoluteExternalPositionalAccuracy;
            this.accuracies.put(d2, positionalAccuracy);
        }
        return positionalAccuracy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized CoordinateOperation createCoordinateOperation(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DirectEpsgFactory.ensureNonNull("code", string);
        CoordinateOperation coordinateOperation = null;
        try {
            String string2 = this.toPrimaryKey(CoordinateOperation.class, string, "[Coordinate_Operation]", "COORD_OP_CODE", "COORD_OP_NAME");
            PreparedStatement preparedStatement = this.prepareStatement("[Coordinate_Operation]", "SELECT COORD_OP_CODE, COORD_OP_NAME, COORD_OP_TYPE, SOURCE_CRS_CODE, TARGET_CRS_CODE, COORD_OP_METHOD_CODE, COORD_TFM_VERSION, COORD_OP_ACCURACY, AREA_OF_USE_CODE, COORD_OP_SCOPE, REMARKS, DEPRECATED FROM [Coordinate_Operation] WHERE COORD_OP_CODE = ?");
            ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string2);
            try {
                while (resultSet.next()) {
                    ResultSet resultSet2;
                    Object object;
                    Object object2;
                    Object object3;
                    ParameterValueGroup parameterValueGroup;
                    OperationMethod operationMethod;
                    boolean bl;
                    Integer n;
                    CoordinateReferenceSystem coordinateReferenceSystem;
                    Integer n2;
                    CoordinateReferenceSystem coordinateReferenceSystem2;
                    boolean bl2;
                    String string3;
                    String string4;
                    String string5 = DirectEpsgFactory.getString(resultSet, 1, string);
                    String string6 = DirectEpsgFactory.getString(resultSet, 2, string);
                    String string7 = DirectEpsgFactory.getString(resultSet, 3, string).trim().toLowerCase(Locale.US);
                    boolean bl3 = string7.equals("transformation");
                    boolean bl4 = string7.equals("conversion");
                    boolean bl5 = string7.equals("concatenated operation");
                    if (bl4) {
                        string4 = resultSet.getString(4);
                        string3 = resultSet.getString(5);
                    } else {
                        string4 = DirectEpsgFactory.getString(resultSet, 4, string);
                        string3 = DirectEpsgFactory.getString(resultSet, 5, string);
                    }
                    String string8 = bl5 ? resultSet.getString(6) : DirectEpsgFactory.getString(resultSet, 6, string);
                    String string9 = resultSet.getString(7);
                    double d = resultSet.getDouble(8);
                    if (resultSet.wasNull()) {
                        d = Double.NaN;
                    }
                    String string10 = resultSet.getString(9);
                    String string11 = resultSet.getString(10);
                    String string12 = resultSet.getString(11);
                    boolean bl6 = bl2 = resultSet.getInt(12) != 0;
                    if (string4 != null) {
                        coordinateReferenceSystem2 = this.buffered.createCoordinateReferenceSystem(string4);
                        n2 = coordinateReferenceSystem2.getCoordinateSystem().getDimension();
                    } else {
                        coordinateReferenceSystem2 = null;
                        n2 = 2;
                    }
                    if (string3 != null) {
                        coordinateReferenceSystem = this.buffered.createCoordinateReferenceSystem(string3);
                        n = coordinateReferenceSystem.getCoordinateSystem().getDimension();
                    } else {
                        coordinateReferenceSystem = null;
                        n = 2;
                    }
                    if (string8 == null) {
                        bl = false;
                        operationMethod = null;
                        parameterValueGroup = null;
                    } else {
                        int n3;
                        try {
                            n3 = Integer.parseInt(string8);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new FactoryException((Throwable)numberFormatException);
                        }
                        bl = n3 >= 9603 && n3 <= 9607;
                        operationMethod = this.buffered.createOperationMethod(string8);
                        if (!Utilities.equals((Object)operationMethod.getSourceDimensions(), (Object)n2) || !Utilities.equals((Object)operationMethod.getTargetDimensions(), (Object)n)) {
                            operationMethod = new DefaultOperationMethod(operationMethod, n2, n);
                        }
                        object2 = object3 = operationMethod.getName().getCode();
                        object = IdentifiedObjects.toString((Identifier)IdentifiedObjects.getIdentifier((IdentifiedObject)operationMethod, (Citation)Citations.EPSG));
                        if (object != null) {
                            object2 = object;
                        }
                        resultSet2 = this.factories.getMathTransformFactory();
                        try {
                            parameterValueGroup = resultSet2.getDefaultParameters((String)object2);
                        }
                        catch (NoSuchIdentifierException noSuchIdentifierException) {
                            if (((String)object2).equals(object3)) {
                                throw noSuchIdentifierException;
                            }
                            parameterValueGroup = resultSet2.getDefaultParameters((String)object3);
                            Logging.recoverableException((Logger)LOGGER, DirectEpsgFactory.class, (String)"createCoordinateOperation", (Throwable)noSuchIdentifierException);
                        }
                        this.fillParameterValues(string8, string5, parameterValueGroup);
                    }
                    Map<String, Object> map = this.createProperties("[Coordinate_Operation]", string6, string5, string10, string11, string12, bl2);
                    if (string9 != null && !(string9 = string9.trim()).isEmpty()) {
                        map.put("operationVersion", string9);
                    }
                    if (!Double.isNaN(d)) {
                        map.put("coordinateOperationAccuracy", this.getAccuracy(d));
                    }
                    if (bl4 && (coordinateReferenceSystem2 == null || coordinateReferenceSystem == null)) {
                        object3 = new DefiningConversion(map, operationMethod, parameterValueGroup);
                    } else {
                        if (bl5) {
                            resultSet.close();
                            object2 = this.prepareStatement("[Coordinate_Operation Path]", "SELECT SINGLE_OPERATION_CODE FROM [Coordinate_Operation Path] WHERE (CONCAT_OPERATION_CODE = ?) ORDER BY OP_PATH_STEP");
                            resultSet2 = DirectEpsgFactory.executeQuery(object2, string5);
                            try {
                                object = new ArrayList();
                                while (resultSet2.next()) {
                                    object.add(resultSet2.getString(1));
                                }
                            }
                            finally {
                                resultSet2.close();
                            }
                            CoordinateOperation[] coordinateOperationArray = new CoordinateOperation[object.size()];
                            if (!this.safetyGuard.add(string5)) {
                                throw DirectEpsgFactory.recursiveCall(ConcatenatedOperation.class, string5);
                            }
                            try {
                                for (int i = 0; i < coordinateOperationArray.length; ++i) {
                                    coordinateOperationArray[i] = this.buffered.createCoordinateOperation((String)object.get(i));
                                }
                            }
                            finally {
                                this.safetyGuard.remove(string5);
                            }
                            try {
                                DefaultConcatenatedOperation defaultConcatenatedOperation = new DefaultConcatenatedOperation(map, coordinateOperationArray);
                                return defaultConcatenatedOperation;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw new FactoryException((Throwable)illegalArgumentException);
                            }
                        }
                        if (bl) {
                            try {
                                object2 = CRSUtilities.getHeadGeoEllipsoid(coordinateReferenceSystem2);
                                if (object2 != null) {
                                    object = object2.getAxisUnit();
                                    parameterValueGroup.parameter("src_semi_major").setValue(object2.getSemiMajorAxis(), (Unit)object);
                                    parameterValueGroup.parameter("src_semi_minor").setValue(object2.getSemiMinorAxis(), (Unit)object);
                                    parameterValueGroup.parameter("src_dim").setValue(coordinateReferenceSystem2.getCoordinateSystem().getDimension());
                                }
                                if ((object2 = CRSUtilities.getHeadGeoEllipsoid(coordinateReferenceSystem)) != null) {
                                    object = object2.getAxisUnit();
                                    parameterValueGroup.parameter("tgt_semi_major").setValue(object2.getSemiMajorAxis(), (Unit)object);
                                    parameterValueGroup.parameter("tgt_semi_minor").setValue(object2.getSemiMinorAxis(), (Unit)object);
                                    parameterValueGroup.parameter("tgt_dim").setValue(coordinateReferenceSystem.getCoordinateSystem().getDimension());
                                }
                                map.put("parameters", parameterValueGroup);
                            }
                            catch (ParameterNotFoundException parameterNotFoundException) {
                                throw new FactoryException(Errors.format((int)67, (Object)operationMethod.getName().getCode(), (Object)((Object)parameterNotFoundException)));
                            }
                        }
                        if (bl3) {
                            object2 = Transformation.class;
                        } else {
                            if (!bl4) throw new FactoryException(Errors.format((int)226, (Object)string7));
                            object2 = Conversion.class;
                        }
                        object = this.factories.getMathTransformFactory().createBaseToDerived(coordinateReferenceSystem2, parameterValueGroup, coordinateReferenceSystem.getCoordinateSystem());
                        object3 = DefaultSingleOperation.create(map, coordinateReferenceSystem2, coordinateReferenceSystem, (MathTransform)object, operationMethod, (Class<? extends CoordinateOperation>)object2);
                    }
                    coordinateOperation = DirectEpsgFactory.ensureSingleton(object3, coordinateOperation, string);
                    if (!resultSet.isClosed()) continue;
                    object2 = coordinateOperation;
                    return object2;
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(CoordinateOperation.class, string, sQLException);
        }
        if (coordinateOperation != null) return coordinateOperation;
        throw this.noSuchAuthorityCode(CoordinateOperation.class, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("sourceCode", string);
        DirectEpsgFactory.ensureNonNull("targetCode", string2);
        String string3 = string + " \u21e8 " + string2;
        CoordinateOperationSet coordinateOperationSet = new CoordinateOperationSet(this.buffered);
        try {
            Object[] objectArray;
            String string4 = this.toPrimaryKeyCRS(string);
            String string5 = this.toPrimaryKeyCRS(string2);
            boolean bl = false;
            do {
                String string6;
                if (bl) {
                    objectArray = "TransformationFromCRS";
                    string6 = "SELECT COORD_OP_CODE FROM [Coordinate_Operation] AS CO JOIN [Area] ON AREA_OF_USE_CODE = AREA_CODE WHERE SOURCE_CRS_CODE = ? AND TARGET_CRS_CODE = ? ORDER BY ABS(CO.DEPRECATED), COORD_OP_ACCURACY,  ABS((AREA_EAST_BOUND_LON - AREA_WEST_BOUND_LON) * (AREA_NORTH_BOUND_LAT - AREA_SOUTH_BOUND_LAT) * COS(0.5*RADIANS(AREA_NORTH_BOUND_LAT + AREA_SOUTH_BOUND_LAT))) DESC";
                } else {
                    objectArray = "ConversionFromCRS";
                    string6 = "SELECT PROJECTION_CONV_CODE FROM [Coordinate Reference System] WHERE SOURCE_GEOGCRS_CODE = ? AND COORD_REF_SYS_CODE = ?";
                }
                PreparedStatement preparedStatement = this.prepareStatement((String)objectArray, string6);
                ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string4, string5);
                try {
                    while (resultSet.next()) {
                        String string7 = DirectEpsgFactory.getString(resultSet, 1, string3);
                        coordinateOperationSet.addAuthorityCode(string7, bl ? null : string5);
                    }
                }
                finally {
                    resultSet.close();
                }
            } while (bl = !bl);
            objectArray = coordinateOperationSet.getAuthorityCodes();
            this.sort(objectArray);
            coordinateOperationSet.setAuthorityCodes((String[])objectArray);
        }
        catch (SQLException sQLException) {
            throw DirectEpsgFactory.databaseFailure(CoordinateOperation.class, string3, sQLException);
        }
        coordinateOperationSet.resolve(1);
        return coordinateOperationSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort(Object[] objectArray) throws SQLException, FactoryException {
        if (objectArray.length <= 1) {
            return;
        }
        PreparedStatement preparedStatement = this.prepareStatement("[Supersession]", "SELECT SUPERSEDED_BY FROM [Supersession] WHERE OBJECT_CODE = ? ORDER BY SUPERSESSION_YEAR DESC");
        int n = 15;
        do {
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].toString();
                ResultSet resultSet = DirectEpsgFactory.executeQuery(preparedStatement, string);
                try {
                    while (resultSet.next()) {
                        String string2 = DirectEpsgFactory.getString(resultSet, 1, string);
                        for (int j = i + 1; j < objectArray.length; ++j) {
                            Object object = objectArray[j];
                            if (!string2.equals(object.toString())) continue;
                            System.arraycopy(objectArray, i, objectArray, i + 1, j - i);
                            objectArray[i++] = object;
                            bl = true;
                        }
                    }
                    continue;
                }
                finally {
                    resultSet.close();
                }
            }
            if (bl) continue;
            return;
        } while (--n != 0);
        LOGGER.finer("Possible recursivity in supersessions.");
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new Finder(this.buffered, clazz);
    }

    private static FactoryException recursiveCall(Class<?> clazz, String string) {
        return new FactoryException(Errors.format((int)194, clazz, (Object)string));
    }

    private static FactoryException databaseFailure(Class<?> clazz, String string, SQLException sQLException) {
        return new FactoryException(Errors.format((int)46, clazz, (Object)string), (Throwable)sQLException);
    }

    protected String adaptSQL(String string) {
        return string;
    }

    protected boolean isPrimaryKey(String string) throws FactoryException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || Character.isSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    final synchronized boolean canDispose() {
        boolean bl = true;
        if (this.authorityCodes != null) {
            System.gc();
            Iterator<Reference<AuthorityCodes>> iterator = this.authorityCodes.values().iterator();
            while (iterator.hasNext()) {
                AuthorityCodes authorityCodes = iterator.next().get();
                if (authorityCodes == null) {
                    iterator.remove();
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    protected synchronized void dispose(boolean bl) {
        Object object;
        boolean bl2;
        try {
            bl2 = this.connection.isClosed();
            if (this.authorityCodes != null) {
                object = this.authorityCodes.values().iterator();
                while (object.hasNext()) {
                    AuthorityCodes authorityCodes = (AuthorityCodes)((Reference)object.next()).get();
                    if (authorityCodes != null) {
                        authorityCodes.finalize();
                    }
                    object.remove();
                }
            }
            object = this.statements.values().iterator();
            while (object.hasNext()) {
                ((PreparedStatement)object.next()).close();
                object.remove();
            }
            this.connection.close();
            super.dispose(bl);
        }
        catch (SQLException sQLException) {
            if (!bl) {
                Logging.unexpectedException((Logger)LOGGER, DirectEpsgFactory.class, (String)"dispose", (Throwable)sQLException);
            }
            return;
        }
        if (!bl2 && !bl) {
            object = Loggings.format((Level)Level.FINE, (int)15);
            ((LogRecord)object).setLoggerName(LOGGER.getName());
            LOGGER.log((LogRecord)object);
        }
    }

    protected final void finalize() {
        this.dispose(false);
    }

    private final class Finder
    extends IdentifiedObjectFinder {
        Finder(AbstractAuthorityFactory abstractAuthorityFactory, Class<? extends IdentifiedObject> clazz) {
            super(abstractAuthorityFactory, clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Set<String> getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
            Object object;
            Object object2;
            String string;
            String string2 = "COORD_REF_SYS_CODE";
            String string3 = "[Coordinate Reference System]";
            if (identifiedObject instanceof Ellipsoid) {
                string2 = "ELLIPSOID_CODE";
                string3 = "[Ellipsoid]";
                string = "SEMI_MAJOR_AXIS";
                object2 = ((Ellipsoid)identifiedObject).getSemiMajorAxis();
            } else {
                if (identifiedObject instanceof GeneralDerivedCRS) {
                    object = ((GeneralDerivedCRS)identifiedObject).getBaseCRS();
                    string = "SOURCE_GEOGCRS_CODE";
                } else if (identifiedObject instanceof SingleCRS) {
                    object = ((SingleCRS)identifiedObject).getDatum();
                    string = "DATUM_CODE";
                } else if (identifiedObject instanceof GeodeticDatum) {
                    object = ((GeodeticDatum)identifiedObject).getEllipsoid();
                    string2 = "DATUM_CODE";
                    string3 = "[Datum]";
                    string = "ELLIPSOID_CODE";
                } else {
                    return super.getCodeCandidates(identifiedObject);
                }
                object = this.findFromParent((IdentifiedObject)object, object.getClass());
                if (object == null) {
                    return Collections.emptySet();
                }
                ReferenceIdentifier referenceIdentifier = IdentifiedObjects.getIdentifier((IdentifiedObject)object, this.getAuthority());
                if (referenceIdentifier == null || (object2 = referenceIdentifier.getCode()) == null) {
                    return super.getCodeCandidates(identifiedObject);
                }
            }
            object = new StringBuilder(60);
            ((StringBuilder)object).append("SELECT ").append(string2).append(" FROM ").append(string3).append(" WHERE ").append(string);
            if (object2 instanceof Number) {
                double d = ((Number)object2).doubleValue();
                double d2 = Math.abs(d * 1.0E-14);
                ((StringBuilder)object).append(">=").append(d - d2).append(" AND ").append(string).append("<=").append(d + d2);
            } else {
                ((StringBuilder)object).append('=').append(object2);
            }
            ((StringBuilder)object).append(" ORDER BY ABS(DEPRECATED), ");
            if (object2 instanceof Number) {
                ((StringBuilder)object).append("ABS(").append(string2).append('-').append(object2).append(')');
            } else {
                ((StringBuilder)object).append(string2);
            }
            String string4 = DirectEpsgFactory.this.adaptSQL(((StringBuilder)object).toString());
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            try {
                Statement statement = DirectEpsgFactory.this.connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string4);
                try {
                    while (resultSet.next()) {
                        linkedHashSet.add(resultSet.getString(1));
                    }
                }
                finally {
                    resultSet.close();
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                throw DirectEpsgFactory.databaseFailure(Identifier.class, String.valueOf(object2), sQLException);
            }
            return linkedHashSet;
        }
    }
}

