/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotoolkit.internal.sql.CreateStatementType;
import org.geotoolkit.internal.sql.Dialect;
import org.geotoolkit.internal.sql.ScriptRunner;
import org.geotoolkit.referencing.factory.epsg.AnsiDialectEpsgFactory;
import org.geotoolkit.util.Strings;

final class EpsgScriptRunner
extends ScriptRunner {
    private static final String[] SCRIPTS = new String[]{"Tables", "Data", "Extensions", "FKeys", "Indexes", "Grant"};
    static final String REPLACE_STATEMENT = "\\s*UPDATE\\s+[\\w\\.\" ]+\\s+SET\\s+(\\w+)\\s*=\\s*replace\\s*\\(\\s*\\1\\W+.*";
    private final boolean supportsCommitStatement;
    private final boolean supportsSchemas;
    private final boolean supportsGrantOnSchemas;
    private final boolean supportsGrantOnTables;
    private final int maxRowsPerInsert;
    private final boolean replacePilcrow;
    private final Matcher skip;

    public EpsgScriptRunner(Connection connection) throws SQLException {
        super(connection);
        this.setEncoding("ISO-8859-1");
        for (String object2 : SCRIPTS) {
            this.suffixes.add(object2);
        }
        boolean bl = false;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getStringFunctions();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!string2.equalsIgnoreCase("REPLACE")) continue;
            bl = true;
            break;
        }
        this.skip = bl ? null : Pattern.compile(REPLACE_STATEMENT, 2).matcher("");
        this.replacePilcrow = false;
        this.supportsGrantOnTables = this.dialect.supportsGrantStatement(databaseMetaData, CreateStatementType.TABLE);
        this.supportsGrantOnSchemas = this.dialect.supportsGrantStatement(databaseMetaData, CreateStatementType.SCHEMA);
        this.supportsCommitStatement = this.dialect.supportsCommitStatement(databaseMetaData);
        this.maxRowsPerInsert = this.dialect.maxRowsPerInsert(databaseMetaData);
        if (this.dialect == Dialect.HSQL) {
            this.replacements.put("CREATE TABLE", "CREATE CACHED TABLE");
            this.replacements.put("UNIQUE", "");
            this.replacements.put("CHR", "CHAR");
        }
        this.supportsSchemas = databaseMetaData.supportsSchemasInTableDefinitions() && databaseMetaData.supportsSchemasInDataManipulation();
    }

    final String[] getScriptFiles() {
        if (this.supportsGrantOnTables) {
            return SCRIPTS;
        }
        return Arrays.copyOf(SCRIPTS, SCRIPTS.length - 1);
    }

    public boolean accept(File file, String string) {
        return super.accept(file, string) && string.startsWith("EPSG");
    }

    public void setSchema(String string) throws SQLException, IOException {
        if (!this.supportsSchemas) {
            return;
        }
        this.execute(new StringBuilder("CREATE SCHEMA ").append(string));
        if (this.supportsGrantOnSchemas) {
            this.execute(new StringBuilder("GRANT USAGE ON SCHEMA ").append(string).append(" TO PUBLIC"));
        }
        StringBuilder stringBuilder = new StringBuilder(string).append('.').append(this.identifierQuote);
        int n = stringBuilder.length();
        String[] stringArray = AnsiDialectEpsgFactory.ACCESS_TO_ANSI;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2;
            String string3 = stringArray[n2++];
            if (!(string2 = stringArray[n2++]).startsWith("epsg_")) continue;
            stringBuilder.setLength(n);
            assert (string3.charAt(0) == '[' && string3.charAt(string3.length() - 1) == ']') : string3;
            String string4 = stringBuilder.append(string3, 1, string3.length() - 1).append(this.identifierQuote).toString();
            if (this.replacements.put(string2, string4) != null) {
                throw new AssertionError((Object)string2);
            }
        }
    }

    protected int execute(StringBuilder stringBuilder) throws SQLException, IOException {
        int n;
        if (!this.supportsCommitStatement && Strings.equalsIgnoreCase((CharSequence)"COMMIT", (CharSequence)stringBuilder)) {
            return 0;
        }
        if (this.skip != null && this.skip.reset(stringBuilder).matches()) {
            return 0;
        }
        if (this.replacePilcrow) {
            Strings.replace((StringBuilder)stringBuilder, (String)"\u00b6", (String)"\n");
        }
        if (this.maxRowsPerInsert != 0 && Strings.startsWith((CharSequence)stringBuilder, (CharSequence)"INSERT INTO", (boolean)true) && (n = stringBuilder.indexOf("\n")) >= 0 && Strings.regionMatches((CharSequence)stringBuilder, (int)(n - 6), (CharSequence)"VALUES")) {
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.substring(0, n)).append(' ');
            int n2 = stringBuilder2.length();
            int n3 = n + 1;
            int n4 = 0;
            int n5 = this.maxRowsPerInsert;
            while (true) {
                ++n;
                if ((n = stringBuilder.indexOf("\n", n)) < 0) break;
                if (--n5 != 0 || n == n3) continue;
                int n6 = n;
                if (stringBuilder.charAt(n6 - 1) == ',') {
                    --n6;
                }
                n4 += super.execute(stringBuilder2.append(stringBuilder.substring(n3, n6)));
                stringBuilder2.setLength(n2);
                n5 = this.maxRowsPerInsert;
                n3 = n + 1;
            }
            return n4 += super.execute(stringBuilder2.append(stringBuilder.substring(n3)));
        }
        return super.execute(stringBuilder);
    }
}

