/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.wkt;

import java.awt.RenderingHints;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.io.wkt.ReferencingParser;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.io.wkt.WKTFormat;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.factory.DirectAuthorityFactory;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.collection.BackingStoreException;
import org.geotoolkit.util.collection.DerivedSet;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.ScopedName;

@ThreadSafe
public class WKTParsingAuthorityFactory
extends DirectAuthorityFactory {
    Citation authority;
    Citation[] authorities;
    final Map<String, String> definitions;
    private transient Set<String> codes;
    private transient Map<Class<? extends IdentifiedObject>, Set<String>> filteredCodes;
    private transient Parser parser;

    public WKTParsingAuthorityFactory(Hints hints, Map<String, String> map, Citation ... citationArray) {
        this(hints, map);
        WKTParsingAuthorityFactory.ensureNonNull("authorities", citationArray);
        if (citationArray.length == 0) {
            throw new IllegalArgumentException(Errors.format((int)58));
        }
        citationArray = (Citation[])citationArray.clone();
        this.authorities = citationArray;
        for (Citation citation : citationArray) {
            WKTParsingAuthorityFactory.ensureNonNull("authority", citation);
        }
    }

    WKTParsingAuthorityFactory(Hints hints, Map<String, String> map) {
        super(hints);
        WKTParsingAuthorityFactory.ensureNonNull("definitions", map);
        this.definitions = map;
        WKTParsingAuthorityFactory.copyRelevantHints(hints, this.hints);
    }

    static void copyRelevantHints(Hints hints, Map<RenderingHints.Key, Object> map) {
        Boolean bl = Boolean.FALSE;
        if (hints != null && (bl = (Boolean)hints.get((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER)) == null && (bl = (Boolean)hints.get((Object)Hints.FORCE_STANDARD_AXIS_DIRECTIONS)) == null) {
            bl = Boolean.FALSE;
        }
        map.put((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, bl);
        map.put((RenderingHints.Key)Hints.FORCE_STANDARD_AXIS_DIRECTIONS, bl);
        map.put((RenderingHints.Key)Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
    }

    public ConformanceResult availability() {
        return new Factory.Availability(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean pass() {
                WKTParsingAuthorityFactory wKTParsingAuthorityFactory = WKTParsingAuthorityFactory.this;
                synchronized (wKTParsingAuthorityFactory) {
                    return Boolean.TRUE.equals(super.pass()) && !WKTParsingAuthorityFactory.this.definitions.isEmpty();
                }
            }
        };
    }

    Citation[] getAuthorities() {
        if (this.authorities == null) {
            throw new IllegalStateException(Errors.format((int)51));
        }
        return this.authorities;
    }

    @Override
    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            Object[] objectArray = this.getAuthorities();
            Citation citation = this.getPrimaryKeyAuthority();
            if (citation != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!citation.equals(objectArray[i])) continue;
                    objectArray = (Citation[])XArrays.remove((Object[])objectArray, (int)i, (int)1);
                    break;
                }
            }
            switch (objectArray.length) {
                case 0: {
                    this.authority = Citations.UNKNOWN;
                    break;
                }
                case 1: {
                    this.authority = objectArray[0];
                    break;
                }
                default: {
                    DefaultCitation defaultCitation = new DefaultCitation(objectArray[0]);
                    Collection collection = defaultCitation.getIdentifiers();
                    for (int i = 1; i < objectArray.length; ++i) {
                        collection.addAll(objectArray[i].getIdentifiers());
                    }
                    defaultCitation.freeze();
                    this.authority = defaultCitation;
                    break;
                }
            }
        }
        return this.authority;
    }

    Citation getPrimaryKeyAuthority() {
        return null;
    }

    public synchronized Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        Object object;
        if (this.codes == null) {
            this.codes = Collections.unmodifiableSet(this.definitions.keySet());
        }
        if (clazz == null || clazz.isAssignableFrom(IdentifiedObject.class)) {
            return this.codes;
        }
        if (this.filteredCodes == null) {
            this.filteredCodes = new HashMap<Class<? extends IdentifiedObject>, Set<String>>();
        }
        if ((object = this.filteredCodes.get(clazz)) == null) {
            object = new Codes(clazz);
            this.filteredCodes.put(clazz, (Set<String>)object);
        }
        return object;
    }

    private String getWKT(Class<? extends IdentifiedObject> clazz, String string, Parser parser) throws FactoryException {
        String string2;
        Comparable<?> comparable;
        assert (Thread.holdsLock((Object)this));
        WKTParsingAuthorityFactory.ensureNonNull("code", string);
        try {
            comparable = this.getPrimaryKey(clazz, string);
            string2 = this.definitions.get(comparable);
        }
        catch (BackingStoreException backingStoreException) {
            Throwable throwable = backingStoreException.getCause();
            if (throwable instanceof FactoryException) {
                throw (FactoryException)throwable;
            }
            throw WKTParsingAuthorityFactory.databaseFailure(clazz, string, throwable);
        }
        if (string2 == null) {
            throw this.noSuchAuthorityCode(clazz, string);
        }
        if (parser != null) {
            parser.code = string;
            parser.primaryKey = comparable;
        }
        return string2.trim();
    }

    static FactoryException databaseFailure(Class<?> clazz, String string, Throwable throwable) {
        String string2 = throwable.getLocalizedMessage();
        if (string != null) {
            String string3 = clazz != null ? clazz.getSimpleName() : Vocabulary.format((int)309);
            string2 = Errors.format((int)46, (Object)string3, (Object)string) + ": " + string2;
        }
        return new FactoryException(string2, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternationalString getDescriptionText(String string) throws NoSuchAuthorityCodeException, FactoryException {
        int n;
        String string2;
        WKTParsingAuthorityFactory wKTParsingAuthorityFactory = this;
        synchronized (wKTParsingAuthorityFactory) {
            string2 = this.getWKT(IdentifiedObject.class, string, null);
        }
        int n2 = string2.indexOf(34);
        if (n2 >= 0 && (n = string2.indexOf(34, ++n2)) >= 0) {
            return new SimpleInternationalString(string2.substring(n2, n).trim());
        }
        return null;
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.parser = new Parser();
            this.parser.setAxisIgnored(Boolean.TRUE.equals(this.hints.get(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER)));
        }
        return this.parser;
    }

    @Override
    public synchronized IdentifiedObject createObject(String string) throws NoSuchAuthorityCodeException, FactoryException {
        Parser parser = this.getParser();
        String string2 = this.getWKT(IdentifiedObject.class, string, parser);
        try {
            return (IdentifiedObject)parser.parseObject(string2);
        }
        catch (ParseException parseException) {
            throw new FactoryException((Throwable)parseException);
        }
    }

    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws NoSuchAuthorityCodeException, FactoryException {
        Parser parser = this.getParser();
        String string2 = this.getWKT(CoordinateReferenceSystem.class, string, parser);
        try {
            return parser.parseCoordinateReferenceSystem(string2);
        }
        catch (ParseException parseException) {
            throw new FactoryException((Throwable)parseException);
        }
    }

    @Override
    protected String trimAuthority(String string) {
        GenericName genericName = this.nameFactory.parseGenericName(null, (CharSequence)(string = string.trim()));
        if (genericName instanceof ScopedName) {
            GenericName genericName2 = ((ScopedName)genericName).path();
            String string2 = genericName2.toString();
            Citation[] citationArray = this.getAuthorities();
            for (int i = 0; i < citationArray.length; ++i) {
                if (!Citations.identifierMatches((Citation)citationArray[i], (String)string2)) continue;
                return genericName.tip().toString().trim();
            }
        }
        return string;
    }

    Comparable<?> getPrimaryKey(Class<? extends IdentifiedObject> clazz, String string) throws FactoryException {
        return this.trimAuthority(string);
    }

    @Override
    public synchronized IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        Parser parser = this.getParser();
        if (!parser.isAxisIgnored()) {
            return super.getIdentifiedObjectFinder(clazz);
        }
        return new Finder(clazz);
    }

    @Override
    protected synchronized void dispose(boolean bl) {
        this.authority = null;
        this.authorities = null;
        this.codes = null;
        this.filteredCodes = null;
        this.parser = null;
        super.dispose(bl);
    }

    private final class Parser
    extends ReferencingParser {
        private static final long serialVersionUID = -5910561042299146066L;
        String code;
        Comparable<?> primaryKey;

        public Parser() {
            super(Symbols.DEFAULT, WKTParsingAuthorityFactory.this.factories);
            this.setISOConform(true);
        }

        @Override
        protected Map<String, Object> alterProperties(Map<String, Object> map) {
            NamedIdentifier[] namedIdentifierArray;
            Citation[] citationArray;
            Citation citation = WKTParsingAuthorityFactory.this.getPrimaryKeyAuthority();
            ReferenceIdentifier referenceIdentifier = (ReferenceIdentifier)map.get("identifiers");
            if (referenceIdentifier == null) {
                citationArray = WKTParsingAuthorityFactory.this.getAuthorities();
                namedIdentifierArray = new NamedIdentifier[citationArray.length];
            } else if (citation != null) {
                citationArray = new Citation[]{citation};
                namedIdentifierArray = new ReferenceIdentifier[2];
                namedIdentifierArray[0] = referenceIdentifier;
            } else {
                citationArray = null;
                namedIdentifierArray = null;
            }
            if (citationArray != null) {
                String string = null;
                String string2 = null;
                int n = namedIdentifierArray.length - citationArray.length;
                for (int i = 0; i < citationArray.length; ++i) {
                    String string3;
                    Citation citation2 = citationArray[i];
                    if (citation == null || citation.equals(citation2)) {
                        if (string2 == null) {
                            string2 = this.primaryKey.toString();
                        }
                        string3 = string2;
                    } else {
                        if (string == null) {
                            string = WKTParsingAuthorityFactory.this.trimAuthority(this.code);
                        }
                        string3 = string;
                    }
                    namedIdentifierArray[i + n] = new NamedIdentifier(citation2, string3);
                }
                map = new HashMap<String, Object>(map);
                map.put("identifiers", namedIdentifierArray);
            }
            return super.alterProperties(map);
        }
    }

    private final class Finder
    extends IdentifiedObjectFinder {
        Finder(Class<? extends IdentifiedObject> clazz) {
            super(WKTParsingAuthorityFactory.this, clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final IdentifiedObject create(String string, int n) throws FactoryException {
            switch (n) {
                case 0: {
                    return super.create(string, n);
                }
                case 1: {
                    WKTParsingAuthorityFactory wKTParsingAuthorityFactory = WKTParsingAuthorityFactory.this;
                    synchronized (wKTParsingAuthorityFactory) {
                        IdentifiedObject identifiedObject;
                        Parser parser = WKTParsingAuthorityFactory.this.getParser();
                        assert (parser.isAxisIgnored());
                        try {
                            parser.setAxisIgnored(false);
                            identifiedObject = super.create(string, 0);
                        }
                        catch (Throwable throwable) {
                            parser.setAxisIgnored(true);
                            throw throwable;
                        }
                        parser.setAxisIgnored(true);
                        return identifiedObject;
                    }
                }
            }
            return null;
        }
    }

    private final class Codes
    extends DerivedSet<String, String> {
        private static final long serialVersionUID = 2681905294171687900L;
        private final Class<? extends IdentifiedObject> type;

        public Codes(Class<? extends IdentifiedObject> clazz) {
            super(WKTParsingAuthorityFactory.this.definitions.keySet(), String.class);
            this.type = clazz;
        }

        protected String baseToDerived(String string) {
            int n;
            String string2;
            try {
                string2 = WKTParsingAuthorityFactory.this.definitions.get(WKTParsingAuthorityFactory.this.getPrimaryKey(this.type, string));
            }
            catch (FactoryException factoryException) {
                throw new BackingStoreException((Throwable)factoryException);
            }
            int n2 = string2.length();
            for (n = 0; n < n2 && Character.isJavaIdentifierPart(string2.charAt(n)); ++n) {
            }
            Class<Object> clazz = WKTFormat.getClassOf(string2.substring(0, n));
            if (clazz == null) {
                clazz = IdentifiedObject.class;
            }
            return this.type.isAssignableFrom(clazz) ? string : null;
        }

        protected String derivedToBase(String string) {
            return string;
        }
    }
}

