/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.referencing.Semaphores;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Units;
import org.geotoolkit.metadata.iso.quality.AbstractPositionalAccuracy;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

@Immutable
public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    public static final PositionalAccuracy[] EMPTY_ACCURACY_ARRAY = new PositionalAccuracy[0];
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    protected final CoordinateReferenceSystem sourceCRS;
    protected final CoordinateReferenceSystem targetCRS;
    final String operationVersion;
    private final Collection<PositionalAccuracy> coordinateOperationAccuracy;
    protected final Extent domainOfValidity;
    private final InternationalString scope;
    protected final MathTransform transform;

    AbstractCoordinateOperation(Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        super((IdentifiedObject)conversion);
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
        this.operationVersion = conversion.getOperationVersion();
        this.coordinateOperationAccuracy = conversion.getCoordinateOperationAccuracy();
        this.domainOfValidity = conversion.getDomainOfValidity();
        this.scope = conversion.getScope();
        this.transform = mathTransform;
    }

    public AbstractCoordinateOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        this(map, new HashMap<String, Object>(), coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
    }

    private AbstractCoordinateOperation(Map<String, ?> map, Map<String, Object> map2, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        super(map, map2, LOCALIZABLES);
        this.domainOfValidity = (Extent)map2.get("domainOfValidity");
        this.scope = (InternationalString)map2.get("scope");
        this.operationVersion = (String)map2.get("operationVersion");
        Object object = map2.get("coordinateOperationAccuracy");
        if (object instanceof PositionalAccuracy[]) {
            Object[] objectArray = (PositionalAccuracy[])((PositionalAccuracy[])object).clone();
            for (int i = 0; i < objectArray.length; ++i) {
                ArgumentChecks.ensureNonNull((String)"coordinateOperationAccuracy", (int)i, (Object[])objectArray);
            }
            this.coordinateOperationAccuracy = InternalUtilities.nonEmptySet((Object[])objectArray);
        } else {
            this.coordinateOperationAccuracy = object == null ? Collections.emptySet() : Collections.singleton((PositionalAccuracy)object);
        }
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
        this.transform = mathTransform;
        this.validate();
    }

    void validate() throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)this.sourceCRS);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)this.targetCRS);
        ArgumentChecks.ensureNonNull((String)"transform", (Object)this.transform);
        AbstractCoordinateOperation.checkDimension("sourceCRS", this.sourceCRS, this.transform.getSourceDimensions());
        AbstractCoordinateOperation.checkDimension("targetCRS", this.targetCRS, this.transform.getTargetDimensions());
    }

    private static void checkDimension(String string, CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        int n2 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        if (n2 != n) {
            throw new IllegalArgumentException(Errors.format((int)113, (Object)string, (Object)n2, (Object)n));
        }
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public String getOperationVersion() {
        return this.operationVersion;
    }

    public Collection<PositionalAccuracy> getCoordinateOperationAccuracy() {
        if (this.coordinateOperationAccuracy == null) {
            return Collections.emptySet();
        }
        return this.coordinateOperationAccuracy;
    }

    public double getAccuracy() {
        return AbstractCoordinateOperation.accuracy(this);
    }

    public static double getAccuracy(CoordinateOperation coordinateOperation) {
        if (coordinateOperation instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)coordinateOperation).getAccuracy();
        }
        return AbstractCoordinateOperation.accuracy(coordinateOperation);
    }

    private static double accuracy(CoordinateOperation coordinateOperation) {
        Collection collection = coordinateOperation.getCoordinateOperationAccuracy();
        if (collection != null) {
            for (PositionalAccuracy positionalAccuracy : collection) {
                if (positionalAccuracy == null) continue;
                for (Result result : positionalAccuracy.getResults()) {
                    Unit unit;
                    QuantitativeResult quantitativeResult;
                    Collection collection2;
                    if (!(result instanceof QuantitativeResult) || (collection2 = (quantitativeResult = (QuantitativeResult)result).getValues()) == null || !Units.isLinear((Unit)(unit = quantitativeResult.getValueUnit()))) continue;
                    Unit unit2 = unit.asType(Length.class);
                    for (Record record : collection2) {
                        for (Object v : record.getAttributes().values()) {
                            if (!(v instanceof Number)) continue;
                            double d = ((Number)v).doubleValue();
                            d = unit2.getConverterTo((Unit)SI.METRE).convert(d);
                            return d;
                        }
                    }
                }
            }
        }
        if (coordinateOperation instanceof Conversion) {
            return 0.0;
        }
        if (coordinateOperation instanceof Transformation) {
            if (!collection.contains(AbstractPositionalAccuracy.DATUM_SHIFT_OMITTED) && collection.contains(AbstractPositionalAccuracy.DATUM_SHIFT_APPLIED)) {
                return 25.0;
            }
            return 1000.0;
        }
        double d = Double.NaN;
        if (coordinateOperation instanceof ConcatenatedOperation) {
            for (Result result : ((ConcatenatedOperation)coordinateOperation).getOperations()) {
                double d2 = Math.abs(AbstractCoordinateOperation.getAccuracy((CoordinateOperation)result));
                if (Double.isNaN(d2)) continue;
                if (Double.isNaN(d)) {
                    d = d2;
                    continue;
                }
                d += d2;
            }
        }
        return d;
    }

    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    public InternationalString getScope() {
        return this.scope;
    }

    public MathTransform getMathTransform() {
        return this.transform;
    }

    public static Class<? extends CoordinateOperation> getType(CoordinateOperation coordinateOperation) {
        if (coordinateOperation instanceof Transformation) {
            return Transformation.class;
        }
        if (coordinateOperation instanceof ConicProjection) {
            return ConicProjection.class;
        }
        if (coordinateOperation instanceof CylindricalProjection) {
            return CylindricalProjection.class;
        }
        if (coordinateOperation instanceof PlanarProjection) {
            return PlanarProjection.class;
        }
        if (coordinateOperation instanceof Projection) {
            return Projection.class;
        }
        if (coordinateOperation instanceof Conversion) {
            return Conversion.class;
        }
        if (coordinateOperation instanceof SingleOperation) {
            return SingleOperation.class;
        }
        if (coordinateOperation instanceof ConcatenatedOperation) {
            return ConcatenatedOperation.class;
        }
        return CoordinateOperation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    AbstractCoordinateOperation abstractCoordinateOperation = (AbstractCoordinateOperation)object;
                    if (Utilities.equals((Object)this.sourceCRS, (Object)abstractCoordinateOperation.sourceCRS) && Utilities.equals((Object)this.transform, (Object)abstractCoordinateOperation.transform) && Utilities.equals((Object)this.domainOfValidity, (Object)abstractCoordinateOperation.domainOfValidity) && Utilities.equals((Object)this.scope, (Object)abstractCoordinateOperation.scope) && Utilities.equals(this.coordinateOperationAccuracy, abstractCoordinateOperation.coordinateOperationAccuracy)) break;
                    return false;
                }
                case BY_CONTRACT: {
                    AbstractCoordinateOperation abstractCoordinateOperation = (CoordinateOperation)object;
                    if (!(Utilities.deepEquals((Object)this.getScope(), (Object)abstractCoordinateOperation.getScope(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getDomainOfValidity(), (Object)abstractCoordinateOperation.getDomainOfValidity(), (ComparisonMode)comparisonMode) && Utilities.deepEquals(this.getCoordinateOperationAccuracy(), (Object)abstractCoordinateOperation.getCoordinateOperationAccuracy(), (ComparisonMode)comparisonMode))) {
                        return false;
                    }
                }
                default: {
                    AbstractCoordinateOperation abstractCoordinateOperation = (CoordinateOperation)object;
                    if (Utilities.deepEquals((Object)this.getSourceCRS(), (Object)abstractCoordinateOperation.getSourceCRS(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getMathTransform(), (Object)abstractCoordinateOperation.getMathTransform(), (ComparisonMode)comparisonMode)) break;
                    return false;
                }
            }
            if (Semaphores.queryAndSet(1)) {
                return true;
            }
            try {
                if (comparisonMode == ComparisonMode.STRICT) {
                    boolean bl = Utilities.equals((Object)this.targetCRS, (Object)((AbstractCoordinateOperation)object).targetCRS);
                    return bl;
                }
                boolean bl = Utilities.deepEquals((Object)this.getTargetCRS(), (Object)((CoordinateOperation)object).getTargetCRS(), (ComparisonMode)comparisonMode);
                return bl;
            }
            finally {
                Semaphores.clear(1);
            }
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((Object)this.sourceCRS, (int)Utilities.hash((Object)this.targetCRS, (int)Utilities.hash((Object)this.transform, (int)super.computeHashCode())));
    }

    @Override
    public String formatWKT(Formatter formatter) {
        AbstractCoordinateOperation.append(formatter, (IdentifiedObject)this.sourceCRS, "SOURCE");
        AbstractCoordinateOperation.append(formatter, (IdentifiedObject)this.targetCRS, "TARGET");
        return super.formatWKT(formatter);
    }

    static void append(Formatter formatter, IdentifiedObject identifiedObject, final String string) {
        if (identifiedObject != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(4);
            hashMap.put("name", formatter.getName(identifiedObject));
            hashMap.put("identifiers", (String)formatter.getIdentifier(identifiedObject));
            formatter.append(new AbstractIdentifiedObject(hashMap){

                @Override
                public String formatWKT(Formatter formatter) {
                    return string;
                }
            });
        }
    }
}

