/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.awt.RenderingHints;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.measure.converter.ConversionException;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.quality.AbstractPositionalAccuracy;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.referencing.factory.ReferencingFactoryContainer;
import org.geotoolkit.referencing.operation.AbstractCoordinateOperation;
import org.geotoolkit.referencing.operation.DefaultConcatenatedOperation;
import org.geotoolkit.referencing.operation.DefaultMathTransformFactory;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.referencing.operation.DefaultSingleOperation;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.geotoolkit.referencing.operation.provider.Affine;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.util.converter.Classes;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

@ThreadSafe
public abstract class AbstractCoordinateOperationFactory
extends ReferencingFactory
implements CoordinateOperationFactory {
    protected static final ReferenceIdentifier IDENTITY = new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)146));
    protected static final ReferenceIdentifier AXIS_CHANGES = new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)15));
    protected static final ReferenceIdentifier DATUM_SHIFT = new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)64));
    protected static final ReferenceIdentifier ELLIPSOID_SHIFT = new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)93));
    protected static final ReferenceIdentifier GEOCENTRIC_CONVERSION = new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)117));
    protected static final ReferenceIdentifier INVERSE_OPERATION = new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)163));
    final ReferencingFactoryContainer factories;
    private final WeakHashSet<CoordinateOperation> pool = WeakHashSet.newInstance(CoordinateOperation.class);
    private volatile boolean hintsInitialized;

    public AbstractCoordinateOperationFactory(Hints hints) {
        this.factories = ReferencingFactoryContainer.instance(hints);
    }

    AbstractCoordinateOperationFactory(CoordinateOperationFactory coordinateOperationFactory, Hints hints) {
        this.factories = coordinateOperationFactory instanceof AbstractCoordinateOperationFactory ? ((AbstractCoordinateOperationFactory)coordinateOperationFactory).factories : ReferencingFactoryContainer.instance(hints);
    }

    CoordinateOperationFactory getBackingFactory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        if (!this.hintsInitialized) {
            Map<RenderingHints.Key, ?> map = this.factories.getImplementationHints();
            CoordinateOperationFactory coordinateOperationFactory = this.getBackingFactory();
            AbstractCoordinateOperationFactory abstractCoordinateOperationFactory = this;
            synchronized (abstractCoordinateOperationFactory) {
                if (!this.hintsInitialized) {
                    this.hintsInitialized = true;
                    this.hints.putAll(map);
                    if (coordinateOperationFactory != null) {
                        this.hints.put(Hints.COORDINATE_OPERATION_FACTORY, coordinateOperationFactory);
                    }
                }
            }
        }
        return super.getImplementationHints();
    }

    Map<RenderingHints.Key, ?> initializeHints() {
        return this.factories.getImplementationHints();
    }

    public OperationMethod getOperationMethod(String string) throws FactoryException {
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        if (mathTransformFactory instanceof DefaultMathTransformFactory) {
            return ((DefaultMathTransformFactory)mathTransformFactory).getOperationMethod(string);
        }
        for (OperationMethod operationMethod : mathTransformFactory.getAvailableMethods(SingleOperation.class)) {
            if (!IdentifiedObjects.nameMatches((IdentifiedObject)operationMethod, string)) continue;
            return operationMethod;
        }
        throw new NoSuchIdentifierException(Errors.format((int)170, (Object)string), string);
    }

    public final MathTransformFactory getMathTransformFactory() {
        return this.factories.getMathTransformFactory();
    }

    protected Matrix swapAndScaleAxis(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) throws OperationNotFoundException {
        try {
            return AbstractCS.swapAndScaleAxis(coordinateSystem, coordinateSystem2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotFoundException(AbstractCoordinateOperationFactory.getErrorMessage((IdentifiedObject)coordinateSystem, (IdentifiedObject)coordinateSystem2), (Throwable)illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            throw new OperationNotFoundException(AbstractCoordinateOperationFactory.getErrorMessage((IdentifiedObject)coordinateSystem, (IdentifiedObject)coordinateSystem2), (Throwable)conversionException);
        }
    }

    private static Map<String, Object> getProperties(ReferenceIdentifier referenceIdentifier) {
        HashMap<String, Object> hashMap;
        if (referenceIdentifier == DATUM_SHIFT || referenceIdentifier == ELLIPSOID_SHIFT) {
            hashMap = new HashMap<String, ReferenceIdentifier>(4);
            hashMap.put("name", referenceIdentifier);
            hashMap.put("coordinateOperationAccuracy", new PositionalAccuracy[]{referenceIdentifier == DATUM_SHIFT ? AbstractPositionalAccuracy.DATUM_SHIFT_APPLIED : AbstractPositionalAccuracy.DATUM_SHIFT_OMITTED});
        } else {
            hashMap = Collections.singletonMap("name", referenceIdentifier);
        }
        return hashMap;
    }

    protected CoordinateOperation createFromAffineTransform(ReferenceIdentifier referenceIdentifier, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, Matrix matrix) throws FactoryException {
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        MathTransform mathTransform = mathTransformFactory.createAffineTransform(matrix);
        Map<String, Object> map = AbstractCoordinateOperationFactory.getProperties(referenceIdentifier);
        Class clazz = map.containsKey("coordinateOperationAccuracy") ? Transformation.class : Conversion.class;
        return this.createFromMathTransform(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, Affine.getProvider(mathTransform.getSourceDimensions(), mathTransform.getTargetDimensions()), clazz);
    }

    protected CoordinateOperation createFromParameters(ReferenceIdentifier referenceIdentifier, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, ParameterValueGroup parameterValueGroup) throws FactoryException {
        Map<String, Object> map = AbstractCoordinateOperationFactory.getProperties(referenceIdentifier);
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        MathTransform mathTransform = mathTransformFactory.createParameterizedTransform(parameterValueGroup);
        OperationMethod operationMethod = mathTransformFactory.getLastMethodUsed();
        return this.createFromMathTransform(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod, SingleOperation.class);
    }

    protected CoordinateOperation createFromMathTransform(ReferenceIdentifier referenceIdentifier, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) throws FactoryException {
        Map<String, ReferenceIdentifier> map = Collections.singletonMap("name", referenceIdentifier);
        return this.createFromMathTransform(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, this.createOperationMethod(map, coordinateReferenceSystem.getCoordinateSystem().getDimension(), coordinateReferenceSystem2.getCoordinateSystem().getDimension(), null), CoordinateOperation.class);
    }

    protected CoordinateOperation createFromMathTransform(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod, Class<? extends CoordinateOperation> clazz) throws FactoryException {
        CoordinateOperation coordinateOperation;
        if (mathTransform instanceof CoordinateOperation && Utilities.equals((Object)(coordinateOperation = (CoordinateOperation)mathTransform).getSourceCRS(), (Object)coordinateReferenceSystem) && Utilities.equals((Object)coordinateOperation.getTargetCRS(), (Object)coordinateReferenceSystem2) && Utilities.equals((Object)coordinateOperation.getMathTransform(), (Object)mathTransform)) {
            if (coordinateOperation instanceof SingleOperation) {
                if (Utilities.equals((Object)((SingleOperation)coordinateOperation).getMethod(), (Object)operationMethod)) {
                    return coordinateOperation;
                }
            } else {
                return coordinateOperation;
            }
        }
        coordinateOperation = DefaultSingleOperation.create(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod, clazz);
        coordinateOperation = (CoordinateOperation)this.pool.unique((Object)coordinateOperation);
        return coordinateOperation;
    }

    public Conversion createDefiningConversion(Map<String, ?> map, OperationMethod operationMethod, ParameterValueGroup parameterValueGroup) throws FactoryException {
        DefiningConversion definingConversion = new DefiningConversion(map, operationMethod, parameterValueGroup);
        definingConversion = (Conversion)this.pool.unique((Object)definingConversion);
        return definingConversion;
    }

    public OperationMethod createOperationMethod(Map<String, ?> map, Integer n, Integer n2, ParameterDescriptorGroup parameterDescriptorGroup) throws FactoryException {
        return new DefaultOperationMethod(map, n, n2, parameterDescriptorGroup);
    }

    public CoordinateOperation createConcatenatedOperation(Map<String, ?> map, CoordinateOperation ... coordinateOperationArray) throws FactoryException {
        DefaultConcatenatedOperation defaultConcatenatedOperation = new DefaultConcatenatedOperation(map, coordinateOperationArray, this.getMathTransformFactory());
        defaultConcatenatedOperation = (CoordinateOperation)this.pool.unique((Object)defaultConcatenatedOperation);
        return defaultConcatenatedOperation;
    }

    protected CoordinateOperation concatenate(CoordinateOperation coordinateOperation, CoordinateOperation coordinateOperation2) throws FactoryException {
        if (coordinateOperation == null) {
            return coordinateOperation2;
        }
        if (coordinateOperation2 == null) {
            return coordinateOperation;
        }
        assert (InternalUtilities.debugEquals((Object)coordinateOperation.getTargetCRS(), (Object)coordinateOperation2.getSourceCRS()));
        if (AbstractCoordinateOperationFactory.isIdentity(coordinateOperation)) {
            return coordinateOperation2;
        }
        if (AbstractCoordinateOperationFactory.isIdentity(coordinateOperation2)) {
            return coordinateOperation;
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        MathTransform mathTransform2 = coordinateOperation2.getMathTransform();
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation2.getTargetCRS();
        CoordinateOperation coordinateOperation3 = null;
        if (coordinateOperation.getName() == AXIS_CHANGES && mathTransform.getSourceDimensions() == mathTransform.getTargetDimensions()) {
            coordinateOperation3 = coordinateOperation2;
        }
        if (coordinateOperation2.getName() == AXIS_CHANGES && mathTransform2.getSourceDimensions() == mathTransform2.getTargetDimensions()) {
            coordinateOperation3 = coordinateOperation;
        }
        if (coordinateOperation3 instanceof SingleOperation) {
            MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
            return this.createFromMathTransform(IdentifiedObjects.getProperties((IdentifiedObject)coordinateOperation3), coordinateReferenceSystem, coordinateReferenceSystem2, mathTransformFactory.createConcatenatedTransform(mathTransform, mathTransform2), ((SingleOperation)coordinateOperation3).getMethod(), CoordinateOperation.class);
        }
        return this.createConcatenatedOperation(AbstractCoordinateOperationFactory.getTemporaryName(coordinateReferenceSystem, coordinateReferenceSystem2), coordinateOperation, coordinateOperation2);
    }

    protected CoordinateOperation concatenate(CoordinateOperation coordinateOperation, CoordinateOperation coordinateOperation2, CoordinateOperation coordinateOperation3) throws FactoryException {
        if (coordinateOperation == null) {
            return this.concatenate(coordinateOperation2, coordinateOperation3);
        }
        if (coordinateOperation2 == null) {
            return this.concatenate(coordinateOperation, coordinateOperation3);
        }
        if (coordinateOperation3 == null) {
            return this.concatenate(coordinateOperation, coordinateOperation2);
        }
        assert (InternalUtilities.debugEquals((Object)coordinateOperation.getTargetCRS(), (Object)coordinateOperation2.getSourceCRS())) : coordinateOperation;
        assert (InternalUtilities.debugEquals((Object)coordinateOperation2.getTargetCRS(), (Object)coordinateOperation3.getSourceCRS())) : coordinateOperation3;
        if (AbstractCoordinateOperationFactory.isIdentity(coordinateOperation)) {
            return this.concatenate(coordinateOperation2, coordinateOperation3);
        }
        if (AbstractCoordinateOperationFactory.isIdentity(coordinateOperation2)) {
            return this.concatenate(coordinateOperation, coordinateOperation3);
        }
        if (AbstractCoordinateOperationFactory.isIdentity(coordinateOperation3)) {
            return this.concatenate(coordinateOperation, coordinateOperation2);
        }
        if (coordinateOperation.getName() == AXIS_CHANGES) {
            return this.concatenate(this.concatenate(coordinateOperation, coordinateOperation2), coordinateOperation3);
        }
        if (coordinateOperation3.getName() == AXIS_CHANGES) {
            return this.concatenate(coordinateOperation, this.concatenate(coordinateOperation2, coordinateOperation3));
        }
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation3.getTargetCRS();
        return this.createConcatenatedOperation(AbstractCoordinateOperationFactory.getTemporaryName(coordinateReferenceSystem, coordinateReferenceSystem2), coordinateOperation, coordinateOperation2, coordinateOperation3);
    }

    private static boolean isIdentity(CoordinateOperation coordinateOperation) {
        return coordinateOperation instanceof Conversion && coordinateOperation.getMathTransform().isIdentity();
    }

    protected CoordinateOperation inverse(CoordinateOperation coordinateOperation) throws NoninvertibleTransformException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation.getTargetCRS();
        Map<String, Object> map = IdentifiedObjects.getProperties((IdentifiedObject)coordinateOperation, null);
        map.putAll(AbstractCoordinateOperationFactory.getTemporaryName(coordinateReferenceSystem2, coordinateReferenceSystem));
        if (coordinateOperation instanceof ConcatenatedOperation) {
            LinkedList<CoordinateOperation> linkedList = new LinkedList<CoordinateOperation>();
            for (SingleOperation singleOperation : ((ConcatenatedOperation)coordinateOperation).getOperations()) {
                linkedList.addFirst(this.inverse((CoordinateOperation)singleOperation));
            }
            return this.createConcatenatedOperation(map, linkedList.toArray(new CoordinateOperation[linkedList.size()]));
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform().inverse();
        Class<? extends CoordinateOperation> clazz = AbstractCoordinateOperation.getType(coordinateOperation);
        OperationMethod operationMethod = coordinateOperation instanceof SingleOperation ? ((SingleOperation)coordinateOperation).getMethod() : null;
        return this.createFromMathTransform(map, coordinateReferenceSystem2, coordinateReferenceSystem, mathTransform, operationMethod, clazz);
    }

    static int getDimension(CoordinateReferenceSystem coordinateReferenceSystem) {
        return coordinateReferenceSystem != null ? coordinateReferenceSystem.getCoordinateSystem().getDimension() : 0;
    }

    private static String getClassName(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            ReferenceIdentifier referenceIdentifier;
            ReferenceIdentifier referenceIdentifier2 = identifiedObject.getClass();
            Class<?>[] classArray = referenceIdentifier2.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                referenceIdentifier = classArray[i];
                if (!referenceIdentifier.getName().startsWith("org.opengis.referencing.")) continue;
                referenceIdentifier2 = referenceIdentifier;
                break;
            }
            String string = Classes.getShortName(referenceIdentifier2);
            referenceIdentifier = identifiedObject.getName();
            if (referenceIdentifier != null) {
                string = string + '[' + referenceIdentifier.getCode() + ']';
            }
            return string;
        }
        return null;
    }

    static Map<String, Object> getTemporaryName(IdentifiedObject identifiedObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", (Object)new TemporaryIdentifier(identifiedObject.getName()));
        hashMap.put("remarks", Vocabulary.formatInternational((int)74, (Object)AbstractCoordinateOperationFactory.getClassName(identifiedObject)));
        return hashMap;
    }

    static Map<String, ?> getTemporaryName(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        String string = AbstractCoordinateOperationFactory.getClassName((IdentifiedObject)coordinateReferenceSystem) + " \u21e8 " + AbstractCoordinateOperationFactory.getClassName((IdentifiedObject)coordinateReferenceSystem2);
        return Collections.singletonMap("name", string);
    }

    protected static String getErrorMessage(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
        return Errors.format((int)169, (Object)AbstractCoordinateOperationFactory.getClassName(identifiedObject), (Object)AbstractCoordinateOperationFactory.getClassName(identifiedObject2));
    }

    private static final class TemporaryIdentifier
    extends NamedIdentifier {
        private static final long serialVersionUID = -2784354058026177076L;
        private final ReferenceIdentifier parent;
        private final int count;

        public TemporaryIdentifier(ReferenceIdentifier referenceIdentifier) {
            this(referenceIdentifier, (referenceIdentifier instanceof TemporaryIdentifier ? ((TemporaryIdentifier)referenceIdentifier).count : 0) + 1);
        }

        private TemporaryIdentifier(ReferenceIdentifier referenceIdentifier, int n) {
            super(Citations.GEOTOOLKIT, TemporaryIdentifier.unwrap(referenceIdentifier).getCode() + " (step " + n + ')');
            this.parent = referenceIdentifier;
            this.count = n;
        }

        public static ReferenceIdentifier unwrap(ReferenceIdentifier referenceIdentifier) {
            while (referenceIdentifier instanceof TemporaryIdentifier) {
                referenceIdentifier = ((TemporaryIdentifier)referenceIdentifier).parent;
            }
            return referenceIdentifier;
        }
    }
}

