/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.operation.Formula;
import org.opengis.util.InternationalString;

@Immutable
public class DefaultFormula
implements Formula,
Serializable {
    private static final long serialVersionUID = 1929966748615362698L;
    private final InternationalString formula;
    private final Citation citation;

    public DefaultFormula(CharSequence charSequence) {
        ArgumentChecks.ensureNonNull((String)"formula", (Object)charSequence);
        this.formula = charSequence instanceof InternationalString ? (InternationalString)charSequence : new SimpleInternationalString(((Object)charSequence).toString());
        this.citation = null;
    }

    public DefaultFormula(Citation citation) {
        ArgumentChecks.ensureNonNull((String)"citation", (Object)citation);
        this.citation = citation;
        this.formula = null;
    }

    public InternationalString getFormula() {
        return this.formula;
    }

    public Citation getCitation() {
        return this.citation;
    }

    public int hashCode() {
        int n = 1334364298;
        if (this.formula != null) {
            n += this.formula.hashCode();
        }
        if (this.citation != null) {
            n += this.citation.hashCode() * 31;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultFormula defaultFormula = (DefaultFormula)object;
            return Utilities.equals((Object)this.formula, (Object)defaultFormula.formula) && Utilities.equals((Object)this.citation, (Object)defaultFormula.citation);
        }
        return false;
    }

    public String toString() {
        InternationalString internationalString = this.citation != null ? this.citation.getTitle() : this.formula;
        return "FORMULA[\"" + internationalString + "\"]";
    }
}

