/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.HashMap;
import java.util.Map;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;

@Immutable
public abstract class MathTransformProvider
extends DefaultOperationMethod {
    private static final long serialVersionUID = 7530475536803158473L;

    public MathTransformProvider(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        this((Map<String, ?>)MathTransformProvider.toMap((IdentifiedObject)parameterDescriptorGroup), n, n2, parameterDescriptorGroup);
    }

    public MathTransformProvider(Map<String, ?> map, int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(map, n, n2, parameterDescriptorGroup);
    }

    private static Map<String, Object> toMap(IdentifiedObject identifiedObject) {
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)identifiedObject);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", identifiedObject.getName());
        hashMap.put("identifiers", identifiedObject.getIdentifiers().toArray(IdentifiedObjects.EMPTY_IDENTIFIER_ARRAY));
        hashMap.put("alias", identifiedObject.getAlias().toArray(IdentifiedObjects.EMPTY_ALIAS_ARRAY));
        return hashMap;
    }

    final boolean identifierMatches(String string, String string2) {
        for (ReferenceIdentifier referenceIdentifier : this.getIdentifiers()) {
            if (!string.equals(referenceIdentifier.getCodeSpace()) || !string2.equals(referenceIdentifier.getCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<? extends SingleOperation> getOperationType() {
        return SingleOperation.class;
    }

    protected abstract MathTransform createMathTransform(ParameterValueGroup var1) throws InvalidParameterNameException, ParameterNotFoundException, InvalidParameterValueException, FactoryException;

    protected ParameterValueGroup ensureValidValues(ParameterValueGroup parameterValueGroup) throws InvalidParameterNameException, InvalidParameterValueException {
        ParameterDescriptorGroup parameterDescriptorGroup;
        ParameterDescriptorGroup parameterDescriptorGroup2 = this.getParameters();
        if (parameterDescriptorGroup2.equals(parameterDescriptorGroup = parameterValueGroup.getDescriptor())) {
            return parameterValueGroup;
        }
        ParameterValueGroup parameterValueGroup2 = parameterDescriptorGroup2.createValue();
        MathTransformProvider.copy(parameterValueGroup, parameterValueGroup2);
        return parameterValueGroup2;
    }

    private static void copy(ParameterValueGroup parameterValueGroup, ParameterValueGroup parameterValueGroup2) throws InvalidParameterNameException, InvalidParameterValueException {
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            InvalidParameterNameException invalidParameterNameException;
            ParameterValue parameterValue;
            ParameterValue parameterValue2;
            String string = generalParameterValue.getDescriptor().getName().getCode();
            if (generalParameterValue instanceof ParameterValueGroup) {
                parameterValue2 = parameterValueGroup2.getDescriptor().descriptor(string);
                if (parameterValue2 instanceof ParameterDescriptorGroup) {
                    parameterValue = (ParameterValueGroup)parameterValue2.createValue();
                    MathTransformProvider.copy((ParameterValueGroup)generalParameterValue, (ParameterValueGroup)parameterValue);
                    parameterValueGroup.groups(string).add(parameterValue);
                    continue;
                }
                throw new InvalidParameterNameException(Errors.format((int)210, (Object)string), string);
            }
            parameterValue2 = (ParameterValue)generalParameterValue;
            try {
                parameterValue = parameterValueGroup2.parameter(string);
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                invalidParameterNameException = new InvalidParameterNameException(Errors.format((int)210, (Object)string), string);
                invalidParameterNameException.initCause((Throwable)parameterNotFoundException);
                throw invalidParameterNameException;
            }
            Object object = parameterValue2.getValue();
            invalidParameterNameException = parameterValue2.getUnit();
            if (invalidParameterNameException == null) {
                parameterValue.setValue(object);
                continue;
            }
            if (object instanceof Number) {
                parameterValue.setValue(((Number)object).doubleValue(), (Unit)invalidParameterNameException);
                continue;
            }
            if (object instanceof double[]) {
                parameterValue.setValue((double[])object, (Unit)invalidParameterNameException);
                continue;
            }
            throw new InvalidParameterValueException(Errors.format((int)73, (Object)string, (Object)object), string, object);
        }
    }

    @Override
    public String formatWKT(Formatter formatter) {
        Class<? extends SingleOperation> clazz = this.getOperationType();
        if (Projection.class.isAssignableFrom(clazz)) {
            return super.formatWKT(formatter);
        }
        formatter.setInvalidWKT(OperationMethod.class);
        return "OperationMethod";
    }
}

