/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import javax.vecmath.GMatrix;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.io.LineFormat;
import org.geotoolkit.math.Statistics;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.operation.matrix.AffineMatrix3;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.XArrays;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.Matrix;

public class GeneralMatrix
extends GMatrix
implements XMatrix {
    private static final long serialVersionUID = 8447482612423035360L;

    public GeneralMatrix(int n) {
        super(n, n);
    }

    public GeneralMatrix(int n, int n2) {
        super(n, n2);
    }

    public GeneralMatrix(int n, int n2, double[] dArray) {
        super(n, n2, dArray);
        if (n * n2 != dArray.length) {
            throw new IllegalArgumentException(String.valueOf(dArray.length));
        }
    }

    public GeneralMatrix(double[] ... dArray) throws IllegalArgumentException {
        super(dArray.length, dArray.length != 0 ? dArray[0].length : 0);
        int n = this.getNumRow();
        int n2 = this.getNumCol();
        for (int i = 0; i < n; ++i) {
            if (dArray[i].length != n2) {
                throw new IllegalArgumentException(Errors.format((int)108));
            }
            this.setRow(i, dArray[i]);
        }
    }

    public GeneralMatrix(Matrix matrix) {
        this(matrix.getNumRow(), matrix.getNumCol());
        int n = this.getNumRow();
        int n2 = this.getNumCol();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.setElement(i, j, matrix.getElement(i, j));
            }
        }
    }

    public GeneralMatrix(GMatrix gMatrix) {
        super(gMatrix);
    }

    public GeneralMatrix(AffineTransform affineTransform) {
        super(3, 3, new double[]{affineTransform.getScaleX(), affineTransform.getShearX(), affineTransform.getTranslateX(), affineTransform.getShearY(), affineTransform.getScaleY(), affineTransform.getTranslateY(), 0.0, 0.0, 1.0});
        assert (this.isAffine()) : this;
    }

    public GeneralMatrix(Envelope envelope, Envelope envelope2) {
        super(envelope2.getDimension() + 1, envelope.getDimension() + 1);
        int n = envelope.getDimension();
        int n2 = envelope2.getDimension();
        int n3 = Math.min(n, n2);
        while (--n3 >= 0) {
            double d = envelope2.getSpan(n3) / envelope.getSpan(n3);
            double d2 = envelope2.getMinimum(n3) - envelope.getMinimum(n3) * d;
            this.setElement(n3, n3, d);
            this.setElement(n3, n, d2);
        }
        this.setElement(n2, n, 1.0);
        assert (n != n2 || this.isAffine()) : this;
    }

    public GeneralMatrix(AxisDirection[] axisDirectionArray, AxisDirection[] axisDirectionArray2) {
        this(null, axisDirectionArray, null, axisDirectionArray2, false);
    }

    public GeneralMatrix(Envelope envelope, AxisDirection[] axisDirectionArray, Envelope envelope2, AxisDirection[] axisDirectionArray2) {
        this(envelope, axisDirectionArray, envelope2, axisDirectionArray2, true);
    }

    private GeneralMatrix(Envelope envelope, AxisDirection[] axisDirectionArray, Envelope envelope2, AxisDirection[] axisDirectionArray2, boolean bl) {
        super(axisDirectionArray2.length + 1, axisDirectionArray.length + 1);
        if (bl) {
            GeneralMatrix.ensureDimensionMatch("srcRegion", envelope, axisDirectionArray.length);
            GeneralMatrix.ensureDimensionMatch("dstRegion", envelope2, axisDirectionArray2.length);
        }
        this.setZero();
        for (int i = 0; i < axisDirectionArray2.length; ++i) {
            boolean bl2 = false;
            AxisDirection axisDirection = axisDirectionArray2[i];
            AxisDirection axisDirection2 = AxisDirections.absolute(axisDirection);
            for (int j = 0; j < axisDirectionArray.length; ++j) {
                AxisDirection axisDirection3 = axisDirectionArray[j];
                if (!axisDirection2.equals((Object)AxisDirections.absolute(axisDirection3))) continue;
                if (bl2) {
                    throw new IllegalArgumentException(Errors.format((int)44, (Object)axisDirection3.name(), (Object)axisDirection.name()));
                }
                bl2 = true;
                boolean bl3 = axisDirection3.equals((Object)axisDirection);
                double d = bl3 ? 1.0 : -1.0;
                double d2 = 0.0;
                if (bl) {
                    d2 = bl3 ? envelope2.getMinimum(i) : envelope2.getMaximum(i);
                    d2 -= envelope.getMinimum(j) * (d *= envelope2.getSpan(i) / envelope.getSpan(j));
                }
                this.setElement(i, j, d);
                this.setElement(i, axisDirectionArray.length, d2);
            }
            if (bl2) continue;
            throw new IllegalArgumentException(Errors.format((int)162, (Object)axisDirectionArray2[i].name()));
        }
        this.setElement(axisDirectionArray2.length, axisDirectionArray.length, 1.0);
        assert (axisDirectionArray.length != axisDirectionArray2.length || this.isAffine()) : this;
    }

    private static void ensureDimensionMatch(String string, Envelope envelope, int n) throws MismatchedDimensionException {
        int n2 = envelope.getDimension();
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format((int)113, (Object)string, (Object)n2, (Object)n));
        }
    }

    public static double[][] getElements(Matrix matrix) {
        if (matrix instanceof GeneralMatrix) {
            return ((GeneralMatrix)matrix).getElements();
        }
        int n = matrix.getNumCol();
        double[][] dArrayArray = new double[matrix.getNumRow()][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            double[] dArray = new double[n];
            dArrayArray[i] = dArray;
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = matrix.getElement(i, j);
            }
        }
        return dArrayArray;
    }

    public final double[][] getElements() {
        int n = this.getNumCol();
        double[][] dArrayArray = new double[this.getNumRow()][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[n];
            this.getRow(i, dArrayArray[i]);
        }
        return dArrayArray;
    }

    @Override
    public final boolean isAffine() {
        int n = this.getNumRow();
        if (n != this.getNumCol()) {
            return false;
        }
        --n;
        for (int i = 0; i <= n; ++i) {
            if (this.getElement(n, i) == (double)(i == n ? 1 : 0)) continue;
            return false;
        }
        return true;
    }

    public final boolean isIdentity() {
        int n;
        int n2 = this.getNumRow();
        if (n2 != (n = this.getNumCol())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (this.getElement(i, j) == (double)(j == i ? 1 : 0)) continue;
                return false;
            }
        }
        assert (this.isAffine()) : this;
        assert (this.isIdentity(0.0)) : this;
        return true;
    }

    @Override
    public final boolean isIdentity(double d) {
        return GeneralMatrix.isIdentity(this, d);
    }

    static boolean isIdentity(Matrix matrix, double d) {
        int n;
        d = Math.abs(d);
        int n2 = matrix.getNumRow();
        if (n2 != (n = matrix.getNumCol())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d2 = matrix.getElement(i, j);
                if (j == i) {
                    d2 -= 1.0;
                }
                if (Math.abs(d2) <= d) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final void multiply(Matrix matrix) {
        Object object = matrix instanceof GMatrix ? (GMatrix)matrix : new GeneralMatrix(matrix);
        this.mul((GMatrix)object);
    }

    @Override
    public void normalizeColumns() {
        double[] dArray = new double[this.getNumRow()];
        int n = this.getNumCol();
        while (--n >= 0) {
            this.getColumn(n, dArray);
            double d = XMath.magnitude((double[])dArray);
            int n2 = 0;
            while (n2 < dArray.length) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] / d;
            }
            this.setColumn(n, dArray);
        }
    }

    @Override
    public boolean equals(Matrix matrix, double d) {
        return Matrices.equals(this, matrix, d, false);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return object instanceof Matrix && Matrices.equals(this, (Matrix)object, comparisonMode);
    }

    public final AffineTransform toAffineTransform2D() throws IllegalStateException {
        int n = this.getNumRow();
        if (n != 3 || (n = this.getNumCol()) != 3) {
            throw new IllegalStateException(Errors.format((int)150, (Object)(n - 1)));
        }
        if (this.isAffine()) {
            return new AffineMatrix3(this.getElement(0, 0), this.getElement(1, 0), this.getElement(0, 1), this.getElement(1, 1), this.getElement(0, 2), this.getElement(1, 2));
        }
        throw new IllegalStateException(Errors.format((int)140));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeneralMatrix load(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            GeneralMatrix generalMatrix = GeneralMatrix.load(bufferedReader, Locale.US);
            return generalMatrix;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static GeneralMatrix load(BufferedReader bufferedReader, Locale locale) throws IOException {
        String string;
        LineFormat lineFormat = new LineFormat(locale);
        double[] dArray = null;
        double[] dArray2 = null;
        int n = 0;
        int n2 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty()) {
                if (n != 0) break;
                continue;
            }
            try {
                lineFormat.setLine(string);
                dArray2 = lineFormat.getValues(dArray2);
            }
            catch (ParseException parseException) {
                throw new ContentFormatException(parseException.getLocalizedMessage(), (Throwable)parseException);
            }
            int n3 = n2 + dArray2.length;
            if (dArray == null) {
                dArray = new double[n2 * n2];
            }
            if (n3 > dArray.length) {
                dArray = Arrays.copyOf(dArray, n3 * 2);
            }
            System.arraycopy(dArray2, 0, dArray, n2, dArray2.length);
            n2 = n3;
            assert (n2 % ++n == 0) : n2;
        }
        dArray = dArray != null ? XArrays.resize((double[])dArray, (int)n2) : XArrays.EMPTY_DOUBLE;
        return new GeneralMatrix(n, n2 / n, dArray);
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    static String toString(Matrix matrix) {
        int n;
        int n2 = matrix.getNumRow();
        int n3 = matrix.getNumCol();
        Statistics statistics = new Statistics();
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                statistics.add(matrix.getElement(i, n));
            }
        }
        NumberFormat numberFormat = statistics.getNumberFormat(null);
        numberFormat.setGroupingUsed(false);
        n = numberFormat.getMaximumFractionDigits() + 6;
        FieldPosition fieldPosition = new FieldPosition(0);
        String string = System.getProperty("line.separator", "\n");
        String string2 = Strings.spaces((int)(n3 * n + 1));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u250c').append(string2).append('\u2510').append(string);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('\u2502');
            for (int j = 0; j < n3; ++j) {
                int n4 = stringBuffer.length();
                stringBuffer = numberFormat.format(matrix.getElement(i, j), stringBuffer, fieldPosition);
                int n5 = Math.max(n - (stringBuffer.length() - n4), 1);
                stringBuffer.insert(n4, Strings.spaces((int)n5));
            }
            stringBuffer.append(" \u2502").append(string);
        }
        return stringBuffer.append('\u2514').append(string2).append('\u2518').append(string).toString();
    }

    @Override
    public GeneralMatrix clone() {
        return (GeneralMatrix)super.clone();
    }
}

