/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.util.ComparisonMode;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class Orthographic
extends UnitaryProjection {
    private static final long serialVersionUID = 5036668705538661687L;
    private static final double EPSILON = 1.0E-6;
    private final byte type;
    private final double latitudeOfOrigin;
    private final double sin\u03c60;
    private final double cos\u03c60;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        Orthographic orthographic = new Orthographic(parameters);
        return orthographic.createConcatenatedTransform();
    }

    protected Orthographic(UnitaryProjection.Parameters parameters) {
        super(parameters);
        double d = Math.toRadians(parameters.latitudeOfOrigin);
        boolean bl = false;
        boolean bl2 = false;
        if (Math.abs(Math.abs(d) - 1.5707963267948966) <= 1.0E-6) {
            if (d >= 0.0) {
                bl = true;
            } else {
                bl2 = true;
            }
            d = 1.5707963267948966;
            this.type = 1;
        } else {
            this.type = d == 0.0 ? (byte)0 : (byte)2;
        }
        this.latitudeOfOrigin = d;
        this.sin\u03c60 = Math.sin(d);
        this.cos\u03c60 = Math.cos(d);
        if (bl2) {
            parameters.normalize(true).scale(1.0, -1.0);
        }
        parameters.validate();
        AffineTransform affineTransform = parameters.normalize(false);
        if (!parameters.isSpherical()) {
            double d2 = Math.sin(Math.abs(d));
            d2 = Math.sqrt(1.0 - this.excentricitySquared) / (1.0 - d2 * d2 * this.excentricitySquared);
            affineTransform.scale(d2, d2);
        }
        if (bl) {
            affineTransform.scale(1.0, -1.0);
        }
        this.finish();
    }

    @Override
    boolean isSpherical() {
        return true;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return org.geotoolkit.referencing.operation.provider.Orthographic.PARAMETERS;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = this.rollLongitude(dArray[n]);
        double d7 = dArray[n + 1];
        double d8 = Math.cos(d7);
        double d9 = Math.cos(d6);
        double d10 = Math.sin(d6);
        switch (this.type) {
            default: {
                d5 = Math.sin(d7);
                d4 = this.sin\u03c60 * d5 + this.cos\u03c60 * d8 * d9;
                d3 = this.cos\u03c60 * d5 - this.sin\u03c60 * d8 * d9;
                break;
            }
            case 0: {
                d4 = d8 * d9;
                d3 = Math.sin(d7);
                break;
            }
            case 1: {
                d4 = d7;
                d3 = d8 * d9;
            }
        }
        if (d4 < -1.0E-6) {
            throw new ProjectionException(187);
        }
        if (dArray2 != null) {
            dArray2[n2] = d8 * d10;
            dArray2[n2 + 1] = d3;
        }
        if (!bl) {
            return null;
        }
        double d11 = Math.sin(d7);
        d5 = d8 * d9;
        double d12 = -d11 * d10;
        switch (this.type) {
            default: {
                d2 = this.sin\u03c60 * d8 * d10;
                d = this.cos\u03c60 * d8 + this.sin\u03c60 * d9 * d11;
                break;
            }
            case 0: {
                d2 = 0.0;
                d = d8;
                break;
            }
            case 1: {
                d2 = -d8 * d10;
                d = -d11 * d9;
            }
        }
        return new Matrix2(d5, d12, d2, d);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        double d4 = Math.hypot(d2, d3);
        double d5 = d4;
        if (d5 > 1.0) {
            if (d5 - 1.0 > 1.0E-6) {
                throw new ProjectionException(187);
            }
            d5 = 1.0;
        }
        if (d4 <= 1.0E-6) {
            d = this.latitudeOfOrigin;
            d2 = 0.0;
        } else {
            if (this.type != 1) {
                double d6 = Math.sqrt(1.0 - d5 * d5);
                if (this.type != 0) {
                    d = d6 * this.sin\u03c60 + d3 * d5 * this.cos\u03c60 / d4;
                    d2 *= d5 * this.cos\u03c60;
                    d3 = (d6 - this.sin\u03c60 * d) * d4;
                } else {
                    d = d3 * d5 / d4;
                    d2 *= d5;
                    d3 = d6 * d4;
                }
                d = Math.abs(d) >= 1.0 ? Math.copySign(1.5707963267948966, d) : Math.asin(d);
            } else {
                d = Math.acos(d5);
            }
            d2 = Math.atan2(d2, d3);
        }
        dArray2[n2] = this.unrollLongitude(d2);
        dArray2[n2 + 1] = d;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            Orthographic orthographic = (Orthographic)object;
            return InternalUtilities.epsilonEqual((double)this.latitudeOfOrigin, (double)orthographic.latitudeOfOrigin, (ComparisonMode)comparisonMode);
        }
        return false;
    }
}

