/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.projection.Mercator;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class MillerCylindrical
extends MapProjection {
    private static final long serialVersionUID = -7682370461334391883L;
    @Deprecated
    public static final ParameterDescriptor<Double> LONGITUDE_OF_CENTRE;
    @Deprecated
    public static final ParameterDescriptor<Double> LATITUDE_OF_CENTRE;
    @Deprecated
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    @Deprecated
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS;

    public MillerCylindrical() {
        super(PARAMETERS);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return Mercator.create(this.getParameters(), parameterValueGroup);
    }

    static {
        Citation[] citationArray = new Citation[]{Citations.EPSG, Citations.ESRI, Citations.NETCDF};
        LONGITUDE_OF_CENTRE = UniversalParameters.CENTRAL_MERIDIAN.select(citationArray, "longitude_of_center", "ProjCenterLong");
        LATITUDE_OF_CENTRE = UniversalParameters.LATITUDE_OF_ORIGIN.select(false, null, citationArray, null, "latitude_of_center", "ProjCenterLat");
        FALSE_EASTING = UniversalParameters.FALSE_EASTING.select(citationArray, "FalseEasting");
        FALSE_NORTHING = UniversalParameters.FALSE_NORTHING.select(citationArray, "FalseNorthing");
        PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Miller_Cylindrical"), new NamedIdentifier((Citation)Citations.IGNF, "Miller_Cylindrical_Sphere"), new DefaultReferenceIdentifier((Citation)Citations.IGNF, "IGNF", "PRC9901"), new NamedIdentifier(Citations.GEOTIFF, "CT_MillerCylindrical"), new IdentifierCode(Citations.GEOTIFF, 20), new NamedIdentifier((Citation)Citations.PROJ4, "mill")}, citationArray, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LATITUDE_OF_CENTRE, LONGITUDE_OF_CENTRE, FALSE_EASTING, FALSE_NORTHING}, 1);
    }
}

