/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.DeprecatedName;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.EquidistantCylindrical;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class ObliqueMercator
extends MapProjection {
    private static final long serialVersionUID = 201776686002266891L;
    @Deprecated
    public static final ParameterDescriptor<Double> LONGITUDE_OF_CENTRE;
    @Deprecated
    public static final ParameterDescriptor<Double> LATITUDE_OF_CENTRE;
    @Deprecated
    public static final ParameterDescriptor<Double> AZIMUTH;
    @Deprecated
    public static final ParameterDescriptor<Double> RECTIFIED_GRID_ANGLE;
    @Deprecated
    public static final ParameterDescriptor<Double> SCALE_FACTOR;
    @Deprecated
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    @Deprecated
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS;

    public ObliqueMercator() {
        super(PARAMETERS);
    }

    ObliqueMercator(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.ObliqueMercator.create(this.getParameters(), parameterValueGroup);
    }

    static {
        Citation[] citationArray = new Citation[]{Citations.NETCDF};
        LONGITUDE_OF_CENTRE = UniversalParameters.CENTRAL_MERIDIAN.select(citationArray, "Longitude of projection centre", "longitude_of_center", "Longitude_Of_Center", "CenterLong");
        LATITUDE_OF_CENTRE = UniversalParameters.LATITUDE_OF_ORIGIN.select(citationArray, "Latitude of projection centre", "latitude_of_center", "Latitude_Of_Center", "CenterLat");
        AZIMUTH = UniversalParameters.AZIMUTH.select(citationArray, "Azimuth of initial line");
        RECTIFIED_GRID_ANGLE = UniversalParameters.RECTIFIED_GRID_ANGLE;
        SCALE_FACTOR = UniversalParameters.SCALE_FACTOR.select(citationArray, "Scale factor on initial line", "ScaleAtCenter");
        FALSE_EASTING = UniversalParameters.FALSE_EASTING.select(citationArray, "Easting at projection centre", "FalseEasting");
        FALSE_NORTHING = UniversalParameters.FALSE_NORTHING.select(citationArray, "Northing at projection centre", "FalseNorthing");
        PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Oblique_Mercator"), new NamedIdentifier((Citation)Citations.EPSG, "Hotine Oblique Mercator (variant B)"), new NamedIdentifier((Citation)Citations.EPSG, "Rectified Skew Orthomorphic (RSO)"), new DeprecatedName((Citation)Citations.EPSG, "Oblique Mercator"), new IdentifierCode((Citation)Citations.EPSG, 9815), new NamedIdentifier(Citations.ESRI, "Hotine_Oblique_Mercator_Azimuth_Center"), new NamedIdentifier(Citations.ESRI, "Rectified_Skew_Orthomorphic_Center"), new NamedIdentifier(Citations.GEOTIFF, "CT_ObliqueMercator"), new IdentifierCode(Citations.GEOTIFF, 3), new NamedIdentifier((Citation)Citations.PROJ4, "omerc"), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)211))}, null, new ParameterDescriptor[]{ObliqueMercator.sameParameterAs(EquidistantCylindrical.PARAMETERS, "semi_major"), ObliqueMercator.sameParameterAs(EquidistantCylindrical.PARAMETERS, "semi_minor"), ROLL_LONGITUDE, LONGITUDE_OF_CENTRE, LATITUDE_OF_CENTRE, AZIMUTH, RECTIFIED_GRID_ANGLE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING}, 1);
    }

    @Immutable
    public static class TwoPoint
    extends ObliqueMercator {
        private static final long serialVersionUID = 7124258885016543889L;
        @Deprecated
        public static final ParameterDescriptor<Double> LAT_OF_1ST_POINT = UniversalParameters.LAT_OF_1ST_POINT;
        @Deprecated
        public static final ParameterDescriptor<Double> LONG_OF_1ST_POINT = UniversalParameters.LONG_OF_1ST_POINT;
        @Deprecated
        public static final ParameterDescriptor<Double> LAT_OF_2ND_POINT = UniversalParameters.LAT_OF_2ND_POINT;
        @Deprecated
        public static final ParameterDescriptor<Double> LONG_OF_2ND_POINT = UniversalParameters.LONG_OF_2ND_POINT;
        public static final ParameterDescriptorGroup PARAMETERS = UniversalParameters.createDescriptorGroup((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Hotine_Oblique_Mercator_Two_Point_Center"), TwoPoint.sameNameAs(Citations.GEOTOOLKIT, (GeneralParameterDescriptor)PARAMETERS)}, new Citation[]{Citations.EPSG, Citations.OGC, Citations.NETCDF, Citations.GEOTIFF, Citations.PROJ4}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LAT_OF_1ST_POINT, LONG_OF_1ST_POINT, LAT_OF_2ND_POINT, LONG_OF_2ND_POINT, LATITUDE_OF_CENTRE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING}, 1);

        public TwoPoint() {
            super(PARAMETERS);
        }
    }
}

