/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.display.shape.ShapeUtilities;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.Parameterized;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.LenientComparable;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@ThreadSafe
public abstract class AbstractMathTransform
extends FormattableObject
implements MathTransform,
Parameterized,
LenientComparable {
    static final int MAXIMUM_BUFFER_SIZE = 512;
    static final int MAXIMUM_FAILURES = 32;
    private transient int hashCode;

    protected AbstractMathTransform() {
    }

    public String getName() {
        String string;
        ReferenceIdentifier referenceIdentifier;
        ParameterDescriptorGroup parameterDescriptorGroup = this.getParameterDescriptors();
        if (parameterDescriptorGroup != null && (referenceIdentifier = parameterDescriptorGroup.getName()) != null && (string = referenceIdentifier.getCode()) != null) {
            return string;
        }
        return Classes.getShortClassName((Object)this);
    }

    public abstract int getSourceDimensions();

    public abstract int getTargetDimensions();

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return null;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return null;
    }

    public boolean isIdentity() {
        return false;
    }

    static String mismatchedDimension(String string, int n, int n2) {
        return Errors.format((int)113, (Object)string, (Object)n, (Object)n2);
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) throws TransformException {
        int n = this.getSourceDimensions();
        if (n != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.mismatchedDimension("ptSrc", 2, n));
        }
        n = this.getTargetDimensions();
        if (n != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.mismatchedDimension("ptDst", 2, n));
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        this.transform(dArray, 0, dArray, 0, false);
        if (point2D2 != null) {
            point2D2.setLocation(dArray[0], dArray[1]);
            return point2D2;
        }
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        int n = this.getSourceDimensions();
        int n2 = this.getTargetDimensions();
        ArgumentChecks.ensureDimensionMatches((String)"ptSrc", (DirectPosition)directPosition, (int)n);
        if (directPosition2 != null) {
            int n3;
            double[] dArray;
            ArgumentChecks.ensureDimensionMatches((String)"ptDst", (DirectPosition)directPosition2, (int)n2);
            if (n >= n2) {
                dArray = directPosition.getCoordinate();
            } else {
                dArray = new double[n2];
                n3 = n;
                while (--n3 >= 0) {
                    dArray[n3] = directPosition.getOrdinate(n3);
                }
            }
            this.transform(dArray, 0, dArray, 0, false);
            for (n3 = 0; n3 < n2; ++n3) {
                directPosition2.setOrdinate(n3, dArray[n3]);
            }
        } else {
            double[] dArray;
            GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n2);
            if (n <= n2) {
                dArray = generalDirectPosition.ordinates;
                for (int i = 0; i < n; ++i) {
                    dArray[i] = directPosition.getOrdinate(i);
                }
            } else {
                dArray = directPosition.getCoordinate();
            }
            this.transform(dArray, 0, generalDirectPosition.ordinates, 0, false);
            directPosition2 = generalDirectPosition;
        }
        return directPosition2;
    }

    public abstract Matrix transform(double[] var1, int var2, double[] var3, int var4, boolean var5) throws TransformException;

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (n3 <= 0) {
            return;
        }
        double[] dArray3 = null;
        int n4 = 0;
        int n5 = this.getSourceDimensions();
        int n6 = this.getTargetDimensions();
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n5, n2, n6, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n5;
                    n5 = -n5;
                    n2 += (n3 - 1) * n6;
                    n6 = -n6;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n5);
                    n = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    dArray3 = dArray2;
                    dArray2 = new double[n3 * n6];
                    n4 = n2;
                    n2 = 0;
                }
            }
        }
        TransformException transformException = null;
        int n7 = 0;
        int n8 = 0;
        do {
            block14: {
                try {
                    this.transform(dArray, n, dArray2, n2, false);
                }
                catch (TransformException transformException2) {
                    if ((n7 += Math.abs(n5)) > 32) {
                        throw transformException;
                    }
                    Arrays.fill(dArray2, n2, n2 + Math.abs(n6), Double.NaN);
                    if (transformException == null) {
                        transformException = transformException2;
                        n8 = n;
                    }
                    if (Math.abs(n - n8) <= 512) break block14;
                    n7 = 0;
                    n8 = n;
                }
            }
            n += n5;
            n2 += n6;
        } while (--n3 != 0);
        if (dArray3 != null) {
            System.arraycopy(dArray2, 0, dArray3, n4, dArray2.length);
        }
        if (transformException != null) {
            transformException.setLastCompletedTransform((MathTransform)this);
            throw transformException;
        }
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        int n4;
        if (n3 <= 0) {
            return;
        }
        int n5 = this.getSourceDimensions();
        int n6 = this.getTargetDimensions();
        int n7 = Math.max(n5, n6);
        int n8 = n3;
        int n9 = n3 * n7;
        if (n9 > 512) {
            n8 = Math.max(1, 512 / n7);
            n9 = n8 * n7;
        }
        int n10 = n5 * n8;
        int n11 = n6 * n8;
        int n12 = n10;
        int n13 = n11;
        if (fArray == fArray2) {
            n4 = (n3 + n8 - 1) / n8;
            switch (IterationStrategy.suggest(n, n10, n2, n11, n4)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    int n14 = n3 - n8;
                    n += n14 * n5;
                    n2 += n14 * n6;
                    n10 = -n10;
                    n11 = -n11;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n, n + n3 * n5);
                    n = 0;
                }
            }
        }
        n4 = n5 >= n6 ? 0 : n13 - n12;
        double[] dArray = new double[n9];
        TransformException transformException = null;
        do {
            int n15;
            block17: {
                if (n3 < n8) {
                    n8 = n3;
                    n12 = n3 * n5;
                    n13 = n3 * n6;
                    if (n10 < 0) {
                        n -= n12 + n10;
                        n2 -= n13 + n11;
                    }
                }
                for (n15 = 0; n15 < n12; ++n15) {
                    dArray[n4 + n15] = fArray[n + n15];
                }
                assert (!IterationStrategy.suggest((int)n4, (int)n5, (int)0, (int)n6, (int)n8).needBuffer);
                try {
                    this.transform(dArray, n4, dArray, 0, n8);
                }
                catch (TransformException transformException2) {
                    if (transformException2.getLastCompletedTransform() != this) {
                        throw transformException2;
                    }
                    if (transformException != null) break block17;
                    transformException = transformException2;
                }
            }
            for (n15 = 0; n15 < n13; ++n15) {
                fArray2[n2 + n15] = (float)dArray[n15];
            }
            n += n10;
            n2 += n11;
        } while ((n3 -= n8) != 0);
        if (transformException != null) {
            throw transformException;
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        if (n3 <= 0) {
            return;
        }
        int n4 = this.getSourceDimensions();
        int n5 = this.getTargetDimensions();
        int n6 = n3;
        int n7 = n3 * n5;
        if (n7 > 512) {
            n6 = Math.max(1, 512 / n5);
            n7 = n6 * n5;
        }
        int n8 = n6 * n4;
        int n9 = n6 * n5;
        double[] dArray2 = new double[n7];
        TransformException transformException = null;
        do {
            block9: {
                if (n3 < n6) {
                    n6 = n3;
                    n8 = n3 * n4;
                    n9 = n3 * n5;
                }
                try {
                    this.transform(dArray, n, dArray2, 0, n6);
                }
                catch (TransformException transformException2) {
                    if (transformException2.getLastCompletedTransform() != this) {
                        throw transformException2;
                    }
                    if (transformException != null) break block9;
                    transformException = transformException2;
                }
            }
            for (int i = 0; i < n9; ++i) {
                fArray[n2++] = (float)dArray2[i];
            }
            n += n8;
        } while ((n3 -= n6) != 0);
        if (transformException != null) {
            throw transformException;
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        int n4;
        if (n3 <= 0) {
            return;
        }
        int n5 = this.getSourceDimensions();
        if (n5 == (n4 = this.getTargetDimensions())) {
            int n6 = n3 * n5;
            for (int i = 0; i < n6; ++i) {
                dArray[n2 + i] = fArray[n + i];
            }
            this.transform(dArray, n2, dArray, n2, n3);
            return;
        }
        int n7 = n3;
        int n8 = n3 * n5;
        if (n8 > 512) {
            n7 = Math.max(1, 512 / n5);
            n8 = n7 * n5;
        }
        int n9 = n7 * n5;
        int n10 = n7 * n4;
        double[] dArray2 = new double[n8];
        TransformException transformException = null;
        do {
            block11: {
                if (n3 < n7) {
                    n7 = n3;
                    n9 = n3 * n5;
                    n10 = n3 * n4;
                }
                for (int i = 0; i < n9; ++i) {
                    dArray2[i] = fArray[n++];
                }
                try {
                    this.transform(dArray2, 0, dArray, n2, n7);
                }
                catch (TransformException transformException2) {
                    if (transformException2.getLastCompletedTransform() != this) {
                        throw transformException2;
                    }
                    if (transformException != null) break block11;
                    transformException = transformException2;
                }
            }
            n2 += n10;
        } while ((n3 -= n7) != 0);
        if (transformException != null) {
            throw transformException;
        }
    }

    public Shape createTransformedShape(Shape shape) throws TransformException {
        return this.isIdentity() ? shape : this.createTransformedShape(shape, null, null, false);
    }

    final Shape createTransformedShape(Shape shape, AffineTransform affineTransform, AffineTransform affineTransform2, boolean bl) throws TransformException {
        int n = this.getSourceDimensions();
        if (n != 2 || (n = this.getTargetDimensions()) != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.mismatchedDimension("shape", 2, n));
        }
        PathIterator pathIterator = shape.getPathIterator(affineTransform);
        Path2D.Double double_ = new Path2D.Double(pathIterator.getWindingRule());
        Point2D.Double double_2 = new Point2D.Double();
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        while (!pathIterator.isDone()) {
            block13: {
                switch (pathIterator.currentSegment(dArray)) {
                    default: {
                        throw new IllegalPathStateException();
                    }
                    case 4: {
                        double_.closePath();
                        break block13;
                    }
                    case 0: {
                        d = dArray[0];
                        d2 = dArray[1];
                        this.transform(dArray, 0, dArray, 0, 1);
                        d3 = dArray[0];
                        d4 = dArray[1];
                        double_.moveTo(d3, d4);
                        break block13;
                    }
                    case 1: {
                        double d5 = d;
                        d = dArray[0];
                        dArray[0] = 0.5 * (d5 + d);
                        double d6 = d2;
                        d2 = dArray[1];
                        dArray[1] = 0.5 * (d6 + d2);
                        dArray[2] = d;
                        dArray[3] = d2;
                        break;
                    }
                    case 2: {
                        double d7 = d;
                        d = dArray[2];
                        dArray[0] = 0.5 * (dArray[0] + 0.5 * (d7 + d));
                        double d8 = d2;
                        d2 = dArray[3];
                        dArray[1] = 0.5 * (dArray[1] + 0.5 * (d8 + d2));
                        break;
                    }
                    case 3: {
                        double d9 = d;
                        d = dArray[4];
                        dArray[0] = 0.25 * (1.5 * (dArray[0] + dArray[2]) + 0.5 * (d9 + d));
                        double d10 = d2;
                        d2 = dArray[5];
                        dArray[1] = 0.25 * (1.5 * (dArray[1] + dArray[3]) + 0.5 * (d10 + d2));
                        dArray[2] = d;
                        dArray[3] = d2;
                    }
                }
                this.transform(dArray, 0, dArray, 0, 2);
                Point2D point2D = ShapeUtilities.parabolicControlPoint(d3, d4, dArray[0], dArray[1], dArray[2], dArray[3], bl, double_2);
                d3 = dArray[2];
                d4 = dArray[3];
                if (point2D != null) {
                    assert (double_2 == point2D);
                    double_.quadTo(double_2.x, double_2.y, d3, d4);
                } else {
                    double_.lineTo(d3, d4);
                }
            }
            pathIterator.next();
        }
        if (affineTransform2 != null) {
            double_.transform(affineTransform2);
        }
        return ShapeUtilities.toPrimitive(double_);
    }

    public Matrix derivative(Point2D point2D) throws TransformException {
        int n = this.getSourceDimensions();
        if (n != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.mismatchedDimension("point", 2, n));
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        Matrix matrix = this.transform(dArray, 0, null, 0, true);
        if (matrix == null) {
            throw new TransformException(Errors.format((int)21));
        }
        return matrix;
    }

    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        int n = this.getSourceDimensions();
        double[] dArray = directPosition.getCoordinate();
        if (dArray.length != n) {
            throw new MismatchedDimensionException(AbstractMathTransform.mismatchedDimension("point", dArray.length, n));
        }
        Matrix matrix = this.transform(dArray, 0, null, 0, true);
        if (matrix == null) {
            throw new TransformException(Errors.format((int)21));
        }
        return matrix;
    }

    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.isIdentity()) {
            return this;
        }
        throw new NoninvertibleTransformException(Errors.format((int)126));
    }

    MathTransform concatenate(MathTransform mathTransform, boolean bl) {
        return null;
    }

    public final int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = this.computeHashCode();
            if (n == 0) {
                n = -1;
            }
            this.hashCode = n;
        }
        assert (n == -1 || n == this.computeHashCode()) : this;
        return n;
    }

    protected int computeHashCode() {
        return Utilities.hash(this.getClass(), (int)Utilities.hash((int)this.getSourceDimensions(), (int)this.getTargetDimensions()));
    }

    public final boolean equals(Object object) {
        boolean bl = this.equals(object, ComparisonMode.STRICT);
        assert (!bl || this.hashCode() == object.hashCode()) : this;
        return bl;
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object != null && this.getClass() == object.getClass()) {
            int n;
            int n2;
            AbstractMathTransform abstractMathTransform = (AbstractMathTransform)object;
            if (comparisonMode.ordinal() < ComparisonMode.APPROXIMATIVE.ordinal() && (n2 = this.hashCode) != 0 && (n = abstractMathTransform.hashCode) != 0 && n2 != n) {
                return false;
            }
            if (comparisonMode.ordinal() >= ComparisonMode.IGNORE_METADATA.ordinal()) {
                return true;
            }
            return Utilities.deepEquals((Object)this.getParameterDescriptors(), (Object)abstractMathTransform.getParameterDescriptors(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    static boolean equals(LinearTransform linearTransform, Object object, ComparisonMode comparisonMode) {
        Matrix matrix;
        if (object instanceof LinearTransform && (matrix = linearTransform.getMatrix()) != null) {
            Matrix matrix2 = ((LinearTransform)object).getMatrix();
            if (matrix instanceof LenientComparable) {
                return ((LenientComparable)matrix).equals((Object)matrix2, comparisonMode);
            }
            return Matrices.equals(matrix, matrix2, comparisonMode);
        }
        return false;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        ParameterValueGroup parameterValueGroup = this.getParameterValues();
        if (parameterValueGroup != null) {
            formatter.append(formatter.getName((IdentifiedObject)parameterValueGroup.getDescriptor()));
            formatter.append((GeneralParameterValue)parameterValueGroup);
        }
        return "PARAM_MT";
    }

    int beforeFormat(List<Object> list, int n, boolean bl) {
        return n;
    }

    protected static void ensureNonNull(String string, Object object) throws InvalidParameterValueException {
        if (object == null) {
            throw new InvalidParameterValueException(Errors.format((int)172, (Object)string), string, object);
        }
    }

    protected static double rollLongitude(double d, double d2) {
        long l = (long)(d / d2);
        if (l != 0L) {
            if (l < 0L) {
                if ((l &= 0xFFFFFFFFFFFFFFFEL) == -2L && d == -d2) {
                    return d;
                }
            } else if ((l & 1L) != 0L) {
                ++l;
            }
            d -= (double)l * d2;
        }
        return d;
    }

    protected abstract class Inverse
    extends AbstractMathTransform
    implements Serializable {
        private static final long serialVersionUID = 3528274816628012283L;

        protected Inverse() {
        }

        @Override
        public String getName() {
            return AbstractMathTransform.this.getName() + " (" + Vocabulary.format((int)164) + ')';
        }

        @Override
        public int getSourceDimensions() {
            return AbstractMathTransform.this.getTargetDimensions();
        }

        @Override
        public int getTargetDimensions() {
            return AbstractMathTransform.this.getSourceDimensions();
        }

        @Override
        public Matrix derivative(Point2D point2D) throws TransformException {
            return Matrices.invert(AbstractMathTransform.this.derivative(this.transform(point2D, null)));
        }

        @Override
        public Matrix derivative(DirectPosition directPosition) throws TransformException {
            return Matrices.invert(AbstractMathTransform.this.derivative(this.transform(directPosition, null)));
        }

        private AbstractMathTransform enclosing() {
            return AbstractMathTransform.this;
        }

        @Override
        public MathTransform inverse() {
            return AbstractMathTransform.this;
        }

        @Override
        public boolean isIdentity() {
            return AbstractMathTransform.this.isIdentity();
        }

        @Override
        protected int computeHashCode() {
            return Utilities.hash((int)AbstractMathTransform.this.hashCode(), (int)super.computeHashCode());
        }

        @Override
        public boolean equals(Object object, ComparisonMode comparisonMode) {
            if (object == this) {
                return true;
            }
            if (object != null && object.getClass() == this.getClass()) {
                Inverse inverse = (Inverse)object;
                return AbstractMathTransform.this.equals(inverse.enclosing(), comparisonMode);
            }
            return false;
        }

        @Override
        public String formatWKT(Formatter formatter) {
            ParameterValueGroup parameterValueGroup = this.getParameterValues();
            if (parameterValueGroup != null) {
                formatter.append(formatter.getName((IdentifiedObject)parameterValueGroup.getDescriptor()));
                formatter.append((GeneralParameterValue)parameterValueGroup);
                return "PARAM_MT";
            }
            formatter.append(AbstractMathTransform.this);
            return "INVERSE_MT";
        }
    }
}

