/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.DirectPositionView;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.Matrix3;
import org.geotoolkit.referencing.operation.provider.EllipsoidToGeocentric;
import org.geotoolkit.referencing.operation.provider.GeocentricToEllipsoid;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.EllipsoidalTransform;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

@Immutable
public class GeocentricTransform
extends AbstractMathTransform
implements EllipsoidalTransform,
Serializable {
    private static final long serialVersionUID = -3352045463953828140L;
    private static final double MAX_ERROR = 0.01;
    private static final double COS_67P5 = 0.3826834323650898;
    private static final double AD_C = 1.0026;
    private final double a;
    private final double b;
    private final double a2;
    private final double b2;
    private final double e2;
    private final double ep2;
    final boolean hasHeight;
    private transient EllipsoidalTransform inverse;
    private transient GeocentricTransform variant;

    protected GeocentricTransform(double d, double d2, Unit<Length> unit, boolean bl) {
        this.hasHeight = bl;
        UnitConverter unitConverter = unit.getConverterTo((Unit)SI.METRE);
        this.a = unitConverter.convert(d);
        this.b = unitConverter.convert(d2);
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
        this.e2 = (this.a2 - this.b2) / this.a2;
        this.ep2 = (this.a2 - this.b2) / this.b2;
        ArgumentChecks.ensureBetween((String)"a", (double)0.0, (double)Double.MAX_VALUE, (double)this.a);
        ArgumentChecks.ensureBetween((String)"b", (double)0.0, (double)this.a, (double)this.b);
    }

    protected GeocentricTransform(GeocentricTransform geocentricTransform, boolean bl) {
        this.hasHeight = bl;
        this.a = geocentricTransform.a;
        this.b = geocentricTransform.b;
        this.a2 = geocentricTransform.a2;
        this.b2 = geocentricTransform.b2;
        this.e2 = geocentricTransform.e2;
        this.ep2 = geocentricTransform.ep2;
    }

    public static MathTransform create(Ellipsoid ellipsoid, boolean bl) {
        return GeocentricTransform.create(ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMinorAxis(), (Unit<Length>)ellipsoid.getAxisUnit(), bl);
    }

    public static MathTransform create(double d, double d2, Unit<Length> unit, boolean bl) {
        return new GeocentricTransform(d, d2, unit, bl);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return EllipsoidToGeocentric.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.getParameterValues(this.getParameterDescriptors());
    }

    final ParameterValueGroup getParameterValues(ParameterDescriptorGroup parameterDescriptorGroup) {
        ParameterValue[] parameterValueArray = new ParameterValue[this.hasHeight ? 2 : 3];
        int n = 0;
        if (!this.hasHeight) {
            Parameter<Integer> parameter = new Parameter<Integer>(EllipsoidToGeocentric.DIM);
            parameter.setValue(2);
            parameterValueArray[n++] = parameter;
        }
        parameterValueArray[n++] = new FloatParameter(EllipsoidToGeocentric.SEMI_MAJOR, this.a);
        parameterValueArray[n++] = new FloatParameter(EllipsoidToGeocentric.SEMI_MINOR, this.b);
        return new ParameterGroup(parameterDescriptorGroup, (GeneralParameterValue[])parameterValueArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeocentricTransform forDimensions(boolean bl, boolean bl2) throws IllegalArgumentException {
        GeocentricTransform geocentricTransform;
        if (!bl2) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"target3D", (Object)bl2));
        }
        if (bl == this.hasHeight) {
            return this;
        }
        GeocentricTransform geocentricTransform2 = this;
        synchronized (geocentricTransform2) {
            geocentricTransform = this.variant;
            if (geocentricTransform == null) {
                geocentricTransform = new GeocentricTransform(this, bl);
                geocentricTransform.variant = this;
                this.variant = geocentricTransform;
            }
        }
        return geocentricTransform;
    }

    @Override
    public final int getSourceDimensions() {
        return this.hasHeight ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 3;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        Matrix matrix = null;
        if (bl) {
            matrix = this.derivative(Math.toRadians(dArray[n]), Math.toRadians(dArray[n + 1]), this.hasHeight ? dArray[n + 2] : 0.0, this.hasHeight);
        }
        if (dArray2 != null) {
            this.transform(dArray, n, dArray2, n2, 1, this.hasHeight);
        }
        return matrix;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(dArray, n, dArray2, n2, n3, this.hasHeight);
    }

    private void transform(double[] dArray, int n, double[] dArray2, int n2, int n3, boolean bl) {
        int n4 = bl ? 3 : 2;
        int n5 = 0;
        int n6 = 0;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n4, n2, 3, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n4;
                    n2 += (n3 - 1) * 3;
                    n5 = -2 * n4;
                    n6 = -6;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n4);
                    n = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d = Math.toRadians(dArray[n++]);
            double d2 = Math.toRadians(dArray[n++]);
            double d3 = bl ? dArray[n++] : 0.0;
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d2);
            double d6 = this.a / Math.sqrt(1.0 - this.e2 * (d5 * d5));
            double d7 = (d6 + d3) * d4;
            dArray2[n2++] = d7 * Math.cos(d);
            dArray2[n2++] = d7 * Math.sin(d);
            dArray2[n2++] = (d6 * (1.0 - this.e2) + d3) * d5;
            n += n5;
            n2 += n6;
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4 = this.getSourceDimensions();
        int n5 = 0;
        int n6 = 0;
        if (fArray == fArray2) {
            switch (IterationStrategy.suggest(n, n4, n2, 3, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n4;
                    n2 += (n3 - 1) * 3;
                    n5 = -2 * n4;
                    n6 = -6;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n, n + n3 * n4);
                    n = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d = Math.toRadians(fArray[n++]);
            double d2 = Math.toRadians(fArray[n++]);
            double d3 = this.hasHeight ? (double)fArray[n++] : 0.0;
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d2);
            double d6 = this.a / Math.sqrt(1.0 - this.e2 * (d5 * d5));
            double d7 = (d6 + d3) * d4;
            fArray2[n2++] = (float)(d7 * Math.cos(d));
            fArray2[n2++] = (float)(d7 * Math.sin(d));
            fArray2[n2++] = (float)((d6 * (1.0 - this.e2) + d3) * d5);
            n += n5;
            n2 += n6;
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            double d = Math.toRadians(fArray[n++]);
            double d2 = Math.toRadians(fArray[n++]);
            double d3 = this.hasHeight ? (double)fArray[n++] : 0.0;
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d2);
            double d6 = this.a / Math.sqrt(1.0 - this.e2 * (d5 * d5));
            double d7 = (d6 + d3) * d4;
            dArray[n2++] = d7 * Math.cos(d);
            dArray[n2++] = d7 * Math.sin(d);
            dArray[n2++] = (d6 * (1.0 - this.e2) + d3) * d5;
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            double d = Math.toRadians(dArray[n++]);
            double d2 = Math.toRadians(dArray[n++]);
            double d3 = this.hasHeight ? dArray[n++] : 0.0;
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d2);
            double d6 = this.a / Math.sqrt(1.0 - this.e2 * (d5 * d5));
            double d7 = (d6 + d3) * d4;
            fArray[n2++] = (float)(d7 * Math.cos(d));
            fArray[n2++] = (float)(d7 * Math.sin(d));
            fArray[n2++] = (float)((d6 * (1.0 - this.e2) + d3) * d5);
        }
    }

    final void inverseTransform(float[] fArray, double[] dArray, int n, float[] fArray2, double[] dArray2, int n2, int n3, boolean bl, boolean bl2) {
        boolean bl3 = bl;
        if (!$assertionsDisabled) {
            bl3 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl2) {
            int n4 = (n3 - 1) * 3;
            n += n4;
            n2 += n4;
            if (!bl3) {
                n2 -= n3 - 1;
            }
        }
        while (--n3 >= 0) {
            double d;
            double d2;
            double d3;
            if (dArray != null) {
                d3 = dArray[n++];
                d2 = dArray[n++];
                d = dArray[n++];
            } else {
                d3 = fArray[n++];
                d2 = fArray[n++];
                d = fArray[n++];
            }
            double d4 = Math.hypot(d3, d2);
            double d5 = d * 1.0026;
            double d6 = Math.hypot(d5, d4);
            double d7 = d5 / d6;
            double d8 = d4 / d6;
            double d9 = d7 * d7 * d7;
            double d10 = d + this.b * this.ep2 * d9;
            double d11 = d4 - this.a * this.e2 * (d8 * d8 * d8);
            double d12 = Math.hypot(d10, d11);
            double d13 = d10 / d12;
            double d14 = d11 / d12;
            double d15 = Math.toDegrees(Math.atan2(d2, d3));
            double d16 = Math.toDegrees(Math.atan(d13 / d14));
            if (dArray2 != null) {
                dArray2[n2++] = d15;
                dArray2[n2++] = d16;
            } else {
                fArray2[n2++] = (float)d15;
                fArray2[n2++] = (float)d16;
            }
            if (bl3) {
                double d17;
                double d18 = this.a / Math.sqrt(1.0 - this.e2 * (d13 * d13));
                double d19 = d14 >= 0.3826834323650898 ? d4 / d14 - d18 : (d14 <= -0.3826834323650898 ? d4 / -d14 - d18 : d / d13 + d18 * (this.e2 - 1.0));
                if (bl) {
                    if (dArray2 != null) {
                        dArray2[n2++] = d19;
                    } else {
                        fArray2[n2++] = (float)d19;
                    }
                }
                assert (0.01 > (d17 = this.checkTransform(d3, d2, d, d15, d16, d19))) : d17;
            }
            if (!bl2) continue;
            n -= 6;
            n2 -= bl3 ? 6 : 4;
        }
    }

    private double checkTransform(double ... dArray) {
        this.transform(dArray, 3, dArray, 3, 1, true);
        double d = dArray[0] - dArray[3];
        double d2 = dArray[1] - dArray[4];
        double d3 = dArray[2] - dArray[5];
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        ArgumentChecks.ensureDimensionMatches((String)"point", (DirectPosition)directPosition, (int)(this.hasHeight ? 3 : 2));
        return this.derivative(Math.toRadians(directPosition.getOrdinate(0)), Math.toRadians(directPosition.getOrdinate(1)), this.hasHeight ? directPosition.getOrdinate(2) : 0.0, this.hasHeight);
    }

    final Matrix derivative(double d, double d2, double d3, boolean bl) {
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        double d6 = Math.cos(d2);
        double d7 = Math.sin(d2);
        double d8 = 1.0 - this.e2 * (d7 * d7);
        double d9 = this.a / Math.sqrt(d8);
        double d10 = Math.toRadians(d9 + d3);
        double d11 = Math.toRadians((1.0 - this.e2) * (d9 / d8) + d3);
        double d12 = -d10 * (d6 * d5);
        double d13 = -d11 * (d7 * d4);
        double d14 = d10 * (d6 * d4);
        double d15 = -d11 * (d7 * d5);
        double d16 = d11 * d6;
        if (bl) {
            return new Matrix3(d12, d13, d6 * d4, d14, d15, d6 * d5, 0.0, d16, d7);
        }
        return new GeneralMatrix(3, 2, new double[]{d12, d13, d14, d15, 0.0, d16});
    }

    @Override
    public synchronized EllipsoidalTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        int n = Utilities.hash((double)this.a, (int)Utilities.hash((double)this.b, (int)Utilities.hash((double)this.a2, (int)Utilities.hash((double)this.b2, (int)Utilities.hash((double)this.e2, (int)Utilities.hash((double)this.ep2, (int)super.computeHashCode()))))));
        if (this.hasHeight) {
            n += 37;
        }
        return n;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            GeocentricTransform geocentricTransform = (GeocentricTransform)object;
            return this.hasHeight == geocentricTransform.hasHeight && Utilities.equals((double)this.a, (double)geocentricTransform.a) && Utilities.equals((double)this.b, (double)geocentricTransform.b) && Utilities.equals((double)this.a2, (double)geocentricTransform.a2) && Utilities.equals((double)this.b2, (double)geocentricTransform.b2) && Utilities.equals((double)this.e2, (double)geocentricTransform.e2) && Utilities.equals((double)this.ep2, (double)geocentricTransform.ep2);
        }
        return false;
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements EllipsoidalTransform,
    Serializable {
        private static final long serialVersionUID = 6942084702259211803L;

        @Override
        public EllipsoidalTransform forDimensions(boolean bl, boolean bl2) throws IllegalArgumentException {
            if (!bl) {
                throw new IllegalArgumentException(Errors.format((int)73, (Object)"source3D", (Object)bl));
            }
            if (bl2 == GeocentricTransform.this.hasHeight) {
                return this;
            }
            return GeocentricTransform.this.forDimensions(bl2, bl).inverse();
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return GeocentricToEllipsoid.PARAMETERS;
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return GeocentricTransform.this.getParameterValues(this.getParameterDescriptors());
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            Matrix matrix = bl ? this.derivative(new DirectPositionView(dArray, n, this.getSourceDimensions())) : null;
            GeocentricTransform.this.inverseTransform(null, dArray, n, null, dArray2, n2, 1, GeocentricTransform.this.hasHeight, false);
            return matrix;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            boolean bl = false;
            if (dArray == dArray2) {
                switch (IterationStrategy.suggest(n, this.getSourceDimensions(), n2, this.getTargetDimensions(), n3)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        bl = true;
                        break;
                    }
                    default: {
                        dArray = Arrays.copyOfRange(dArray, n, n + 3 * n3);
                        n = 0;
                    }
                }
            }
            GeocentricTransform.this.inverseTransform(null, dArray, n, null, dArray2, n2, n3, GeocentricTransform.this.hasHeight, bl);
        }

        @Override
        public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
            boolean bl = false;
            if (fArray == fArray2) {
                switch (IterationStrategy.suggest(n, this.getSourceDimensions(), n2, this.getTargetDimensions(), n3)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        bl = true;
                        break;
                    }
                    default: {
                        fArray = Arrays.copyOfRange(fArray, n, n + 3 * n3);
                        n = 0;
                    }
                }
            }
            GeocentricTransform.this.inverseTransform(fArray, null, n, fArray2, null, n2, n3, GeocentricTransform.this.hasHeight, bl);
        }

        @Override
        public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
            GeocentricTransform.this.inverseTransform(fArray, null, n, null, dArray, n2, n3, GeocentricTransform.this.hasHeight, false);
        }

        @Override
        public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
            GeocentricTransform.this.inverseTransform(null, dArray, n, fArray, null, n2, n3, GeocentricTransform.this.hasHeight, false);
        }

        @Override
        public Matrix derivative(DirectPosition directPosition) throws TransformException {
            if (GeocentricTransform.this.hasHeight) {
                return super.derivative(directPosition);
            }
            double[] dArray = directPosition.getCoordinate();
            if (dArray.length != 3) {
                throw new MismatchedDimensionException(Inverse.mismatchedDimension("point", dArray.length, 3));
            }
            GeocentricTransform.this.inverseTransform(null, dArray, 0, null, dArray, 0, 1, true, false);
            Matrix matrix = Matrices.invert(GeocentricTransform.this.derivative(Math.toRadians(dArray[0]), Math.toRadians(dArray[1]), dArray[2], true));
            assert (matrix.getNumCol() == 3 && matrix.getNumRow() == 3);
            double[] dArray2 = new double[6];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = matrix.getElement(i / 3, i % 3);
            }
            matrix = new GeneralMatrix(2, 3, dArray2);
            return matrix;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            GeocentricTransform.this.inverse = this;
        }
    }
}

