/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBuffer;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.DirectPositionView;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.GridTransform;
import org.geotoolkit.referencing.operation.transform.GridType;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@Immutable
public class GridTransform2D
extends GridTransform
implements MathTransform2D {
    private static final long serialVersionUID = -5797129125459758798L;
    private transient MathTransform2D inverse;

    protected GridTransform2D(GridType gridType, DataBuffer dataBuffer, Dimension dimension, Rectangle2D rectangle2D) {
        super(gridType, dataBuffer, dimension, rectangle2D);
        int n = dataBuffer.getNumBanks();
        if (n != 2) {
            throw new MismatchedDimensionException(Errors.format((int)113, (Object)"grid", (Object)n, (Object)2));
        }
    }

    public synchronized MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            switch (this.type) {
                case LOCALIZATION: {
                    this.inverse = (MathTransform2D)super.inverse();
                    break;
                }
                default: {
                    this.inverse = new Inverse();
                }
            }
        }
        return this.inverse;
    }

    @Immutable
    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D {
        private static final long serialVersionUID = -6779719408779847014L;
        private static final double ITERATION_TOLERANCE = 5.0E-10;
        private static final int MAXIMUM_ITERATIONS = 10;

        Inverse() {
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            double d;
            double d2;
            Matrix matrix = null;
            if (bl) {
                matrix = this.derivative(new DirectPositionView(dArray, n, this.getSourceDimensions()));
            }
            if (dArray2 == null) {
                return matrix;
            }
            double d3 = d2 = dArray[n];
            dArray2[n2] = d2;
            double d4 = d = dArray[n + 1];
            dArray2[n2 + 1] = d;
            int n3 = 10;
            do {
                GridTransform2D.this.transform(dArray2, n2, dArray2, n2, false);
                double d5 = dArray2[n2] - d2;
                double d6 = dArray2[n2 + 1] - d;
                dArray2[n2] = d3 -= d5;
                dArray2[n2 + 1] = d4 -= d6;
                if (!(Math.abs(d5) <= 5.0E-10) || !(Math.abs(d6) <= 5.0E-10)) continue;
                return matrix;
            } while (--n3 >= 0);
            throw new TransformException(Errors.format((int)152));
        }

        public MathTransform2D inverse() {
            return GridTransform2D.this;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            GridTransform2D.this.inverse = this;
        }
    }
}

