/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.provider.Affine;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

@Deprecated
@Immutable
public class IdentityTransform
extends AbstractMathTransform
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -5339040282922138164L;
    private final int dimension;

    protected IdentityTransform(int n) {
        this.dimension = n;
    }

    @Deprecated
    public static LinearTransform create(int n) {
        return MathTransforms.identity(n);
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public boolean isIdentity(double d) {
        return true;
    }

    @Override
    public int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    @Override
    public Matrix getMatrix() {
        return Matrices.create(this.dimension + 1);
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        return Matrices.create(this.dimension);
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) {
        ArgumentChecks.ensureDimensionMatches((String)"ptSrc", (DirectPosition)directPosition, (int)this.dimension);
        if (directPosition2 == null) {
            return new GeneralDirectPosition(directPosition);
        }
        ArgumentChecks.ensureDimensionMatches((String)"ptDst", (DirectPosition)directPosition2, (int)this.dimension);
        for (int i = 0; i < this.dimension; ++i) {
            directPosition2.setOrdinate(i, directPosition.getOrdinate(i));
        }
        return directPosition2;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        if (dArray2 != null) {
            System.arraycopy(dArray, n, dArray2, n2, this.dimension);
        }
        return bl ? this.derivative((DirectPosition)null) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        System.arraycopy(dArray, n, dArray2, n2, n3 * this.dimension);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        System.arraycopy(fArray, n, fArray2, n2, n3 * this.dimension);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        n3 *= this.dimension;
        while (--n3 >= 0) {
            fArray[n2++] = (float)dArray[n++];
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        n3 *= this.dimension;
        while (--n3 >= 0) {
            dArray[n2++] = fArray[n++];
        }
    }

    @Override
    public MathTransform inverse() {
        return this;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (comparisonMode != ComparisonMode.STRICT) {
            return IdentityTransform.equals(this, object, comparisonMode);
        }
        if (super.equals(object, comparisonMode)) {
            IdentityTransform identityTransform = (IdentityTransform)object;
            return this.dimension == identityTransform.dimension;
        }
        return false;
    }
}

