/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.geotoolkit.console.Action;
import org.geotoolkit.console.CommandLine;
import org.geotoolkit.console.Option;
import org.geotoolkit.io.IndentedLineWriter;
import org.geotoolkit.io.LineWrapWriter;
import org.geotoolkit.io.LineWriter;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.io.X364;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.IndexedResourceBundle;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.Numbers;

final class HelpAction {
    private final CommandLine cmd;
    private final PrintWriter out;
    private final int lineLength;
    private final String lineSeparator;
    private final StringBuilder buffer;
    private String examples;

    HelpAction(CommandLine commandLine) {
        this.cmd = commandLine;
        this.out = commandLine.out;
        this.lineSeparator = System.getProperty("line.separator", "\n");
        int n = 80;
        String string = null;
        try {
            string = System.getenv("COLUMNS");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.lineLength = n;
        this.buffer = new StringBuilder();
    }

    void help(String string) {
        ResourceBundle resourceBundle;
        Locale locale = this.cmd.locale;
        this.out.println(this.cmd.bold(Descriptions.getResources(locale).getString(3, string)));
        this.out.println();
        LineWriter lineWriter = new LineWriter(this.out, this.lineSeparator);
        TableWriter tableWriter = new TableWriter((Writer)lineWriter, "");
        tableWriter.setMultiLinesCells(true);
        TreeMap<String, AbstractMap.SimpleEntry<String, Object>> treeMap = new TreeMap<String, AbstractMap.SimpleEntry<String, Object>>();
        TreeMap<String, AbstractMap.SimpleEntry<String, String>> treeMap2 = new TreeMap<String, AbstractMap.SimpleEntry<String, String>>();
        boolean bl = false;
        String string2 = null;
        Class<?> clazz = this.cmd.getClass();
        do {
            Class<?> clazz2;
            String string3;
            String string4;
            Annotation annotation;
            resourceBundle = ResourceBundle.getBundle(clazz.getName(), locale);
            if (!bl) {
                try {
                    LineWrapWriter lineWrapWriter = new LineWrapWriter(lineWriter, this.lineLength);
                    lineWrapWriter.write(this.getString(resourceBundle, "Description"));
                    lineWrapWriter.write(this.lineSeparator);
                    lineWrapWriter.write(this.lineSeparator);
                    bl = true;
                }
                catch (IOException iOException) {
                    this.cmd.printException(iOException);
                    this.cmd.exit(100);
                    return;
                }
            }
            for (Method method : clazz.getDeclaredMethods()) {
                annotation = method.getAnnotation(Action.class);
                if (annotation == null) continue;
                string4 = annotation.name().trim();
                if (string4.isEmpty()) {
                    string4 = method.getName();
                }
                if (treeMap.containsKey(string4)) continue;
                string3 = string4;
                this.buffer.setLength(0);
                this.color(X364.BOLD);
                this.color(X364.FOREGROUND_GREEN);
                this.buffer.append(string3);
                this.color(X364.RESET);
                string3 = this.buffer.toString();
                clazz2 = this.description(resourceBundle, string4, annotation.examples());
                treeMap.put(string4, new AbstractMap.SimpleEntry<String, Object>(string3, clazz2));
            }
            for (Field field : clazz.getDeclaredFields()) {
                annotation = field.getAnnotation(Option.class);
                if (annotation == null) continue;
                string4 = annotation.name().trim();
                if (string4.isEmpty()) {
                    string4 = field.getName();
                }
                if (treeMap2.containsKey(string4)) continue;
                string3 = string4;
                this.buffer.setLength(0);
                this.color(X364.BOLD);
                this.color(X364.FOREGROUND_GREEN);
                this.buffer.append("--").append(string3);
                this.color(X364.NORMAL);
                clazz2 = field.getType();
                if (!Boolean.TYPE.isAssignableFrom(clazz2)) {
                    clazz2 = Numbers.primitiveToWrapper(clazz2);
                    this.buffer.append('=');
                    if (Boolean.class.isAssignableFrom(clazz2)) {
                        this.buffer.append("on|off");
                    } else {
                        this.buffer.append(Number.class.isAssignableFrom(clazz2) ? (char)'N' : 'S');
                    }
                }
                this.color(X364.FOREGROUND_DEFAULT);
                if (annotation.mandatory()) {
                    if (string2 == null) {
                        string2 = Vocabulary.getResources(locale).getString(187).toLowerCase(locale);
                    }
                    this.buffer.append("\n  ");
                    this.color(X364.FOREGROUND_GREEN);
                    this.buffer.append('(').append(string2).append(')');
                    this.color(X364.FOREGROUND_DEFAULT);
                }
                string3 = this.buffer.toString();
                String string5 = this.description(resourceBundle, string4, annotation.examples());
                treeMap2.put(string4, new AbstractMap.SimpleEntry<String, String>(string3, string5));
            }
        } while (CommandLine.class.isAssignableFrom(clazz = clazz.getSuperclass()));
        resourceBundle = Vocabulary.getResources(locale);
        try {
            if (!treeMap.isEmpty()) {
                this.print(tableWriter, ((IndexedResourceBundle)resourceBundle).getLabel(38), treeMap.values());
            }
            if (!treeMap2.isEmpty()) {
                this.print(tableWriter, ((IndexedResourceBundle)resourceBundle).getLabel(216), treeMap2.values());
            }
            tableWriter.flush();
        }
        catch (IOException iOException) {
            this.cmd.printException(iOException);
            this.cmd.exit(100);
            return;
        }
        this.examples(string);
    }

    private String description(ResourceBundle resourceBundle, String string, String[] stringArray) {
        String string2 = this.getString(resourceBundle, string);
        if (stringArray.length != 0) {
            this.buffer.setLength(0);
            this.buffer.append(string2).append(this.lineSeparator);
            this.color(X364.FAINT);
            this.buffer.append(this.examplesLabel()).append('\"');
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    this.buffer.append("\", \"");
                }
                this.buffer.append(stringArray[i]);
            }
            this.buffer.append("\".");
            this.color(X364.NORMAL);
            string2 = this.buffer.toString();
        }
        return string2;
    }

    private String getString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            this.buffer.setLength(0);
            this.color(X364.BACKGROUND_RED);
            this.buffer.append(missingResourceException.getLocalizedMessage());
            this.color(X364.BACKGROUND_DEFAULT);
            return this.buffer.toString();
        }
    }

    final void color(X364 x364) {
        this.cmd.color(this.buffer, x364);
    }

    private void print(TableWriter tableWriter, String string, Collection<Map.Entry<String, String>> collection) throws IOException {
        string = this.cmd.bold(string.trim());
        tableWriter.write(string);
        tableWriter.nextLine();
        tableWriter.write(this.lineSeparator);
        tableWriter.nextLine();
        LineWrapWriter lineWrapWriter = new LineWrapWriter(tableWriter, this.lineLength - 18);
        for (Map.Entry<String, String> entry : collection) {
            tableWriter.write("  ");
            tableWriter.write(entry.getKey());
            tableWriter.write(32);
            tableWriter.nextColumn();
            lineWrapWriter.write(entry.getValue());
            lineWrapWriter.write(this.lineSeparator);
            tableWriter.nextLine();
            tableWriter.write(this.lineSeparator);
            tableWriter.nextLine();
        }
    }

    private String examplesLabel() {
        if (this.examples == null) {
            this.examples = Vocabulary.getResources(this.cmd.locale).getLabel(102);
        }
        return this.examples;
    }

    private void examples(String string) {
        Map<String, String> map = this.cmd.examples();
        if (XCollections.isNullOrEmpty(map)) {
            return;
        }
        ArrayList<ResourceBundle> arrayList = new ArrayList<ResourceBundle>();
        MissingResourceException missingResourceException = null;
        Object object = this.cmd.getClass();
        while (CommandLine.class.isAssignableFrom((Class<?>)object)) {
            block12: {
                try {
                    arrayList.add(ResourceBundle.getBundle(((Class)object).getName(), this.cmd.locale));
                }
                catch (MissingResourceException missingResourceException2) {
                    if (missingResourceException != null) break block12;
                    missingResourceException = missingResourceException2;
                }
            }
            object = ((Class)object).getSuperclass();
        }
        if (arrayList.isEmpty()) {
            this.cmd.printException(missingResourceException);
            return;
        }
        this.out.println(this.cmd.bold(this.examplesLabel().trim()));
        object = new IndentedLineWriter(this.out, 4);
        LineWrapWriter lineWrapWriter = new LineWrapWriter((Writer)object, this.lineLength - 4);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = null;
            for (ResourceBundle resourceBundle : arrayList) {
                try {
                    string3 = resourceBundle.getString(string2);
                    break;
                }
                catch (MissingResourceException missingResourceException3) {
                }
            }
            if (string3 == null) {
                string3 = this.getString((ResourceBundle)arrayList.get(0), string2);
            }
            this.buffer.setLength(0);
            this.color(X364.FOREGROUND_GREEN);
            this.buffer.append(string).append(' ').append(this.cmd.bold(entry.getValue()));
            this.color(X364.FOREGROUND_DEFAULT);
            try {
                ((Writer)object).write(this.lineSeparator);
                ((Writer)object).write(this.buffer.toString());
                ((Writer)object).write(this.lineSeparator);
                lineWrapWriter.write(string3);
                lineWrapWriter.write(this.lineSeparator);
            }
            catch (IOException iOException) {
                this.cmd.printException(iOException);
                this.cmd.exit(100);
                return;
            }
        }
    }
}

