/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.FactoryRegistry;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

@ThreadSafe
public final class AuthorityFactoryFinder
extends FactoryFinder {
    static Set<String> authorityNames;

    private AuthorityFactoryFinder() {
    }

    public static synchronized Set<String> getAuthorityNames() {
        if (authorityNames == null) {
            authorityNames = new LinkedHashSet<String>();
            Hints hints = Factory.EMPTY_HINTS;
            int n = 0;
            block6: while (true) {
                Set<CRSAuthorityFactory> set;
                switch (n) {
                    case 0: {
                        set = AuthorityFactoryFinder.getCRSAuthorityFactories(hints);
                        break;
                    }
                    case 1: {
                        set = AuthorityFactoryFinder.getCSAuthorityFactories(hints);
                        break;
                    }
                    case 2: {
                        set = AuthorityFactoryFinder.getDatumAuthorityFactories(hints);
                        break;
                    }
                    case 3: {
                        set = AuthorityFactoryFinder.getCoordinateOperationAuthorityFactories(hints);
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                for (AuthorityFactory authorityFactory : set) {
                    Citation citation = authorityFactory.getAuthority();
                    if (citation == null) continue;
                    authorityNames.add(Citations.getIdentifier(citation));
                    for (Identifier identifier : citation.getIdentifiers()) {
                        authorityNames.add(identifier.getCode());
                    }
                }
                ++n;
            }
            authorityNames = XCollections.unmodifiableSet(authorityNames);
        }
        return authorityNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends AuthorityFactory> T getAuthorityFactory(Class<T> clazz, String string, Hints hints, Hints.ClassKey classKey) throws FactoryRegistryException {
        hints = AuthorityFactoryFinder.mergeSystemHints(hints);
        ServiceRegistry.Filter filter = (ServiceRegistry.Filter)hints.remove(FILTER_KEY);
        filter = new AuthorityFilter(string, filter);
        Class<FactoryFinder> clazz2 = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return (T)((AuthorityFactory)AuthorityFactoryFinder.getServiceRegistry().getServiceProvider(clazz, filter, hints, classKey));
        }
    }

    public static DatumAuthorityFactory getDatumAuthorityFactory(String string, Hints hints) throws FactoryRegistryException {
        return AuthorityFactoryFinder.getAuthorityFactory(DatumAuthorityFactory.class, string, hints, Hints.DATUM_AUTHORITY_FACTORY);
    }

    public static Set<DatumAuthorityFactory> getDatumAuthorityFactories(Hints hints) {
        return AuthorityFactoryFinder.getFactories(DatumAuthorityFactory.class, hints, Hints.DATUM_AUTHORITY_FACTORY);
    }

    public static CSAuthorityFactory getCSAuthorityFactory(String string, Hints hints) throws FactoryRegistryException {
        return AuthorityFactoryFinder.getAuthorityFactory(CSAuthorityFactory.class, string, hints, Hints.CS_AUTHORITY_FACTORY);
    }

    public static Set<CSAuthorityFactory> getCSAuthorityFactories(Hints hints) {
        return AuthorityFactoryFinder.getFactories(CSAuthorityFactory.class, hints, Hints.CS_AUTHORITY_FACTORY);
    }

    public static CRSAuthorityFactory getCRSAuthorityFactory(String string, Hints hints) throws FactoryRegistryException {
        return AuthorityFactoryFinder.getAuthorityFactory(CRSAuthorityFactory.class, string, hints, Hints.CRS_AUTHORITY_FACTORY);
    }

    public static Set<CRSAuthorityFactory> getCRSAuthorityFactories(Hints hints) {
        return AuthorityFactoryFinder.getFactories(CRSAuthorityFactory.class, hints, Hints.CRS_AUTHORITY_FACTORY);
    }

    public static CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String string, Hints hints) throws FactoryRegistryException {
        return AuthorityFactoryFinder.getAuthorityFactory(CoordinateOperationAuthorityFactory.class, string, hints, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY);
    }

    public static Set<CoordinateOperationAuthorityFactory> getCoordinateOperationAuthorityFactories(Hints hints) {
        return AuthorityFactoryFinder.getFactories(CoordinateOperationAuthorityFactory.class, hints, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setAuthorityOrdering(String string, String string2) {
        AuthorityFilter authorityFilter = new AuthorityFilter(string, null);
        AuthorityFilter authorityFilter2 = new AuthorityFilter(string2, null);
        Class<FactoryFinder> clazz = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            boolean bl = AuthorityFactoryFinder.getServiceRegistry().setOrdering(AuthorityFactory.class, authorityFilter, authorityFilter2);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (bl) {
                Factories.fireConfigurationChanged(AuthorityFactoryFinder.class);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unsetAuthorityOrdering(String string, String string2) {
        AuthorityFilter authorityFilter = new AuthorityFilter(string, null);
        AuthorityFilter authorityFilter2 = new AuthorityFilter(string2, null);
        Class<FactoryFinder> clazz = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            boolean bl = AuthorityFactoryFinder.getServiceRegistry().unsetOrdering(AuthorityFactory.class, authorityFilter, authorityFilter2);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (bl) {
                Factories.fireConfigurationChanged(AuthorityFactoryFinder.class);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAuthorityFactory(AuthorityFactory authorityFactory) {
        Class<AuthorityFactoryFinder> clazz = AuthorityFactoryFinder.class;
        synchronized (AuthorityFactoryFinder.class) {
            authorityNames = null;
            Class<FactoryFinder> clazz2 = FactoryFinder.class;
            synchronized (FactoryFinder.class) {
                boolean bl = registry == null;
                FactoryRegistry factoryRegistry = AuthorityFactoryFinder.getServiceRegistry();
                if (bl) {
                    factoryRegistry.scanForPlugins();
                }
                factoryRegistry.registerServiceProvider(authorityFactory);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            {
                Factories.fireConfigurationChanged(AuthorityFactoryFinder.class);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAuthorityFactory(AuthorityFactory authorityFactory) {
        Class<AuthorityFactoryFinder> clazz = AuthorityFactoryFinder.class;
        synchronized (AuthorityFactoryFinder.class) {
            authorityNames = null;
            Class<FactoryFinder> clazz2 = FactoryFinder.class;
            synchronized (FactoryFinder.class) {
                AuthorityFactoryFinder.getServiceRegistry().deregisterServiceProvider(authorityFactory);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            {
                Factories.fireConfigurationChanged(AuthorityFactoryFinder.class);
                return;
            }
        }
    }

    private static final class AuthorityFilter
    implements ServiceRegistry.Filter {
        private final String authority;
        private final ServiceRegistry.Filter filter;

        public AuthorityFilter(String string, ServiceRegistry.Filter filter) {
            this.authority = string;
            this.filter = filter;
        }

        @Override
        public boolean filter(Object object) {
            Citation citation;
            if (this.authority != null && Citations.identifierMatches(citation = ((AuthorityFactory)object).getAuthority(), this.authority)) {
                return this.filter == null || this.filter.filter(object);
            }
            return false;
        }
    }
}

