/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.event.ChangeListener;
import org.geotoolkit.factory.FactoryIteratorProvider;
import org.geotoolkit.factory.FactoryIteratorProviders;
import org.geotoolkit.factory.FactoryPrinter;
import org.geotoolkit.factory.FactoryRegistry;
import org.geotoolkit.factory.OrderedIterator;
import org.geotoolkit.internal.Listeners;
import org.geotoolkit.lang.Static;

public final class Factories
extends Static {
    private static ChangeListener[] listeners;

    private Factories() {
    }

    public static synchronized void addChangeListener(ChangeListener changeListener) {
        listeners = Listeners.addListener(changeListener, listeners);
    }

    public static synchronized void removeChangeListener(ChangeListener changeListener) {
        listeners = Listeners.removeListener(changeListener, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireConfigurationChanged(Class<?> clazz) {
        Class<Factories> clazz2 = Factories.class;
        synchronized (Factories.class) {
            ChangeListener[] changeListenerArray = listeners;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Listeners.fireChanged(clazz, changeListenerArray);
            return;
        }
    }

    public static void addFactoryIteratorProvider(FactoryIteratorProvider factoryIteratorProvider) {
        if (FactoryIteratorProviders.GLOBAL.addFactoryIteratorProvider(factoryIteratorProvider)) {
            Factories.fireConfigurationChanged(Factories.class);
        }
    }

    public static void removeFactoryIteratorProvider(FactoryIteratorProvider factoryIteratorProvider) {
        if (FactoryIteratorProviders.GLOBAL.removeFactoryIteratorProvider(factoryIteratorProvider)) {
            Factories.fireConfigurationChanged(Factories.class);
        }
    }

    public static void listProviders(Collection<FactoryRegistry> collection, Writer writer, Locale locale) throws IOException {
        new FactoryPrinter(collection).list(writer, locale);
    }

    public static <T> Iterator<T> orderForClassLoader(ClassLoader classLoader, Iterator<T> iterator) {
        if (classLoader == null || iterator == null || iterator instanceof OrderedIterator && ((OrderedIterator)iterator).classLoader == classLoader) {
            return iterator;
        }
        return new OrderedIterator<T>(classLoader, iterator);
    }
}

