/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.internal.io.TemporaryFile;
import org.geotoolkit.util.XArrays;

@ThreadSafe
final class ShutdownHook
extends Thread {
    private static ServiceRegistry[] registries;

    private ShutdownHook() {
        super(Threads.RESOURCE_DISPOSERS, "ShutdownHook");
    }

    static synchronized void register(ServiceRegistry serviceRegistry) {
        ServiceRegistry[] serviceRegistryArray = registries;
        serviceRegistryArray = serviceRegistryArray == null ? new ServiceRegistry[]{serviceRegistry} : XArrays.append(serviceRegistryArray, serviceRegistry);
        registries = serviceRegistryArray;
    }

    @Override
    public synchronized void run() {
        ServiceRegistry[] serviceRegistryArray = registries;
        if (serviceRegistryArray != null) {
            registries = null;
            for (ServiceRegistry serviceRegistry : serviceRegistryArray) {
                Iterator<Class<?>> iterator = serviceRegistry.getCategories();
                while (iterator.hasNext()) {
                    Class<?> clazz = iterator.next();
                    Iterator<?> iterator2 = serviceRegistry.getServiceProviders(clazz, false);
                    while (iterator2.hasNext()) {
                        Object obj = iterator2.next();
                        if (!(obj instanceof Factory)) continue;
                        ((Factory)obj).dispose(true);
                    }
                }
            }
        }
        Threads.shutdown();
        while (TemporaryFile.deleteAll()) {
            Thread.yield();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }
}

