/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gui.swing.tree;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geotoolkit.gui.swing.tree.DefaultMutableTreeNode;
import org.geotoolkit.gui.swing.tree.DefaultTreeModel;
import org.geotoolkit.gui.swing.tree.MutableTreeNode;
import org.geotoolkit.gui.swing.tree.NamedTreeNode;
import org.geotoolkit.gui.swing.tree.TreeFormat;
import org.geotoolkit.gui.swing.tree.TreeNode;
import org.geotoolkit.gui.swing.tree.TreeNodeFilter;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.converter.Classes;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Trees
extends Static {
    private Trees() {
    }

    public static Object getUserObject(javax.swing.tree.TreeNode treeNode) {
        if (treeNode instanceof TreeNode) {
            return ((TreeNode)treeNode).getUserObject();
        }
        if (treeNode instanceof javax.swing.tree.DefaultMutableTreeNode) {
            return ((javax.swing.tree.DefaultMutableTreeNode)treeNode).getUserObject();
        }
        return null;
    }

    public static TreePath[] getPathsToUserObject(TreeModel treeModel, Object object) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(8);
        Object[] objectArray = new Object[8];
        objectArray[0] = treeModel.getRoot();
        Trees.getPathsToUserObject(treeModel, object, objectArray, 1, arrayList);
        return arrayList.toArray(new TreePath[arrayList.size()]);
    }

    private static Object[] getPathsToUserObject(TreeModel treeModel, Object object, Object[] objectArray, int n, List<TreePath> list) {
        Object object2;
        Object object3 = objectArray[n - 1];
        if (object3 instanceof TreeNode && ((object2 = ((TreeNode)object3).getUserObject()) == object || object != null && object.equals(object2))) {
            list.add(new TreePath(XArrays.resize(objectArray, n)));
        }
        int n2 = treeModel.getChildCount(object3);
        for (int i = 0; i < n2; ++i) {
            if (n >= objectArray.length) {
                objectArray = Arrays.copyOf(objectArray, n << 1);
            }
            objectArray[n] = treeModel.getChild(object3, i);
            objectArray = Trees.getPathsToUserObject(treeModel, object, objectArray, n + 1, list);
        }
        return objectArray;
    }

    public static MutableTreeNode objectToSwing(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Iterator<Object> iterator = null;
        Class clazz = null;
        if (object instanceof Iterable) {
            clazz = Iterable.class;
            iterator = ((Iterable)object).iterator();
        } else if (object instanceof Map) {
            clazz = Map.class;
            iterator = ((Map)object).entrySet().iterator();
        }
        if (iterator != null) {
            Class<Iterable>[] classArray = Classes.getLeafInterfaces(object.getClass(), clazz);
            defaultMutableTreeNode = new DefaultMutableTreeNode(Classes.getShortName(classArray != null ? classArray[0] : null));
            while (iterator.hasNext()) {
                defaultMutableTreeNode.add(Trees.objectToSwing(iterator.next()));
            }
        } else if (object.getClass().isArray()) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Array");
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                defaultMutableTreeNode.add(Trees.objectToSwing(Array.get(object, i)));
            }
        } else {
            if (object instanceof Node) {
                return Trees.xmlToSwing((Node)object);
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                defaultMutableTreeNode = new NamedTreeNode(String.valueOf(entry.getKey()), entry.getValue());
            } else {
                defaultMutableTreeNode = new DefaultMutableTreeNode(object);
            }
            defaultMutableTreeNode.setAllowsChildren(false);
        }
        return defaultMutableTreeNode;
    }

    public static MutableTreeNode xmlToSwing(Node node) {
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        if (string2 != null) {
            string = string + "=\"" + string2 + '\"';
        }
        NamedTreeNode namedTreeNode = new NamedTreeNode(string, node);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = namedNodeMap.item(i);
                if (node2 == null) continue;
                string = node2.getNodeName() + "=\"" + node2.getNodeValue() + '\"';
                namedTreeNode.add(new NamedTreeNode(string, node2, false));
            }
        }
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            namedTreeNode.add(Trees.xmlToSwing(node3));
        }
        return namedTreeNode;
    }

    public static MutableTreeNode copy(javax.swing.tree.TreeNode treeNode) {
        return Trees.copy(treeNode, null);
    }

    public static MutableTreeNode copy(javax.swing.tree.TreeNode treeNode, TreeNodeFilter treeNodeFilter) {
        if (treeNode == null || treeNodeFilter != null && !treeNodeFilter.accept(treeNode)) {
            return null;
        }
        String string = treeNode.toString();
        Object object = Trees.getUserObject(treeNode);
        if (treeNodeFilter != null) {
            object = treeNodeFilter.convertUserObject(treeNode, object);
        }
        boolean bl = treeNode.getAllowsChildren();
        DefaultMutableTreeNode defaultMutableTreeNode = object == null || object == string ? new DefaultMutableTreeNode(string, bl) : new NamedTreeNode(string, object, bl);
        Enumeration<? extends javax.swing.tree.TreeNode> enumeration = treeNode.children();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                MutableTreeNode mutableTreeNode = Trees.copy(enumeration.nextElement(), treeNodeFilter);
                if (mutableTreeNode == null) continue;
                defaultMutableTreeNode.add(mutableTreeNode);
            }
        }
        return defaultMutableTreeNode;
    }

    public static String toString(TreeModel treeModel) {
        TreeFormat treeFormat = new TreeFormat();
        treeFormat.setTableFormatEnabled(true);
        StringBuilder stringBuilder = new StringBuilder();
        treeFormat.format(treeModel, stringBuilder);
        return stringBuilder.toString();
    }

    public static String toString(javax.swing.tree.TreeNode treeNode) {
        TreeFormat treeFormat = new TreeFormat();
        treeFormat.setTableFormatEnabled(true);
        StringBuilder stringBuilder = new StringBuilder();
        treeFormat.format(treeNode, stringBuilder);
        return stringBuilder.toString();
    }

    public static String toString(String string, Iterable<?> iterable) {
        TreeFormat treeFormat = new TreeFormat();
        treeFormat.setTableFormatEnabled(true);
        StringBuilder stringBuilder = new StringBuilder(string).append(treeFormat.getLineSeparator());
        treeFormat.format(iterable, stringBuilder);
        return stringBuilder.toString();
    }

    public static void print(TreeModel treeModel) {
        Trees.print(Trees.toString(treeModel));
    }

    public static void print(javax.swing.tree.TreeNode treeNode) {
        Trees.print(Trees.toString(treeNode));
    }

    private static void print(String string) {
        PrintWriter printWriter = IOUtilities.standardPrintWriter();
        printWriter.println(string);
        printWriter.flush();
    }

    public static void show(javax.swing.tree.TreeNode treeNode, String string) {
        Trees.show(new DefaultTreeModel(treeNode, true), string);
    }

    public static void show(TreeModel treeModel, String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(2);
        jFrame.add(new JScrollPane(new JTree(treeModel)));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

