/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.util.Collection;
import java.util.Iterator;
import org.geotoolkit.lang.Static;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

public final class Citations
extends Static {
    private Citations() {
    }

    public static <E> Iterator<E> iterator(Collection<E> collection) {
        return collection != null && !collection.isEmpty() ? collection.iterator() : null;
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        if (citation == citation2) {
            return true;
        }
        if (citation != null && citation2 != null) {
            InternationalString internationalString = citation2.getTitle();
            Iterator iterator = null;
            while (true) {
                if (internationalString != null) {
                    String string = internationalString.toString(null);
                    if (Citations.titleMatches(citation, string)) {
                        return true;
                    }
                    String string2 = internationalString.toString();
                    if (string2 != string && Citations.titleMatches(citation, string2)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = Citations.iterator(citation2.getAlternateTitles())) == null || !iterator.hasNext()) break;
                internationalString = (InternationalString)iterator.next();
            }
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, String string) {
        if (citation != null && string != null) {
            string = string.trim();
            InternationalString internationalString = citation.getTitle();
            Iterator iterator = null;
            while (true) {
                if (internationalString != null) {
                    String string2 = internationalString.toString(null);
                    if (string2 != null && string2.trim().equalsIgnoreCase(string)) {
                        return true;
                    }
                    String string3 = internationalString.toString();
                    if (string3 != string2 && string3 != null && string3.trim().equalsIgnoreCase(string)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = Citations.iterator(citation.getAlternateTitles())) == null || !iterator.hasNext()) break;
                internationalString = (InternationalString)iterator.next();
            }
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        if (citation == citation2) {
            return true;
        }
        if (citation != null && citation2 != null) {
            Iterator iterator = Citations.iterator(citation2.getIdentifiers());
            if (iterator == null) {
                iterator = Citations.iterator(citation.getIdentifiers());
                if (iterator == null) {
                    return Citations.titleMatches(citation, citation2);
                }
                citation = citation2;
                citation2 = null;
            }
            do {
                Identifier identifier;
                if ((identifier = (Identifier)iterator.next()) == null || !Citations.identifierMatches(citation, identifier.getCode())) continue;
                return true;
            } while (iterator.hasNext());
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, String string) {
        if (citation != null && string != null) {
            string = string.trim();
            Iterator iterator = Citations.iterator(citation.getIdentifiers());
            if (iterator == null) {
                return Citations.titleMatches(citation, string);
            }
            while (iterator.hasNext()) {
                String string2;
                Identifier identifier = (Identifier)iterator.next();
                if (identifier == null || (string2 = identifier.getCode()) == null || !string.equalsIgnoreCase(string2.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getIdentifier(Citation citation) {
        String string = null;
        if (citation != null) {
            InternationalString internationalString;
            Iterator iterator = Citations.iterator(citation.getIdentifiers());
            if (iterator != null) {
                while (iterator.hasNext()) {
                    int n;
                    String string2;
                    internationalString = (Identifier)iterator.next();
                    if (internationalString == null || (string2 = internationalString.getCode()) == null || (n = (string2 = string2.trim()).length()) == 0 || string != null && n >= string.length()) continue;
                    string = string2;
                }
            }
            if (string == null && (internationalString = citation.getTitle()) != null) {
                string = internationalString.toString();
            }
        }
        return string;
    }
}

