/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import javax.swing.UIManager;
import org.geotoolkit.internal.OS;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.logging.Logging;

public final class GraphicsUtilities
extends Static {
    private GraphicsUtilities() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setLookAndFeel(Class<?> clazz, String string) {
        String string2 = System.getProperty("swing.defaultlaf");
        if (string2 != null) {
            if (!string2.equalsIgnoreCase("Nimbus")) return;
            string2 = GraphicsUtilities.getNimbusLAF();
        } else {
            if (OS.current() == OS.MAC_OS) {
                return;
            }
            string2 = UIManager.getSystemLookAndFeelClassName();
        }
        if (string2.equals(UIManager.getCrossPlatformLookAndFeelClassName()) || string2.contains(".gtk.")) {
            string2 = GraphicsUtilities.getNimbusLAF();
        }
        if (string2 == null) return;
        try {
            UIManager.setLookAndFeel(string2);
            return;
        }
        catch (Exception exception) {
            Logging.recoverableException(clazz, string, exception);
        }
    }

    private static String getNimbusLAF() {
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelInfo.getName().equalsIgnoreCase("Nimbus")) continue;
            return lookAndFeelInfo.getClassName();
        }
        return null;
    }
}

