/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Console;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.stream.ImageInputStream;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;

public final class IOUtilities
extends Static {
    private static final int BUFFER_SIZE = 8192;
    private static Writer stdout;
    private static PrintWriter printer;

    private IOUtilities() {
    }

    public static synchronized Writer standardWriter() {
        if (stdout == null) {
            Console console = System.console();
            if (console != null) {
                printer = console.writer();
                stdout = printer;
            } else {
                stdout = new OutputStreamWriter(System.out);
            }
        }
        return stdout;
    }

    public static synchronized PrintWriter standardPrintWriter() {
        if (printer == null) {
            Writer writer = IOUtilities.standardWriter();
            if (printer == null) {
                printer = new PrintWriter(writer, true);
            }
        }
        return printer;
    }

    public static File commonParent(File file, File file2) {
        while (file != null) {
            for (File file3 = file2; file3 != null; file3 = file3.getParentFile()) {
                if (!file.equals(file3)) continue;
                return file;
            }
            file = file.getParentFile();
        }
        return null;
    }

    public static String encodeURI(String string) {
        Charset charset = null;
        StringBuilder stringBuilder = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isSpaceChar(c) && !Character.isISOControl(c) && c != '%') {
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string);
                stringBuilder.setLength(i);
                charset = Charset.forName("UTF-8");
            }
            for (byte by : String.valueOf(c).getBytes(charset)) {
                stringBuilder.append('%');
                String string2 = Integer.toHexString(by & 0xFF).toUpperCase(Locale.US);
                if (string2.length() < 2) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string2);
            }
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    public static URI toURI(URL uRL, String string) throws IOException {
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.toExternalForm();
        if (string != null) {
            string2 = URLDecoder.decode(string2, string);
        }
        string2 = IOUtilities.encodeURI(string2);
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException(IOUtilities.concatenate(Errors.format(73, "URL", string2), uRISyntaxException));
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    public static File toFile(URL uRL, String string) throws IOException {
        if (uRL == null) {
            return null;
        }
        URI uRI = IOUtilities.toURI(uRL, string);
        try {
            return new File(uRI);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MalformedURLException malformedURLException = new MalformedURLException(IOUtilities.concatenate(Errors.format(73, "URL", uRL), illegalArgumentException));
            malformedURLException.initCause(illegalArgumentException);
            throw malformedURLException;
        }
    }

    private static boolean isFile(String string) {
        int n;
        return string.indexOf(63) < 0 && string.indexOf(35) < 0 && ((n = string.indexOf(58)) < 0 || n == 1 && Character.isLetter(string.charAt(0)) && !string.regionMatches(2, "//", 0, 2));
    }

    public static Object toFileOrURL(String string) throws IOException {
        if (IOUtilities.isFile(string)) {
            return new File(string);
        }
        URL uRL = new URL(string);
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            return IOUtilities.toFile(uRL, null);
        }
        return uRL;
    }

    public static Object tryToFile(Object object) throws IOException {
        URI uRI;
        String string;
        if (object instanceof CharSequence) {
            object = IOUtilities.toFileOrURL(object.toString());
        } else if (object instanceof URL) {
            URL uRL = (URL)object;
            if (uRL.getProtocol().equalsIgnoreCase("file")) {
                object = IOUtilities.toFile(uRL, null);
            }
        } else if (object instanceof URI && (string = (uRI = (URI)object).getScheme()) != null && string.equalsIgnoreCase("file")) {
            try {
                object = new File(uRI);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MalformedURLException malformedURLException = new MalformedURLException(IOUtilities.concatenate(Errors.format(73, "URI", object), illegalArgumentException));
                malformedURLException.initCause(illegalArgumentException);
                throw malformedURLException;
            }
        }
        return object;
    }

    public static boolean canProcessAsPath(Object object) {
        return object instanceof CharSequence || object instanceof File || object instanceof URL || object instanceof URI;
    }

    public static String name(Object object) {
        if (object instanceof File) {
            return ((File)object).getName();
        }
        String string = object instanceof URL ? ((URL)object).getPath() : (object instanceof URI ? ((URI)object).getPath() : object.toString());
        return string.substring(string.lastIndexOf(47) + 1);
    }

    public static String extension(Object object) {
        int n;
        String string;
        if (object instanceof File) {
            string = ((File)object).getName();
            n = 0;
        } else {
            string = object instanceof URL ? ((URL)object).getPath() : (object instanceof URI ? ((URI)object).getPath() : object.toString());
            n = string.lastIndexOf(47);
        }
        int n2 = string.lastIndexOf(46);
        return n2 > n ? string.substring(n2 + 1).trim() : "";
    }

    public static Object changeExtension(Object object, String string) throws MalformedURLException {
        int n;
        String string2;
        if (object instanceof File) {
            string2 = ((File)object).getName();
            n = 0;
        } else {
            if (!(object instanceof URL || object instanceof URI || object instanceof CharSequence)) {
                return null;
            }
            string2 = object.toString();
            n = string2.lastIndexOf(47);
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n2 = string2.lastIndexOf(46);
        if (n2 > n) {
            stringBuffer.setLength(n2 + 1);
        } else {
            stringBuffer.append('.');
        }
        string2 = stringBuffer.append(string).toString();
        Object object2 = object instanceof File ? new File(((File)object).getParent(), string2) : (object instanceof URL || object instanceof URI ? new URL(string2) : string2);
        return object.equals(object2) ? object : object2;
    }

    public static InputStream open(Object object) throws IOException, ClassCastException {
        if (object instanceof CharSequence) {
            object = IOUtilities.toFileOrURL(object.toString());
        }
        if (object instanceof File) {
            return new FileInputStream((File)object);
        }
        return (object instanceof URI ? ((URI)object).toURL() : (URL)object).openStream();
    }

    public static LineNumberReader openLatin(Object object) throws IOException, ClassCastException {
        return new LineNumberReader(new InputStreamReader(IOUtilities.open(object), "ISO-8859-1"));
    }

    public static OutputStream openWrite(Object object) throws IOException, ClassCastException {
        if (object instanceof CharSequence) {
            object = IOUtilities.toFileOrURL(object.toString());
        }
        if (object instanceof File) {
            return new FileOutputStream((File)object);
        }
        return (object instanceof URI ? ((URI)object).toURL() : (URL)object).openConnection().getOutputStream();
    }

    public static void close(Object object) throws IOException {
        if (object instanceof Closeable) {
            ((Closeable)object).close();
        } else if (object instanceof ImageInputStream) {
            ((ImageInputStream)object).close();
        }
    }

    public static void readMatrixRow(BufferedReader bufferedReader, double[] dArray, int n, int n2) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new EOFException(Errors.format(61));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        for (int i = 0; i < n2; ++i) {
            double d;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ContentFormatException(Errors.format(105, i, n2));
            }
            String string2 = stringTokenizer.nextToken();
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ContentFormatException(IOUtilities.concatenate(Errors.format(232, string2), numberFormatException), numberFormatException);
            }
            dArray[n + i] = d;
        }
        if (stringTokenizer.hasMoreElements()) {
            throw new ContentFormatException(Errors.format(104, n2 + stringTokenizer.countTokens(), n2, stringTokenizer.nextToken()));
        }
    }

    public static void readMatrixRow(BufferedReader bufferedReader, float[] fArray, int n, int n2) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new EOFException(Errors.format(61));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        for (int i = 0; i < n2; ++i) {
            float f;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ContentFormatException(Errors.format(105, i, n2));
            }
            String string2 = stringTokenizer.nextToken();
            try {
                f = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ContentFormatException(IOUtilities.concatenate(Errors.format(232, string2), numberFormatException), numberFormatException);
            }
            fArray[n + i] = f;
        }
        if (stringTokenizer.hasMoreElements()) {
            throw new ContentFormatException(Errors.format(104, n2 + stringTokenizer.countTokens(), n2, stringTokenizer.nextToken()));
        }
    }

    private static String concatenate(String string, Exception exception) {
        String string2 = exception.getLocalizedMessage();
        if (string2 != null) {
            string = string + ' ' + string2;
        }
        return string;
    }

    public static void unzip(InputStream inputStream, File file) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        byte[] byArray = new byte[8192];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            File file2 = new File(file, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                if (file2.isDirectory() || file2.mkdir()) continue;
                throw new IOException(Errors.format(25, file2));
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = zipInputStream.read(byArray)) >= 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((OutputStream)fileOutputStream).close();
            long l = zipEntry.getTime();
            if (l >= 0L) {
                file2.setLastModified(l);
            }
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }
}

