/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.rmi;

import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.util.logging.Logging;

@ThreadSafe
class RemoteService
extends UnicastRemoteObject {
    private static final long serialVersionUID = -824997613540569870L;
    private static String registryHost = "localhost";
    private static boolean registryStarted;
    private Registry registry;
    private final String name;

    protected RemoteService(String string) throws RemoteException {
        this.name = string;
    }

    public static synchronized void setRegistryHost(String string) throws IllegalStateException {
        if (registryStarted) {
            throw new IllegalStateException();
        }
        registryHost = string;
    }

    public static synchronized Registry getRegistry() throws RemoteException {
        String string = registryHost;
        Registry registry = string == null ? LocateRegistry.createRegistry(1099) : (string.equalsIgnoreCase("localhost") ? LocateRegistry.getRegistry() : LocateRegistry.getRegistry(string));
        registryStarted = true;
        return registry;
    }

    public synchronized void bind() throws RemoteException, AlreadyBoundException {
        if (this.registry == null) {
            this.registry = RemoteService.getRegistry();
        }
        this.registry.bind(this.name, this);
    }

    public synchronized void shutdown() throws RemoteException {
        if (this.registry != null) {
            try {
                this.registry.unbind(this.name);
            }
            catch (NotBoundException notBoundException) {
                Logging.unexpectedException(RemoteService.logger(), RemoteService.class, "shutdown", notBoundException);
            }
        }
        this.registry = null;
    }

    static Logger logger() {
        return Logging.getLogger("org.geotoolkit.rmi");
    }
}

