/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.rmi;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.geotoolkit.internal.io.ObjectStream;
import org.geotoolkit.internal.rmi.IteratorWrapper;
import org.geotoolkit.internal.rmi.RemoteStream;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.XCollections;

public abstract class ShareableTask<Input, Output>
implements Callable<Output>,
Serializable {
    private static final long serialVersionUID = 7371908706836123493L;
    private ObjectStream<Input> stream;

    protected ShareableTask(Iterable<Input> iterable) {
        if (iterable != null) {
            this.stream = new IteratorWrapper<Input>(iterable.iterator());
        }
    }

    protected final synchronized ObjectStream<Input> inputs() {
        return this.stream;
    }

    @Override
    public abstract Output call() throws Exception;

    public Output aggregate(Collection<Output> collection) {
        Output Output = null;
        for (Output Output2 : collection) {
            if (Output2 == null) continue;
            if (Output == null) {
                Output = Output2;
                continue;
            }
            throw new UnsupportedOperationException("Needs an implementation of ShareableTask.aggregate(Collection<Output>).");
        }
        return Output;
    }

    protected static <K, V> Map<K, V> aggregateMap(Collection<Map<K, V>> collection) throws IllegalArgumentException {
        int n = 0;
        for (Map<K, V> object : collection) {
            n += object.size();
        }
        HashMap hashMap = new HashMap(XCollections.hashMapCapacity(n));
        for (Map<K, V> map : collection) {
            hashMap.putAll(map);
        }
        if ((n -= hashMap.size()) != 0) {
            throw new IllegalArgumentException(Errors.format(54, n));
        }
        return hashMap;
    }

    public void rollback() {
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectStream<Input> objectStream = this.stream;
        if (objectStream != null && !(objectStream instanceof Serializable)) {
            this.stream = new RemoteStream<Input>(objectStream);
        }
        objectOutputStream.defaultWriteObject();
    }
}

