/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.io.IndentedLineWriter;
import org.geotoolkit.util.Strings;

@ThreadSafe
public class NumberedLineWriter
extends IndentedLineWriter {
    private static PrintWriter stdout;
    private int width = 3;
    private int current = 1;

    public static synchronized PrintWriter getStandardOutput() {
        if (stdout == null) {
            stdout = new PrintWriter(IOUtilities.standardWriter(), true);
        }
        return stdout;
    }

    public NumberedLineWriter(Writer writer) {
        super(writer);
    }

    public int getLineNumber() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.current = n;
        }
    }

    @Override
    protected void beginNewLine() throws IOException {
        String string = String.valueOf(this.current++);
        this.out.write(91);
        this.out.write(Strings.spaces(this.width - string.length()));
        this.out.write(string);
        this.out.write("] ");
    }

    private static final class Uncloseable
    extends NumberedLineWriter {
        public Uncloseable(Writer writer) {
            super(writer);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

