/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.geotoolkit.math.Vector;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.Numbers;

final class ArrayVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 3496467575389288163L;
    private final Object array;

    ArrayVector(Object object) {
        this.array = object;
    }

    @Override
    public Class<? extends Number> getElementType() {
        return Numbers.primitiveToWrapper(this.array.getClass().getComponentType()).asSubclass(Number.class);
    }

    @Override
    public int size() {
        return Array.getLength(this.array);
    }

    @Override
    public boolean isNaN(int n) throws IndexOutOfBoundsException {
        Number number = this.get(n);
        return number == null || java.lang.Double.isNaN(number.doubleValue());
    }

    @Override
    public double doubleValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getDouble(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    @Override
    public float floatValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getFloat(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    @Override
    public long longValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getLong(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    @Override
    public int intValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getInt(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    @Override
    public short shortValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getShort(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    @Override
    public byte byteValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getByte(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    private ClassCastException cantConvert(IllegalArgumentException illegalArgumentException) {
        ClassCastException classCastException = new ClassCastException(Errors.format(24, this.array.getClass().getComponentType()));
        classCastException.initCause(illegalArgumentException);
        return classCastException;
    }

    @Override
    public Number get(int n) throws ArrayIndexOutOfBoundsException {
        return (Number)Array.get(this.array, n);
    }

    @Override
    public Number set(int n, Number number) throws ArrayIndexOutOfBoundsException, ArrayStoreException {
        Number number2 = (Number)Array.get(this.array, n);
        try {
            Array.set(this.array, n, number);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArrayStoreException arrayStoreException = new ArrayStoreException(Errors.format(24, Classes.getClass(number)));
            arrayStoreException.initCause(illegalArgumentException);
            throw arrayStoreException;
        }
        return number2;
    }

    static final class Float
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 5395284704294981455L;
        private final float[] array;

        Float(float[] fArray) {
            this.array = fArray;
        }

        @Override
        public Class<java.lang.Float> getElementType() {
            return java.lang.Float.class;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public boolean isNaN(int n) throws ArrayIndexOutOfBoundsException {
            return java.lang.Float.isNaN(this.array[n]);
        }

        @Override
        public double doubleValue(int n) throws ArrayIndexOutOfBoundsException {
            return this.array[n];
        }

        @Override
        public float floatValue(int n) throws ArrayIndexOutOfBoundsException {
            return this.array[n];
        }

        @Override
        public long longValue(int n) throws ClassCastException {
            throw Float.cantConvert();
        }

        @Override
        public int intValue(int n) throws ClassCastException {
            throw Float.cantConvert();
        }

        @Override
        public short shortValue(int n) throws ClassCastException {
            throw Float.cantConvert();
        }

        @Override
        public byte byteValue(int n) throws ClassCastException {
            throw Float.cantConvert();
        }

        private static ClassCastException cantConvert() {
            return new ClassCastException(Errors.format(24, Float.class));
        }

        @Override
        public java.lang.Float get(int n) throws ArrayIndexOutOfBoundsException {
            return java.lang.Float.valueOf(this.array[n]);
        }

        @Override
        public java.lang.Float set(int n, Number number) throws ArrayIndexOutOfBoundsException {
            float f = this.array[n];
            this.array[n] = number.floatValue();
            return java.lang.Float.valueOf(f);
        }
    }

    static final class Double
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = -2900375382498345812L;
        private final double[] array;

        Double(double[] dArray) {
            this.array = dArray;
        }

        @Override
        public Class<java.lang.Double> getElementType() {
            return java.lang.Double.class;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public boolean isNaN(int n) throws ArrayIndexOutOfBoundsException {
            return java.lang.Double.isNaN(this.array[n]);
        }

        @Override
        public double doubleValue(int n) throws ArrayIndexOutOfBoundsException {
            return this.array[n];
        }

        @Override
        public float floatValue(int n) throws ArrayIndexOutOfBoundsException {
            return (float)this.array[n];
        }

        @Override
        public long longValue(int n) throws ClassCastException {
            throw Double.cantConvert();
        }

        @Override
        public int intValue(int n) throws ClassCastException {
            throw Double.cantConvert();
        }

        @Override
        public short shortValue(int n) throws ClassCastException {
            throw Double.cantConvert();
        }

        @Override
        public byte byteValue(int n) throws ClassCastException {
            throw Double.cantConvert();
        }

        private static ClassCastException cantConvert() {
            return new ClassCastException(Errors.format(24, Double.class));
        }

        @Override
        public java.lang.Double get(int n) throws ArrayIndexOutOfBoundsException {
            return this.array[n];
        }

        @Override
        public java.lang.Double set(int n, Number number) throws ArrayIndexOutOfBoundsException {
            double d = this.array[n];
            this.array[n] = number.doubleValue();
            return d;
        }
    }
}

