/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.measure;

import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.UnitConverter;
import net.jcip.annotations.Immutable;

@Immutable
class SexagesimalConverter
extends UnitConverter {
    private static final long serialVersionUID = 3873494343412121773L;
    private static final double EPS = 1.0E-8;
    static final SexagesimalConverter INTEGER = new SexagesimalConverter(1);
    static final SexagesimalConverter FRACTIONAL = new SexagesimalConverter(10000);
    final int divider;
    private final UnitConverter inverse;

    private SexagesimalConverter(int n) {
        this.divider = n;
        this.inverse = new Inverse(this);
    }

    private SexagesimalConverter(int n, UnitConverter unitConverter) {
        this.divider = n;
        this.inverse = unitConverter;
    }

    public final UnitConverter inverse() {
        return this.inverse;
    }

    public double convert(double d) {
        int n = (int)d;
        d = (d - (double)n) * 60.0;
        int n2 = (int)d;
        d = (d - (double)n2) * 60.0;
        int n3 = (int)d;
        return ((double)((n * 100 + n2) * 100 + n3) + (d -= (double)n3)) / (double)this.divider;
    }

    public final BigDecimal convert(BigDecimal bigDecimal, MathContext mathContext) {
        return new BigDecimal(this.convert(bigDecimal.doubleValue()), mathContext);
    }

    public final double derivative(double d) {
        return 1.0;
    }

    public final boolean equals(Object object) {
        return object != null && object.getClass() == ((Object)((Object)this)).getClass() && ((SexagesimalConverter)((Object)object)).divider == this.divider;
    }

    public int hashCode() {
        return 714113197 + this.divider;
    }

    protected Object readResolve() throws ObjectStreamException {
        SexagesimalConverter sexagesimalConverter = INTEGER;
        for (int i = 0; i <= 3; ++i) {
            switch (i) {
                case 0: {
                    break;
                }
                case 2: {
                    sexagesimalConverter = FRACTIONAL;
                    break;
                }
                default: {
                    sexagesimalConverter = sexagesimalConverter.inverse();
                }
            }
            if (!this.equals((Object)sexagesimalConverter)) continue;
            return sexagesimalConverter;
        }
        return this;
    }

    @Immutable
    private static final class Inverse
    extends SexagesimalConverter {
        private static final long serialVersionUID = -7171869900634417819L;

        public Inverse(SexagesimalConverter sexagesimalConverter) {
            super(sexagesimalConverter.divider, sexagesimalConverter);
        }

        @Override
        public double convert(double d) {
            int n = (int)((d *= (double)this.divider) / 10000.0);
            int n2 = (int)((d -= (double)(10000 * n)) / 100.0);
            d -= (double)(100 * n2);
            if (n2 <= -60 || n2 >= 60) {
                if ((double)Math.abs(Math.abs(n2) - 100) <= 1.0E-8) {
                    n = n2 >= 0 ? ++n : --n;
                    n2 = 0;
                } else {
                    throw new ArithmeticException("Invalid minutes: " + n2);
                }
            }
            if (d <= -60.0 || d >= 60.0) {
                if (Math.abs(Math.abs(d) - 100.0) <= 1.0E-8) {
                    n2 = d >= 0.0 ? ++n2 : --n2;
                    d = 0.0;
                } else {
                    throw new ArithmeticException("Invalid seconds: " + d);
                }
            }
            d = (d / 60.0 + (double)n2) / 60.0 + (double)n;
            return d;
        }

        @Override
        public int hashCode() {
            return -715221659 + this.divider;
        }
    }
}

