/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.process;

import java.util.EventObject;
import org.geotoolkit.process.Process;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

public class ProcessEvent
extends EventObject {
    private static final long serialVersionUID = 622026012845207483L;
    private final InternationalString task;
    private final float progress;
    private final ParameterValueGroup output;
    private final Exception exception;

    public ProcessEvent(Process process) {
        super(process);
        this.progress = Float.NaN;
        this.task = null;
        this.exception = null;
        this.output = null;
    }

    public ProcessEvent(Process process, CharSequence charSequence, float f) {
        super(process);
        this.progress = f;
        this.task = SimpleInternationalString.wrap(charSequence);
        this.exception = null;
        this.output = null;
    }

    public ProcessEvent(Process process, CharSequence charSequence, float f, ParameterValueGroup parameterValueGroup) {
        super(process);
        this.progress = f;
        this.task = SimpleInternationalString.wrap(charSequence);
        this.exception = null;
        this.output = parameterValueGroup;
    }

    public ProcessEvent(Process process, CharSequence charSequence, float f, Exception exception) {
        super(process);
        this.progress = f;
        this.task = SimpleInternationalString.wrap(charSequence);
        this.exception = exception;
        this.output = null;
    }

    @Override
    public Process getSource() {
        return (Process)super.getSource();
    }

    public InternationalString getTask() {
        return this.task;
    }

    public float getProgress() {
        return this.progress;
    }

    public ParameterValueGroup getOutput() {
        return this.output;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[source=").append(this.source);
        if (this.task != null) {
            stringBuilder.append(", task=\"").append((CharSequence)this.task).append('\"');
        }
        if (!Float.isNaN(this.progress)) {
            stringBuilder.append(", progress=").append(this.progress).append('%');
        }
        return stringBuilder.append(']').toString();
    }
}

