/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;

public final class ArgumentChecks
extends Static {
    private ArgumentChecks() {
    }

    public static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(172, string));
        }
    }

    public static void ensureNonNull(String string, int n, Object[] objectArray) throws NullArgumentException {
        if (objectArray == null) {
            throw new NullArgumentException(Errors.format(172, string));
        }
        if (objectArray[n] == null) {
            throw new NullArgumentException(Errors.format(172, string + '[' + n + ']'));
        }
    }

    public static <T> void ensureCanCast(String string, Class<? extends T> clazz, T t) throws IllegalArgumentException {
        Class<?> clazz2;
        if (t != null && !clazz.isAssignableFrom(clazz2 = t.getClass())) {
            Object[] objectArray;
            int n;
            if (string != null) {
                n = 256;
                objectArray = new Object[]{string, clazz2, clazz};
            } else {
                n = 76;
                objectArray = new Object[]{clazz2, clazz};
            }
            throw new IllegalArgumentException(Errors.format(n, objectArray));
        }
    }

    public static void ensureValidIndex(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 >= n) {
            throw new IndexOutOfBoundsException(Errors.format(96, n2));
        }
    }

    public static void ensurePositive(String string, int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(Errors.format(73, string, n));
        }
    }

    public static void ensurePositive(String string, long l) throws IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException(Errors.format(73, string, l));
        }
    }

    public static void ensurePositive(String string, float f) throws IllegalArgumentException {
        if (!(f >= 0.0f)) {
            throw new IllegalArgumentException(Errors.format(73, string, Float.valueOf(f)));
        }
    }

    public static void ensurePositive(String string, double d) throws IllegalArgumentException {
        if (!(d >= 0.0)) {
            throw new IllegalArgumentException(Errors.format(73, string, d));
        }
    }

    public static void ensureStrictlyPositive(String string, int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException(Errors.format(148, string, n));
        }
    }

    public static void ensureStrictlyPositive(String string, long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException(Errors.format(148, string, l));
        }
    }

    public static void ensureStrictlyPositive(String string, float f) throws IllegalArgumentException {
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException(Errors.format(148, string, Float.valueOf(f)));
        }
    }

    public static void ensureStrictlyPositive(String string, double d) throws IllegalArgumentException {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException(Errors.format(148, string, d));
        }
    }

    public static void ensureBetween(String string, int n, int n2, int n3) throws IllegalArgumentException {
        if (n3 < n || n3 > n2) {
            throw new IllegalArgumentException(Errors.format(255, string, n3, n, n2));
        }
    }

    public static void ensureBetween(String string, long l, long l2, long l3) throws IllegalArgumentException {
        if (l3 < l || l3 > l2) {
            throw new IllegalArgumentException(Errors.format(255, string, l3, l, l2));
        }
    }

    public static void ensureBetween(String string, float f, float f2, float f3) throws IllegalArgumentException {
        if (!(f3 >= f) || !(f3 <= f2)) {
            throw new IllegalArgumentException(Errors.format(255, string, Float.valueOf(f3), Float.valueOf(f), Float.valueOf(f2)));
        }
    }

    public static void ensureBetween(String string, double d, double d2, double d3) throws IllegalArgumentException {
        if (!(d3 >= d) || !(d3 <= d2)) {
            throw new IllegalArgumentException(Errors.format(255, string, d3, d, d2));
        }
    }

    public static void ensureDimensionMatches(String string, DirectPosition directPosition, int n) throws MismatchedDimensionException {
        int n2;
        if (directPosition != null && (n2 = directPosition.getDimension()) != n) {
            throw new MismatchedDimensionException(Errors.format(113, string, n2, n));
        }
    }
}

