/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.util.Arrays;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.XArrays;

public final class Strings
extends Static {
    public static final String[] EMPTY = new String[0];
    private static final String[] SPACES = new String[21];
    private static final String ASCII = "AAAAAA\u00c6CEEEEIIIIDNOOOOO*OUUUUY\u00desaaaaaa\u00e6ceeeeiiiionooooo/ouuuuy\u00fey";

    private Strings() {
    }

    private static int codePointAfter(CharSequence charSequence, int n) {
        return Character.codePointAt(charSequence, n + Character.charCount(Character.codePointAt(charSequence, n)));
    }

    public static String spaces(int n) {
        String string;
        if (n < 0) {
            n = 0;
        }
        if (n < SPACES.length) {
            string = SPACES[n];
            if (string == null) {
                Strings.SPACES[n] = string = SPACES[SPACES.length - 1].substring(0, n).intern();
            }
        } else {
            char[] cArray = new char[n];
            Arrays.fill(cArray, ' ');
            string = new String(cArray);
        }
        return string;
    }

    public static int length(CharSequence charSequence) {
        return charSequence != null ? charSequence.length() : 0;
    }

    public static int count(String string, String string2) {
        int n;
        if (string2 == null || (n = string2.length()) == 0) {
            throw new IllegalArgumentException(Errors.format(72, "toSearch"));
        }
        if (n == 1) {
            return Strings.count(string, string2.charAt(0));
        }
        int n2 = 0;
        if (string != null) {
            int n3 = string.indexOf(string2);
            while (n3 >= 0) {
                ++n2;
                n3 = string.indexOf(string2, n3 + n);
            }
        }
        return n2;
    }

    public static int count(String string, char c) {
        int n = 0;
        if (string != null) {
            int n2 = string.indexOf(c);
            while (++n2 != 0) {
                ++n;
                n2 = string.indexOf(c, n2);
            }
        }
        return n;
    }

    public static int count(CharSequence charSequence, char c) {
        if (charSequence instanceof String) {
            return Strings.count((String)charSequence, c);
        }
        int n = 0;
        if (charSequence != null) {
            int n2 = charSequence.length();
            while (--n2 >= 0) {
                if (charSequence.charAt(n2) != c) continue;
                ++n;
            }
        }
        return n;
    }

    public static String[] split(String string, char c) {
        boolean bl = c <= ' ';
        String[] stringArray = new String[4];
        int n = 0;
        if (string != null) {
            int n2 = 0;
            int n3 = string.indexOf(c);
            while (n3 >= 0) {
                String string2 = string.substring(n2, n3).trim();
                if (!bl || !string2.isEmpty()) {
                    if (n == stringArray.length) {
                        stringArray = Arrays.copyOf(stringArray, n << 1);
                    }
                    stringArray[n++] = string2;
                }
                n2 = ++n3;
                n3 = string.indexOf(c, n3);
            }
            String string3 = string.substring(n2).trim();
            if (!bl || !string3.isEmpty()) {
                if (n == stringArray.length) {
                    stringArray = Arrays.copyOf(stringArray, n + 1);
                }
                stringArray[n++] = string3;
            }
        }
        return XArrays.resize(stringArray, n);
    }

    public static double[] parseDoubles(String string, char c) throws NumberFormatException {
        String[] stringArray = Strings.split(string, c);
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            dArray[i] = string2.isEmpty() ? Double.NaN : Double.parseDouble(string2);
        }
        return dArray;
    }

    public static float[] parseFloats(String string, char c) throws NumberFormatException {
        String[] stringArray = Strings.split(string, c);
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            fArray[i] = string2.isEmpty() ? Float.NaN : Float.parseFloat(string2);
        }
        return fArray;
    }

    public static long[] parseLongs(String string, char c, int n) throws NumberFormatException {
        String[] stringArray = Strings.split(string, c);
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lArray[i] = Long.parseLong(stringArray[i], n);
        }
        return lArray;
    }

    public static int[] parseInts(String string, char c, int n) throws NumberFormatException {
        String[] stringArray = Strings.split(string, c);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i], n);
        }
        return nArray;
    }

    public static short[] parseShorts(String string, char c, int n) throws NumberFormatException {
        String[] stringArray = Strings.split(string, c);
        short[] sArray = new short[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            sArray[i] = Short.parseShort(stringArray[i], n);
        }
        return sArray;
    }

    public static byte[] parseBytes(String string, char c, int n) throws NumberFormatException {
        String[] stringArray = Strings.split(string, c);
        byte[] byArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            byArray[i] = Byte.parseByte(stringArray[i], n);
        }
        return byArray;
    }

    public static String formatList(Iterable<?> iterable, String string) {
        ArgumentChecks.ensureNonNull("separator", string);
        String string2 = null;
        if (iterable != null) {
            StringBuilder stringBuilder = null;
            for (Object obj : iterable) {
                if (obj == null) continue;
                if (string2 == null) {
                    string2 = obj.toString();
                    continue;
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string2);
                }
                stringBuilder.append(string).append(obj);
            }
            if (stringBuilder != null) {
                string2 = stringBuilder.toString();
            }
        }
        return string2;
    }

    public static void replace(StringBuilder stringBuilder, String string, String string2) {
        if (!string.equals(string2)) {
            int n = string.length();
            int n2 = stringBuilder.length();
            while ((n2 = stringBuilder.lastIndexOf(string, n2)) >= 0) {
                stringBuilder.replace(n2, n2 + n, string2);
                n2 -= n;
            }
        }
    }

    public static void replace(StringBuilder stringBuilder, int n, int n2, char[] cArray) {
        int n3 = n2 - n;
        if (n < 0 || n3 < 0) {
            throw new StringIndexOutOfBoundsException(Errors.format(14, n, n2));
        }
        int n4 = cArray.length - n3;
        if (n4 < 0) {
            stringBuilder.delete(n2 + n4, n2);
            n3 = cArray.length;
        }
        for (int i = 0; i < n3; ++i) {
            stringBuilder.setCharAt(n++, cArray[i]);
        }
        if (n4 > 0) {
            stringBuilder.insert(n, cArray, n3, n4);
        }
    }

    public static void remove(StringBuilder stringBuilder, String string) {
        int n = string.length();
        int n2 = stringBuilder.lastIndexOf(string);
        while (n2 >= 0) {
            stringBuilder.delete(n2, n2 + n);
            n2 = stringBuilder.lastIndexOf(string, n2);
        }
    }

    public static String trim(String string) {
        if (string != null) {
            int n;
            int n2;
            int n3;
            for (n2 = string.length(); n2 != 0 && Character.isWhitespace(n3 = string.codePointBefore(n2)); n2 -= Character.charCount(n3)) {
            }
            for (n3 = 0; n3 < n2 && Character.isWhitespace(n = string.codePointAt(n3)); n3 += Character.charCount(n)) {
            }
            string = string.substring(n3, n2);
        }
        return string;
    }

    public static String trimFractionalPart(String string) {
        if (string != null) {
            int n;
            block4: for (int i = string.length(); i > 0; i -= Character.charCount(n)) {
                n = string.codePointBefore(i);
                switch (n) {
                    case 48: {
                        continue block4;
                    }
                    case 46: {
                        return string.substring(0, i);
                    }
                }
                return string;
            }
        }
        return string;
    }

    public static void trimFractionalPart(StringBuilder stringBuilder) {
        int n;
        block4: for (int i = stringBuilder.length(); i > 0; i -= Character.charCount(n)) {
            n = stringBuilder.codePointBefore(i);
            switch (n) {
                case 48: {
                    continue block4;
                }
                case 46: {
                    stringBuilder.setLength(i);
                }
            }
            return;
        }
    }

    public static CharSequence toASCII(CharSequence charSequence) {
        if (charSequence != null) {
            int n;
            StringBuilder stringBuilder = null;
            int n2 = charSequence.length();
            for (int i = 0; i < n2; i += Character.charCount(n)) {
                n = Character.codePointAt(charSequence, i);
                int n3 = n - 192;
                if (n3 < 0 || n3 >= ASCII.length()) continue;
                char c = ASCII.charAt(n3);
                if (stringBuilder == null) {
                    if (charSequence instanceof StringBuilder) {
                        stringBuilder = (StringBuilder)charSequence;
                    } else {
                        stringBuilder = new StringBuilder(charSequence);
                        charSequence = stringBuilder;
                    }
                }
                stringBuilder.setCharAt(i, c);
            }
        }
        return charSequence;
    }

    public static String camelCaseToSentence(CharSequence charSequence) {
        int n;
        int n2;
        if (charSequence == null) {
            return null;
        }
        if (Strings.isCode(charSequence)) {
            return ((Object)charSequence).toString().replace('_', '-');
        }
        StringBuilder stringBuilder = Strings.camelCaseToWords(charSequence, true);
        int n3 = stringBuilder.length();
        for (n2 = 0; n2 < n3; ++n2) {
            if (stringBuilder.charAt(n2) != '_') continue;
            stringBuilder.setCharAt(n2, ' ');
        }
        if (n3 != 0 && (n2 = stringBuilder.codePointAt(0)) != (n = Character.toUpperCase(n2))) {
            Strings.replace(stringBuilder, 0, Character.charCount(n2), Character.toChars(n));
        }
        return stringBuilder.toString().trim();
    }

    public static StringBuilder camelCaseToWords(CharSequence charSequence, boolean bl) {
        int n;
        int n2;
        int n3 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n3 + 8);
        int n4 = n3 != 0 ? n3 - Character.charCount(Character.codePointBefore(charSequence, n3)) : 0;
        int n5 = 0;
        for (n = 1; n <= n3; n += Character.charCount(n2)) {
            int n6;
            int n7;
            boolean bl2;
            if (n == n3) {
                n2 = 0;
                bl2 = true;
            } else {
                n2 = Character.codePointAt(charSequence, n);
                boolean bl3 = bl2 = Character.isUpperCase(n2) && Character.isLowerCase(Character.codePointBefore(charSequence, n));
            }
            if (!bl2) continue;
            int n8 = stringBuilder.length();
            stringBuilder.append(charSequence, n5, n).append(' ');
            if (bl && n8 != 0 && n5 < n4 && Character.isLowerCase(Strings.codePointAfter(charSequence, n5)) && (n7 = stringBuilder.codePointAt(n8)) != (n6 = Character.toLowerCase(n7))) {
                Strings.replace(stringBuilder, n8, n8 + Character.charCount(n7), Character.toChars(n6));
            }
            n5 = n;
        }
        n = stringBuilder.length();
        if (n != 0 && Character.isSpaceChar(n2 = stringBuilder.codePointBefore(n))) {
            stringBuilder.setLength(n - Character.charCount(n2));
        }
        return stringBuilder;
    }

    public static String camelCaseToAcronym(String string) {
        if (string != null && !Strings.isUpperCase(string = string.trim())) {
            int n;
            int n2;
            int n3 = string.length();
            StringBuilder stringBuilder = new StringBuilder(8);
            boolean bl = true;
            for (n = 0; n < n3; n += Character.charCount(n2)) {
                n2 = string.codePointAt(n);
                if (bl) {
                    if (!Character.isJavaIdentifierStart(n2)) continue;
                    stringBuilder.appendCodePoint(n2);
                    bl = false;
                    continue;
                }
                if (!Character.isJavaIdentifierPart(n2) || n2 == 95) {
                    bl = true;
                    continue;
                }
                if (!Character.isUpperCase(n2) || !Character.isLowerCase(stringBuilder.codePointBefore(stringBuilder.length()))) continue;
                stringBuilder.appendCodePoint(n2);
            }
            n = stringBuilder.length();
            if (n != 0) {
                String string2;
                int n4;
                if (Strings.isUpperCase(stringBuilder, 1, n) && (n2 = stringBuilder.codePointAt(0)) != (n4 = Character.toUpperCase(n2))) {
                    Strings.replace(stringBuilder, 0, Character.charCount(n2), Character.toChars(n4));
                }
                if (!string.equals(string2 = stringBuilder.toString())) {
                    string = string2;
                }
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAcronymForWords(CharSequence charSequence, CharSequence charSequence2) {
        boolean bl;
        int n;
        int n2;
        int n3;
        block17: {
            int n4;
            n3 = charSequence2.length();
            int n5 = charSequence.length();
            n2 = 0;
            int n6 = 0;
            do {
                if (n6 >= n5) {
                    return false;
                }
                n4 = Character.codePointAt(charSequence, n6);
                n6 += Character.charCount(n4);
            } while (!Character.isLetterOrDigit(n4));
            do {
                if (n2 >= n3) {
                    return false;
                }
                n = Character.codePointAt(charSequence2, n2);
                n2 += Character.charCount(n);
            } while (!Character.isLetterOrDigit(n));
            if (Character.toUpperCase(n4) != Character.toUpperCase(n)) {
                return false;
            }
            while (true) {
                block18: {
                    if (n6 >= n5) break block17;
                    if (n2 >= n3) {
                        return false;
                    }
                    n4 = Character.codePointAt(charSequence, n6);
                    n6 += Character.charCount(n4);
                    n = Character.codePointAt(charSequence2, n2);
                    n2 += Character.charCount(n);
                    if (Character.isLetterOrDigit(n4)) {
                        if (Character.toUpperCase(n4) == Character.toUpperCase(n)) {
                            continue;
                        }
                    } else {
                        while (n6 < n5) {
                            n4 = Character.codePointAt(charSequence, n6);
                            n6 += Character.charCount(n4);
                            if (!Character.isLetterOrDigit(n4)) continue;
                            break block18;
                        }
                        break block17;
                    }
                }
                bl = true;
                while (true) {
                    if (Character.isLetterOrDigit(n) == bl) {
                        if (n2 >= n3) {
                            return false;
                        }
                        n = Character.codePointAt(charSequence2, n2);
                        n2 += Character.charCount(n);
                        continue;
                    }
                    if (bl = !bl) break;
                }
                if (Character.toUpperCase(n4) != Character.toUpperCase(n)) break;
            }
            return false;
        }
        bl = true;
        while (true) {
            if (n2 >= n3) {
                return true;
            }
            n = Character.codePointAt(charSequence2, n2);
            n2 += Character.charCount(n);
            if (Character.isLetterOrDigit(n) == bl) continue;
            if (!bl) {
                return false;
            }
            boolean bl2 = bl = false;
            if (bl2) break;
        }
        return false;
    }

    private static boolean isCode(CharSequence charSequence) {
        int n = charSequence.length();
        while (--n >= 0) {
            char c = charSequence.charAt(n);
            if (c >= 'A' && c <= 'Z' || c >= '-' && c <= ':' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaIdentifier(CharSequence charSequence) {
        int n = charSequence.length();
        if (n == 0) {
            return false;
        }
        int n2 = Character.codePointAt(charSequence, 0);
        if (!Character.isJavaIdentifierStart(n2)) {
            return false;
        }
        int n3 = 0;
        while ((n3 += Character.charCount(n2)) < n) {
            n2 = Character.codePointAt(charSequence, n3);
            if (Character.isJavaIdentifierPart(n2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(CharSequence charSequence) {
        return Strings.isUpperCase(charSequence, 0, charSequence.length());
    }

    private static boolean isUpperCase(CharSequence charSequence, int n, int n2) {
        while (n < n2) {
            int n3 = Character.codePointAt(charSequence, n);
            if (!Character.isUpperCase(n3)) {
                return false;
            }
            n += Character.charCount(n3);
        }
        return true;
    }

    private static boolean equalsIgnoreCase(int n, int n2) {
        if ((n = Character.toUpperCase(n)) == (n2 = Character.toUpperCase(n2))) {
            return true;
        }
        return Character.toLowerCase(n) == Character.toLowerCase(n2);
    }

    public static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        int n2;
        int n3;
        int n4 = charSequence.length();
        int n5 = charSequence2.length();
        int n6 = 0;
        for (n = 0; n6 < n4 && n < n5; n6 += Character.charCount(n3), n += Character.charCount(n2)) {
            n3 = Character.codePointAt(charSequence, n6);
            if (n3 == (n2 = Character.codePointAt(charSequence2, n)) || Strings.equalsIgnoreCase(n3, n2)) continue;
            return false;
        }
        return n6 == n;
    }

    public static boolean regionMatches(CharSequence charSequence, int n, CharSequence charSequence2) {
        if (charSequence instanceof String && charSequence2 instanceof String) {
            return ((String)charSequence).regionMatches(n, (String)charSequence2, 0, charSequence2.length());
        }
        int n2 = charSequence2.length();
        if (n + n2 > charSequence.length()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (charSequence.charAt(n + i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n) {
        if (charSequence2 instanceof String) {
            if (charSequence instanceof String) {
                return ((String)charSequence).indexOf((String)charSequence2, n);
            }
            if (charSequence instanceof StringBuilder) {
                return ((StringBuilder)charSequence).indexOf((String)charSequence2, n);
            }
            if (charSequence instanceof StringBuffer) {
                return ((StringBuffer)charSequence).indexOf((String)charSequence2, n);
            }
        }
        int n2 = charSequence2.length();
        int n3 = charSequence.length() - n2;
        while (n <= n3) {
            block7: {
                for (int i = 0; i < n2; ++i) {
                    if (charSequence.charAt(n + i) == charSequence2.charAt(i)) {
                        continue;
                    }
                    break block7;
                }
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static CharSequence token(CharSequence charSequence, int n) {
        int n2;
        int n3 = charSequence.length();
        int n4 = n;
        do {
            if (n4 >= n3) {
                return "";
            }
            n2 = Character.codePointAt(charSequence, n4);
            n = n4;
            n4 += Character.charCount(n2);
        } while (Character.isWhitespace(n2));
        if (Character.isJavaIdentifierStart(n2)) {
            while (n4 < n3 && Character.isJavaIdentifierPart(n2 = Character.codePointAt(charSequence, n4))) {
                n4 += Character.charCount(n2);
            }
        } else {
            int n5 = Character.getType(Character.codePointAt(charSequence, n));
            while (n4 < n3 && Character.getType(n2 = Character.codePointAt(charSequence, n4)) == n5) {
                n4 += Character.charCount(n2);
            }
        }
        return charSequence.subSequence(n, n4);
    }

    public static String commonPrefix(String string, String string2) {
        int n;
        int n2;
        String string3;
        int n3;
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n4 = string.length();
        if (n4 <= (n3 = string2.length())) {
            string3 = string;
            n2 = n4;
        } else {
            string3 = string2;
            n2 = n3;
        }
        for (n = 0; n < n2 && string.charAt(n) == string2.charAt(n); ++n) {
        }
        return string3.substring(0, n);
    }

    public static String commonSuffix(String string, String string2) {
        int n;
        String string3;
        int n2;
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        if (n3 <= (n2 = string2.length())) {
            string3 = string;
            n = n3;
        } else {
            string3 = string2;
            n = n2;
        }
        int n4 = 0;
        while (++n4 <= n && string.charAt(n3 - n4) == string2.charAt(n2 - n4)) {
        }
        return string3.substring(n - --n4);
    }

    public static boolean startsWith(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        int n;
        int n2 = charSequence.length();
        int n3 = charSequence2.length();
        int n4 = 0;
        for (int i = 0; i < n3; i += Character.charCount(n)) {
            if (n4 >= n2) {
                return false;
            }
            int n5 = Character.codePointAt(charSequence, n4);
            if (!(n5 == (n = Character.codePointAt(charSequence2, i)) || bl && Strings.equalsIgnoreCase(n5, n))) {
                return false;
            }
            n4 += Character.charCount(n5);
        }
        return true;
    }

    public static boolean endsWith(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        int n;
        int n2 = charSequence.length();
        for (int i = charSequence2.length(); i > 0; i -= Character.charCount(n)) {
            if (n2 <= 0) {
                return false;
            }
            int n3 = Character.codePointBefore(charSequence, n2);
            if (!(n3 == (n = Character.codePointBefore(charSequence2, i)) || bl && Strings.equalsIgnoreCase(n3, n))) {
                return false;
            }
            n2 -= Character.charCount(n3);
        }
        return true;
    }

    public static int skipLines(CharSequence charSequence, int n, int n2) {
        char c;
        int n3 = charSequence.length();
        if (n < 0) {
            while (true) {
                if (n2 == 0) {
                    return n2;
                }
                if ((c = charSequence.charAt(--n2)) == '\n') {
                    if (n2 != 0 && charSequence.charAt(n2 - 1) == '\r') {
                        --n2;
                    }
                } else if (c != '\r') continue;
                if (++n == 0) break;
            }
            n = 1;
        }
        block1: while (--n >= 0) {
            do {
                if (n2 >= n3) {
                    return n2;
                }
                if ((c = charSequence.charAt(n2++)) != '\r') continue;
                if (n2 == n3 || charSequence.charAt(n2) != '\n') continue block1;
                ++n2;
                continue block1;
            } while (c != '\n');
        }
        return n2;
    }

    public static String[] getLinesFromMultilines(String string) {
        boolean bl;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(10);
        int n2 = string.indexOf(13);
        if (n < 0 && n2 < 0) {
            return new String[]{string};
        }
        int n3 = 0;
        String[] stringArray = new String[8];
        int n4 = 0;
        do {
            int n5;
            int n6 = 1;
            if (n2 < 0) {
                n5 = n;
                bl = (n = string.indexOf(10, n + 1)) >= 0;
            } else if (n < 0) {
                n5 = n2;
                bl = (n2 = string.indexOf(13, n2 + 1)) >= 0;
            } else if (n < n2) {
                n5 = n;
                bl = true;
                n = string.indexOf(10, n + 1);
            } else {
                n5 = n2++;
                if (n == n2) {
                    n2 = string.indexOf(13, n2 + 1);
                    n = string.indexOf(10, n + 1);
                    bl = n2 >= 0 || n >= 0;
                    n6 = 2;
                } else {
                    n2 = string.indexOf(13, n2 + 1);
                    bl = true;
                }
            }
            if (n3 >= stringArray.length) {
                stringArray = Arrays.copyOf(stringArray, n3 * 2);
            }
            stringArray[n3++] = string.substring(n4, n5);
            n4 = n5 + n6;
        } while (bl);
        if (n3 >= stringArray.length) {
            stringArray = Arrays.copyOf(stringArray, n3 + 1);
        }
        stringArray[n3++] = string.substring(n4);
        return XArrays.resize(stringArray, n3);
    }

    static {
        int n = SPACES.length - 1;
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        Strings.SPACES[n] = new String(cArray).intern();
    }
}

