/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Cloneable;

@ThreadSafe
public class CheckedHashMap<K, V>
extends LinkedHashMap<K, V>
implements Cloneable {
    private static final long serialVersionUID = -7777695267921872849L;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public CheckedHashMap(Class<K> clazz, Class<V> clazz2) {
        this.keyType = clazz;
        this.valueType = clazz2;
        ArgumentChecks.ensureNonNull("keyType", clazz);
        ArgumentChecks.ensureNonNull("valueType", clazz2);
    }

    private static <E> void ensureValidType(E e, Class<E> clazz) throws IllegalArgumentException {
        if (e != null && !clazz.isInstance(e)) {
            throw new IllegalArgumentException(Errors.format(76, e.getClass(), clazz));
        }
    }

    protected void checkWritePermission() throws UnsupportedOperationException {
        assert (Thread.holdsLock(this.getLock()));
    }

    protected Object getLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.getLock();
        synchronized (object) {
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return super.containsKey(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return super.containsValue(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return super.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) throws IllegalArgumentException, UnsupportedOperationException {
        CheckedHashMap.ensureValidType(k, this.keyType);
        CheckedHashMap.ensureValidType(v, this.valueType);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.put(k, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws UnsupportedOperationException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            CheckedHashMap.ensureValidType(entry.getKey(), this.keyType);
            CheckedHashMap.ensureValidType(entry.getValue(), this.valueType);
        }
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) throws UnsupportedOperationException {
        Object object2 = this.getLock();
        synchronized (object2) {
            this.checkWritePermission();
            return super.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return super.equals(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedHashMap<K, V> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return (CheckedHashMap)super.clone();
        }
    }
}

