/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.util.collection.DerivedSet;

public abstract class DerivedMap<BK, K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = -6994867383669885934L;
    protected final Map<BK, V> base;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;
    private final Class<K> keyType;

    public DerivedMap(Map<BK, V> map, Class<K> clazz) {
        this.base = map;
        this.keyType = clazz;
    }

    protected abstract K baseToDerived(BK var1);

    protected abstract BK derivedToBase(K var1);

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty() || super.isEmpty();
    }

    @Override
    public boolean containsValue(Object object) {
        return this.base.containsValue(object);
    }

    @Override
    public boolean containsKey(Object object) {
        if (this.keyType.isInstance(object)) {
            return this.base.containsKey(this.derivedToBase(this.keyType.cast(object)));
        }
        return false;
    }

    @Override
    public V get(Object object) {
        if (this.keyType.isInstance(object)) {
            return this.base.get(this.derivedToBase(this.keyType.cast(object)));
        }
        return null;
    }

    @Override
    public V put(K k, V v) throws UnsupportedOperationException {
        return this.base.put(this.derivedToBase(k), v);
    }

    @Override
    public V remove(Object object) throws UnsupportedOperationException {
        if (this.keyType.isInstance(object)) {
            return this.base.remove(this.derivedToBase(this.keyType.cast(object)));
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this.base.keySet());
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.base.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this.base.entrySet());
        }
        return this.entrySet;
    }

    private static final class Entry<BK, K, V>
    implements Map.Entry<K, V> {
        public final Map.Entry<BK, V> entry;
        private final K derived;

        public Entry(Map.Entry<BK, V> entry, K k) {
            this.entry = entry;
            this.derived = k;
        }

        @Override
        public K getKey() {
            return this.derived;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V v) {
            return this.entry.setValue(v);
        }
    }

    private final class EntrySet
    extends DerivedSet<Map.Entry<BK, V>, Entry<BK, K, V>> {
        private static final long serialVersionUID = -2931806200277420177L;

        public EntrySet(Set<Map.Entry<BK, V>> set) {
            super(set, Entry.class);
        }

        @Override
        protected Entry<BK, K, V> baseToDerived(Map.Entry<BK, V> entry) {
            Object k = DerivedMap.this.baseToDerived(entry.getKey());
            return k != null ? new Entry(entry, k) : null;
        }

        @Override
        protected Map.Entry<BK, V> derivedToBase(Entry<BK, K, V> entry) {
            return entry.entry;
        }
    }

    private final class KeySet
    extends DerivedSet<BK, K> {
        private static final long serialVersionUID = -2931806200277420177L;

        public KeySet(Set<BK> set) {
            super(set, DerivedMap.this.keyType);
        }

        @Override
        protected K baseToDerived(BK BK) {
            return DerivedMap.this.baseToDerived(BK);
        }

        @Override
        protected BK derivedToBase(K k) {
            return DerivedMap.this.derivedToBase(k);
        }
    }
}

