/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.XArrays;

public class LazyList<E>
extends AbstractSequentialList<E> {
    private Iterator<? extends E> iterator;
    private E[] elements;
    private int next;

    public LazyList(Iterator<? extends E> iterator) {
        this.iterator = iterator;
        this.elements = new Object[4];
    }

    private void addNext() {
        if (this.next >= this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, this.next * 2);
        }
        this.elements[this.next++] = this.iterator.next();
    }

    @Override
    public final boolean isEmpty() {
        if (this.next != 0) {
            return false;
        }
        if (this.iterator != null) {
            if (this.iterator.hasNext()) {
                return false;
            }
            this.trimToSize();
        }
        return true;
    }

    @Override
    public final int size() {
        if (this.iterator != null) {
            while (this.iterator.hasNext()) {
                this.addNext();
            }
            this.trimToSize();
        }
        return this.next;
    }

    @Override
    public final E get(int n) throws IndexOutOfBoundsException {
        if (n >= 0) {
            if (n < this.next) {
                return this.elements[n];
            }
            if (this.iterator != null) {
                while (this.iterator.hasNext()) {
                    this.addNext();
                    if (n >= this.next) continue;
                    return this.elements[n];
                }
                this.trimToSize();
            }
        }
        throw new IndexOutOfBoundsException(Errors.format(96, n));
    }

    @Override
    public ListIterator<E> listIterator(int n) throws IndexOutOfBoundsException {
        if (n >= 0) {
            if (n < this.next) {
                return new Iter(n);
            }
            if (this.iterator != null) {
                while (this.iterator.hasNext()) {
                    if (n == this.next) {
                        return new Iter(n);
                    }
                    this.addNext();
                }
                this.trimToSize();
            }
        }
        throw new IndexOutOfBoundsException(Errors.format(96, n));
    }

    private void trimToSize() {
        this.iterator = null;
        this.elements = XArrays.resize(this.elements, this.next);
    }

    final boolean exists(int n) {
        return n < this.next || this.iterator != null && this.iterator.hasNext();
    }

    private final class Iter
    implements ListIterator<E> {
        private int cursor;

        public Iter(int n) {
            this.cursor = n;
        }

        @Override
        public boolean hasNext() {
            return LazyList.this.exists(this.cursor);
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E next() {
            if (!LazyList.this.exists(this.cursor)) {
                throw new NoSuchElementException();
            }
            return LazyList.this.get(this.cursor++);
        }

        @Override
        public E previous() {
            if (this.cursor == 0) {
                throw new NoSuchElementException();
            }
            return LazyList.this.get(--this.cursor);
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

