/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.io.Serializable;
import java.util.AbstractList;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.CheckedCollection;

public class UnmodifiableArrayList<E>
extends AbstractList<E>
implements CheckedCollection<E>,
Serializable {
    private static final long serialVersionUID = -3605810209653785967L;
    private final E[] array;

    protected UnmodifiableArrayList(E ... EArray) {
        if (EArray == null) {
            throw new NullArgumentException(Errors.format(172, "array"));
        }
        this.array = EArray;
    }

    public static <E> UnmodifiableArrayList<E> wrap(E ... EArray) {
        return EArray != null ? new UnmodifiableArrayList<E>(EArray) : null;
    }

    public static <E> UnmodifiableArrayList<E> wrap(E[] EArray, int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n2 > EArray.length || n > n2) {
            throw new IndexOutOfBoundsException(Errors.format(14, n, n2));
        }
        if (n == 0 && n2 == EArray.length) {
            return new UnmodifiableArrayList<E>(EArray);
        }
        return new SubList<E>(EArray, n, n2 - n);
    }

    @Override
    public Class<E> getElementType() {
        return this.array.getClass().getComponentType();
    }

    int lower() {
        return 0;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    public final int arraySize() {
        return this.array.length;
    }

    @Override
    public E get(int n) {
        return this.array[n];
    }

    @Override
    public int indexOf(Object object) {
        int n = this.lower();
        int n2 = n + this.size();
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (this.array[i] != null) continue;
                return i - n;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(this.array[i])) continue;
                return i - n;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.lower();
        int n2 = n + this.size();
        if (object == null) {
            while (--n2 >= n && this.array[n2] != null) {
            }
        } else {
            while (--n2 >= n && !object.equals(this.array[n2])) {
            }
        }
        return n2 - n;
    }

    @Override
    public boolean contains(Object object) {
        int n = this.lower();
        int n2 = n + this.size();
        if (object == null) {
            while (--n2 >= n) {
                if (this.array[n2] != null) continue;
                return true;
            }
        } else {
            while (--n2 >= n) {
                if (!object.equals(this.array[n2])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public UnmodifiableArrayList<E> subList(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException(Errors.format(14, n, n2));
        }
        return new SubList<E>(this.array, n + this.lower(), n2 - n);
    }

    @Override
    public boolean equals(Object object) {
        if (object != this) {
            if (!(object instanceof UnmodifiableArrayList)) {
                return super.equals(object);
            }
            UnmodifiableArrayList unmodifiableArrayList = (UnmodifiableArrayList)object;
            int n = this.size();
            if (n != unmodifiableArrayList.size()) {
                return false;
            }
            int n2 = this.lower();
            int n3 = unmodifiableArrayList.lower();
            while (--n >= 0) {
                if (Utilities.equals(this.array[n2++], unmodifiableArrayList.array[n3++])) continue;
                return false;
            }
        }
        return true;
    }

    private static final class SubList<E>
    extends UnmodifiableArrayList<E> {
        private static final long serialVersionUID = -6297280390649627532L;
        private final int lower;
        private final int size;

        SubList(E[] EArray, int n, int n2) {
            super(EArray);
            this.lower = n;
            this.size = n2;
        }

        @Override
        int lower() {
            return this.lower;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public E get(int n) {
            ArgumentChecks.ensureValidIndex(this.size, n);
            return super.get(n + this.lower);
        }
    }
}

