/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import net.jcip.annotations.NotThreadSafe;
import org.geotoolkit.util.converter.ConverterRegistry;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.ObjectConverter;
import org.geotoolkit.util.logging.Logging;

@NotThreadSafe
public class AnyConverter {
    private ConverterRegistry registry;
    private transient ObjectConverter<?, ?> converter;
    private transient Class<?> source;
    private transient Class<?> target;

    public AnyConverter() {
    }

    public AnyConverter(ConverterRegistry converterRegistry) {
        this.registry = converterRegistry;
    }

    public <T> T convert(Object object, Class<T> clazz) throws NonconvertibleObjectException {
        Class<?> clazz2;
        if (object != null && !clazz.isAssignableFrom(clazz2 = object.getClass())) {
            ObjectConverter<?, Object> objectConverter = this.converter;
            if (objectConverter == null || this.source != clazz2 || this.target != clazz) {
                ConverterRegistry converterRegistry = this.registry;
                if (converterRegistry == null) {
                    this.registry = converterRegistry = ConverterRegistry.system();
                }
                objectConverter = converterRegistry.converter(clazz2, clazz);
                this.converter = objectConverter;
                this.source = clazz2;
                this.target = clazz;
            }
            object = objectConverter.convert(object);
        }
        return (T)object;
    }

    public Object tryConvert(Object object, Class<?> clazz) {
        Class<?> clazz2;
        if (object != null && !clazz.isAssignableFrom(clazz2 = object.getClass())) {
            ObjectConverter<?, ?> objectConverter = this.converter;
            if (this.source != clazz2 || this.target != clazz) {
                ConverterRegistry converterRegistry = this.registry;
                if (converterRegistry == null) {
                    this.registry = converterRegistry = ConverterRegistry.system();
                }
                try {
                    objectConverter = converterRegistry.converter(clazz2, clazz);
                }
                catch (NonconvertibleObjectException nonconvertibleObjectException) {
                    this.conversionFailed(nonconvertibleObjectException);
                    objectConverter = null;
                }
                this.converter = objectConverter;
                this.source = clazz2;
                this.target = clazz;
            }
            if (objectConverter != null) {
                try {
                    object = objectConverter.convert(object);
                }
                catch (NonconvertibleObjectException nonconvertibleObjectException) {
                    this.conversionFailed(nonconvertibleObjectException);
                }
            }
        }
        return object;
    }

    protected void conversionFailed(NonconvertibleObjectException nonconvertibleObjectException) {
        Logging.recoverableException(AnyConverter.class, "tryConvert", nonconvertibleObjectException);
    }

    final ObjectConverter<?, ?> getLastConverter() {
        return this.converter;
    }
}

