/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.converter.Numbers;

public final class Classes
extends Static {
    private static final String[] EXCLUDES = new String[]{"clone", "getClass", "hashCode", "toString", "toWKT"};

    private Classes() {
    }

    public static Class<?> changeArrayDimension(Class<?> clazz, int n) {
        if (n != 0 && clazz != null) {
            if (n < 0) {
                while ((clazz = clazz.getComponentType()) != null && ++n != 0) {
                }
            } else if (clazz != Void.TYPE) {
                StringBuilder stringBuilder = new StringBuilder();
                do {
                    stringBuilder.insert(0, '[');
                } while (--n != 0);
                if (clazz.isPrimitive()) {
                    stringBuilder.append(Numbers.getInternal(clazz));
                } else if (clazz.isArray()) {
                    stringBuilder.append(clazz.getName());
                } else {
                    stringBuilder.append('L').append(clazz.getName()).append(';');
                }
                String string = stringBuilder.toString();
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new TypeNotPresentException(string, classNotFoundException);
                }
            }
        }
        return clazz;
    }

    public static Class<?> boundOfParameterizedAttribute(Field field) {
        return Classes.getActualTypeArgument(field.getGenericType());
    }

    public static Class<?> boundOfParameterizedAttribute(Method method) {
        Type[] typeArray;
        Class<?> clazz = Classes.getActualTypeArgument(method.getGenericReturnType());
        if (clazz == null && (typeArray = method.getGenericParameterTypes()) != null && typeArray.length == 1) {
            clazz = Classes.getActualTypeArgument(typeArray[0]);
        }
        return clazz;
    }

    private static Class<?> getActualTypeArgument(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            while (typeArray != null && typeArray.length == 1) {
                type = typeArray[0];
                if (type instanceof WildcardType) {
                    typeArray = ((WildcardType)type).getUpperBounds();
                    continue;
                }
                int n = 0;
                while (type instanceof GenericArrayType) {
                    type = ((GenericArrayType)type).getGenericComponentType();
                    ++n;
                }
                if (!(type instanceof Class)) break;
                return Classes.changeArrayDimension((Class)type, n);
            }
        }
        return null;
    }

    public static <U> Class<? extends U> asSubclassOrNull(Class<?> clazz, Class<U> clazz2) {
        return clazz != null && clazz2 != null && clazz2.isAssignableFrom(clazz) ? clazz : null;
    }

    public static <T> Class<? extends T> getClass(T t) {
        return t != null ? t.getClass() : null;
    }

    public static <T> Set<Class<? extends T>> getClasses(Collection<? extends T> collection) {
        LinkedHashSet<Class<T>> linkedHashSet = new LinkedHashSet<Class<T>>();
        for (T t : collection) {
            linkedHashSet.add(Classes.getClass(t));
        }
        return linkedHashSet;
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        while (clazz != null) {
            Classes.getAllInterfaces(clazz, linkedHashSet);
            clazz = clazz.getSuperclass();
        }
        return linkedHashSet;
    }

    private static void getAllInterfaces(Class<?> clazz, Set<Class<?>> set) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (!set.add(clazz2)) continue;
            Classes.getAllInterfaces(clazz2, set);
        }
    }

    public static <T> Class<? extends T>[] getLeafInterfaces(Class<?> clazz, Class<T> clazz2) {
        int n = 0;
        Class<?>[] classArray = null;
        while (clazz != null) {
            Class<?>[] classArray2;
            block1: for (Class<?> clazz3 : classArray2 = clazz.getInterfaces()) {
                if (clazz2 != null && !clazz2.isAssignableFrom(clazz3)) continue;
                for (int i = 0; i < n; ++i) {
                    void var10_10 = classArray[i];
                    if (clazz3.isAssignableFrom((Class<?>)var10_10)) continue block1;
                    if (!var10_10.isAssignableFrom(clazz3)) continue;
                    classArray[i] = clazz3;
                    continue block1;
                }
                if (classArray == null) {
                    classArray = classArray2;
                }
                if (n >= classArray.length) {
                    classArray = Arrays.copyOf(classArray, classArray.length + classArray2.length);
                }
                classArray[n++] = clazz3;
            }
            clazz = clazz.getSuperclass();
        }
        return (Class[])XArrays.resize(classArray, n);
    }

    public static Class<?> findSpecializedClass(Collection<?> collection) {
        Set<Class<?>> set = Classes.getClasses(collection);
        set.remove(null);
        Iterator<Class<?>> iterator = set.iterator();
        block0: while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            for (Class<?> clazz2 : set) {
                if (clazz == clazz2 || !clazz.isAssignableFrom(clazz2)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return Classes.common(set);
    }

    private static Class<?> common(Set<Class<?>> set) {
        Iterator<Class<?>> iterator = set.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Class<?> clazz = iterator.next();
        while (iterator.hasNext()) {
            clazz = Classes.findCommonClass(clazz, iterator.next());
        }
        return clazz;
    }

    public static Class<?> findCommonClass(Collection<?> collection) {
        Set<Class<?>> set = Classes.getClasses(collection);
        set.remove(null);
        return Classes.common(set);
    }

    public static Class<?> findCommonClass(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        do {
            if (clazz.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return clazz2;
            }
            clazz = clazz.getSuperclass();
            clazz2 = clazz2.getSuperclass();
        } while (clazz != null && clazz2 != null);
        return Object.class;
    }

    public static Set<Class<?>> findCommonInterfaces(Class<?> clazz, Class<?> clazz2) {
        Set<Class<Class<?>>> set = Classes.getAllInterfaces(clazz);
        Set<Class<?>> set2 = Classes.getAllInterfaces(clazz2);
        set.retainAll(set2);
        Iterator<Class<?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz3 = iterator.next();
            set2.clear();
            Classes.getAllInterfaces(clazz3, set2);
            if (!set.removeAll(set2)) continue;
            iterator = set.iterator();
        }
        return set;
    }

    public static boolean implementSameInterfaces(Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        Class<?> clazz4;
        int n;
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        Class<?>[] classArray2 = clazz2.getInterfaces();
        int n2 = 0;
        for (n = 0; n < classArray2.length; ++n) {
            clazz4 = classArray2[n];
            if (!clazz3.isAssignableFrom(clazz4)) continue;
            classArray2[n2++] = clazz4;
        }
        block1: for (n = 0; n < classArray.length; ++n) {
            clazz4 = classArray[n];
            if (!clazz3.isAssignableFrom(clazz4)) continue;
            for (int i = 0; i < n2; ++i) {
                if (clazz4 != classArray2[i]) continue;
                System.arraycopy(classArray2, i + 1, classArray2, i, --n2 - i);
                continue block1;
            }
            return false;
        }
        return n2 == 0;
    }

    public static String getShortName(Class<?> clazz) {
        if (clazz == null) {
            return "<*>";
        }
        Class<?> clazz2 = clazz.getEnclosingClass();
        while (clazz.isAnonymousClass()) {
            clazz = clazz.getSuperclass();
        }
        String string = clazz.getSimpleName();
        if (clazz2 != null) {
            string = Classes.getShortName(clazz2) + '.' + string;
        }
        return string;
    }

    public static String getShortClassName(Object object) {
        return Classes.getShortName(Classes.getClass(object));
    }

    public static boolean isAssignableTo(Class<?> clazz, Class<?> ... classArray) {
        if (clazz != null) {
            if (classArray == null) {
                return true;
            }
            for (Class<?> clazz2 : classArray) {
                if (clazz2 == null || !clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPossibleGetter(Method method) {
        return method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0 && !method.isSynthetic() && !method.isAnnotationPresent(Deprecated.class) && !XArrays.contains(EXCLUDES, method.getName());
    }
}

